# createsonline/__init__.py
"""
CREATESONLINE - The AI-Native Web Framework

Build Intelligence Into Everything
"""

from pathlib import Path

def _get_version():
    """Get version from VERSION file"""
    version_file = Path(__file__).parent.parent / "VERSION"
    if version_file.exists():
        return version_file.read_text().strip()
    return '0.1.6'

__version__ = _get_version()
__framework_name__ = 'CREATESONLINE'
__tagline__ = 'Build Intelligence Into Everything'
__author__ = 'Ahmed Hassan'
__license__ = 'MIT'

# Import main API
from .app import CreatesonlineInternalApp, create_app
from .server import run_server
from .static_files import StaticFileHandler, serve_static, serve_template

__all__ = [
    'create_app',
    'CreatesonlineInternalApp',
    'run_server',
    'StaticFileHandler',
    'serve_static',
    'serve_template',
    '__version__',
]


