"""Shell completion module for freyja.

This module provides shell completion functionality for CLIs generated by freyja.
Supports bash, zsh, fish, and PowerShell completion.
"""

from .base import CompletionContext, CompletionHandler
from .bash import BashCompletionHandler
from .fish import FishCompletionHandler
from .installer import CompletionInstaller
from .powershell import PowerShellCompletionHandler
from .zsh import ZshCompletionHandler

__all__ = [
  CompletionContext,
  CompletionHandler,
  BashCompletionHandler,
  ZshCompletionHandler,
  FishCompletionHandler,
  PowerShellCompletionHandler,
  CompletionInstaller,
]
