import { Size } from 'aws-cdk-lib';
import * as cognito from 'aws-cdk-lib/aws-cognito';
import * as s3 from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
/**
 * Props for the CloudDuck construct
 */
export interface CloudDuckProps {
    /**
     * The S3 buckets which the cloud duck will analyze
     *
     * @default - All buckets in the account
     */
    readonly targetBuckets?: s3.Bucket[];
    /**
     * The amount of memory to allocate to the Lambda function
     *
     * @default - 1024 MiB
     */
    readonly memory?: Size;
    /**
     * The Cognito UserPool props
     *
     * @default - selfSignUpEnabled: false, signInAliases: { email: true }, autoVerify: { email: true }, removalPolicy: RemovalPolicy.DESTROY
     */
    readonly userPoolProps?: cognito.UserPoolProps;
}
/**
 * The CloudDuck construct
 *
 * This construct creates a serverless analysis environment using DuckDB for S3 data
 */
export declare class CloudDuck extends Construct {
    constructor(scope: Construct, id: string, props?: CloudDuckProps);
}
