"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CloudDuck = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("node:path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const cloudfront = require("aws-cdk-lib/aws-cloudfront");
const origins = require("aws-cdk-lib/aws-cloudfront-origins");
const s3 = require("aws-cdk-lib/aws-s3");
const constructs_1 = require("constructs");
const deploy_time_build_1 = require("deploy-time-build");
const api_1 = require("./constructs/api");
const cognito_1 = require("./constructs/cognito");
/**
 * The CloudDuck construct
 *
 * This construct creates a serverless analysis environment using DuckDB for S3 data
 */
class CloudDuck extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        let distributionDomainName = '';
        const idp = new cognito_1.Cognito(this, 'Cognito', {
            callbackUrls: [aws_cdk_lib_1.Lazy.string({ produce: () => `https://${distributionDomainName}` })],
            logoutUrls: [aws_cdk_lib_1.Lazy.string({ produce: () => `https://${distributionDomainName}` })],
            userPoolProps: props?.userPoolProps,
        });
        const api = new api_1.Api(this, 'Api', {
            userPool: idp.userPool,
            targetBuckets: props?.targetBuckets,
            memory: props?.memory,
        });
        const hostingBucket = new s3.Bucket(this, 'HostingBucket', {
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
            autoDeleteObjects: true,
        });
        const distribution = new cloudfront.Distribution(this, 'CloudFront', {
            defaultRootObject: 'index.html',
            defaultBehavior: {
                origin: origins.S3BucketOrigin.withOriginAccessControl(hostingBucket),
                responseHeadersPolicy: cloudfront.ResponseHeadersPolicy.CORS_ALLOW_ALL_ORIGINS,
            },
            // additionalBehaviors: {
            //   "/api/*": {
            //     origin: new origins.RestApiOrigin(api.api, {
            //       originPath: "/api",
            //     }),
            //     responseHeadersPolicy: new cloudfront.ResponseHeadersPolicy(scope, 'ResponsePolicy', {
            //       corsBehavior: {
            //         accessControlAllowCredentials: true,
            //         accessControlAllowHeaders: ['Authorization', 'Content-Type'],
            //         accessControlAllowMethods: ['GET', 'POST', 'PUT', 'DELETE', 'OPTIONS'],
            //         accessControlAllowOrigins: [
            //           // `https://${this.domainName}`,
            //           "*"
            //         ],
            //         originOverride: true
            //       }
            //     }),
            //     cachePolicy: cloudfront.CachePolicy.CACHING_DISABLED,
            //     viewerProtocolPolicy: cloudfront.ViewerProtocolPolicy.HTTPS_ONLY,
            //     allowedMethods: cloudfront.AllowedMethods.ALLOW_ALL,
            //     originRequestPolicy: cloudfront.OriginRequestPolicy.ALL_VIEWER_EXCEPT_HOST_HEADER,
            //   },
            // },
        });
        distributionDomainName = distribution.distributionDomainName;
        new deploy_time_build_1.NodejsBuild(this, 'Build', {
            assets: [
                {
                    path: path.join(__dirname, '../frontend'),
                    exclude: ['node_modules', 'build'],
                },
            ],
            destinationBucket: hostingBucket,
            distribution,
            outputSourceDirectory: 'build/client',
            buildCommands: ['npm ci', 'npm run build'],
            buildEnvironment: {
                VITE_COGNITO_USER_POOL_ID: idp.userPool.userPoolId,
                VITE_COGNITO_USER_POOL_CLIENT_ID: idp.appClient.userPoolClientId,
                VITE_COGNITO_REGION: idp.userPool.stack.region,
                VITE_API_ROOT: `${api.api.url}v1`,
                VITE_AWS_ACCOUNT_ID: aws_cdk_lib_1.Stack.of(this).account,
                // VITE_API_ROOT: `https://${distributionDomainName}/api/v1`,
            },
        });
        new aws_cdk_lib_1.CfnOutput(this, 'DistributionUrl', {
            value: `https://${distributionDomainName}`,
        });
    }
}
exports.CloudDuck = CloudDuck;
_a = JSII_RTTI_SYMBOL_1;
CloudDuck[_a] = { fqn: "cloud-duck.CloudDuck", version: "0.0.18" };
//# sourceMappingURL=data:application/json;base64,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