# Code of Conduct

## Our Pledge

In the interest of fostering an open and welcoming environment, we as contributors and maintainers pledge to making participation in our project and our community a harassment-free experience for everyone, regardless of age, body size, disability, ethnicity, sex characteristics, gender identity and expression, level of experience, education, socio-economic status, nationality, personal appearance, race, religion, or sexual identity and orientation.

## Our Standards

Examples of behavior that contributes to creating a positive environment include:

* Using welcoming and inclusive language
* Being respectful of differing viewpoints and experiences
* Gracefully accepting constructive criticism
* Focusing on what is best for the community
* Showing empathy towards other community members
* Prioritizing mathematical rigor and honest performance reporting

Examples of unacceptable behavior by participants include:

* The use of sexualized language or imagery and unwelcome sexual attention or advances
* Trolling, insulting/derogatory comments, and personal or political attacks
* Public or private harassment
* Publishing others' private information, such as a physical or electronic address, without explicit permission
* Promoting solutions that obscure algorithmic transparency
* Other conduct which could reasonably be considered inappropriate in a professional setting

## Our Responsibilities

Project maintainers are responsible for clarifying the standards of acceptable behavior and are expected to take appropriate and fair corrective action in response to any instances of unacceptable behavior.

Project maintainers have the right and responsibility to remove, edit, or reject comments, commits, code, wiki edits, issues, and other contributions that are not aligned to this Code of Conduct, or to ban temporarily or permanently any contributor for other behaviors that they deem inappropriate, threatening, offensive, or harmful.

## Scope

This Code of Conduct applies both within project spaces and in public spaces when an individual is representing the project or its community. Examples of representing a project or community include using an official project e-mail address, posting via an official social media account, or acting as an appointed representative at an online or offline event. Representation of a project may be further defined and clarified by project maintainers.

## Technical Standards

In addition to general conduct standards, we maintain specific technical principles:

### Mathematical Transparency
- All routing decisions must be based on deterministic mathematical analysis
- Performance claims must be backed by reproducible benchmarks
- Algorithm complexity and limitations must be clearly documented
- \"Black box\" approaches are discouraged in favor of explainable methods

### Quality Standards
- Code must include comprehensive tests and documentation
- Performance regressions must be documented and justified
- Breaking changes require clear migration paths
- All contributions must maintain backward compatibility when possible

### Community Principles
- Technical discussions should focus on mathematical and engineering merit
- Constructive criticism is welcome and encouraged
- Attribution for ideas and contributions is required
- Open source philosophy and community collaboration are prioritized

## Enforcement

Instances of abusive, harassing, or otherwise unacceptable behavior may be reported via the repository's [Security Policy](https://github.com/Hmbown/ariadne/security/policy) or by contacting the maintainers through GitHub Discussions.

Project maintainers who do not follow or enforce the Code of Conduct in good faith may face temporary or permanent repercussions as determined by other members of the project's leadership.

## Attribution

This Code of Conduct is adapted from the [Contributor Covenant][homepage], version 1.4, available at https://www.contributor-covenant.org/version/1/4/code-of-conduct.html

[homepage]: https://www.contributor-covenant.org

For answers to common questions about this code of conduct, see https://www.contributor-covenant.org/faq

## Contact

For questions about this Code of Conduct or to report violations:
- Project discussions: [GitHub Discussions](https://github.com/Hmbown/ariadne/discussions)
- Security issues: See [SECURITY.md](SECURITY.md)

---

*\"Take agency back from the agents\" - we believe in transparent, mathematical approaches to quantum computing that empower users rather than obscure decisions.*
