# Contributing to Ariadne

We welcome contributions! By participating in this project, you agree to abide by our [Code of Conduct](CODE_OF_CONDUCT.md).

## Submitting Issues

*   **Search existing issues:** Before submitting a new issue, please check if a similar issue already exists.
*   **Provide details:** Clearly describe the issue, including steps to reproduce, expected behavior, and actual behavior. Include your environment details (OS, Python version, dependencies).

## Submitting Pull Requests (PRs)

1.  **Fork the repository** and create your branch from `main`.
2.  **Develop your changes.** Ensure your code adheres to the project's style guidelines (enforced by `ruff` and `pre-commit`).
3.  **Write tests** that cover your changes. All tests must pass.
4.  **Document your changes.** Update any relevant documentation, including docstrings and markdown files.
5.  **Architectural Decisions:** If your PR involves significant changes to routing or core logic, please review the architectural decisions documented in [`docs/router_decisions.md`](docs/router_decisions.md) to ensure alignment with the project's direction.
6.  **Create the PR:** Submit your pull request against the `main` branch. Provide a clear title and description of your changes.

Thank you for contributing!
