# Ariadne Quantum Simulator Documentation

## Welcome to Ariadne

Ariadne is a zero-configuration quantum simulator bundle that automatically routes your circuits to the optimal backend. Whether you're teaching quantum computing, running benchmarks across platforms, or setting up CI pipelines, Ariadne ensures reproducible results without the complexity of manual backend selection.

### Choose Your Path

Select the documentation path that best matches your role:

#### [For Classroom Instructors](./getting-started/for-instructors.md)
Learn how to set up Ariadne for classroom demonstrations, student exercises, and educational activities.

#### [For Research Scientists](./getting-started/for-researchers.md)
Discover advanced features, performance analysis tools, and reproducible benchmarking capabilities.

#### [For DevOps Engineers](./getting-started/for-devops.md)
Explore installation, configuration, and integration with CI/CD pipelines.

---

## Quick Navigation

- [Getting Started](./getting-started/for-instructors.md) - Begin your journey with Ariadne
- [Core Concepts](./user-guide/core-concepts.md) - Understand how Ariadne works
- [Algorithm Library](./tutorials/education/algorithms.md) - Explore the 15+ quantum algorithms
- [API Reference](./user-guide/api-reference.md) - Detailed API documentation
- [CLI Guide](./user-guide/cli-reference.md) - Command-line interface reference
- [Troubleshooting](./reference/troubleshooting.md) - Common issues and solutions

---

## Available Quantum Algorithms

Ariadne includes 15+ quantum algorithms across multiple categories:

**Foundational:**
- Bell States (entanglement)
- GHZ States (multipartite entanglement)
- Quantum Fourier Transform (QFT)
- Quantum Phase Estimation (QPE)

**Search Algorithms:**
- Grover's Search (quadratic speedup)
- Bernstein-Vazirani (linear speedup)

**Optimization:**
- QAOA (Quantum Approximate Optimization Algorithm)
- VQE (Variational Quantum Eigensolver)

**Error Correction:**
- Steane Code [[7,1,3]] CSS code
- Surface Code (simplified)

**Machine Learning:**
- QSVM (Quantum Support Vector Machine)
- VQC (Variational Quantum Classifier)
- Quantum Neural Network

**Specialized:**
- Deutsch-Jozsa (constant vs balanced functions)
- Simon's Algorithm (period finding)
- Quantum Walk (search enhancement)
- Amplitude Amplification (generalization of Grover)
