# mypy-boto3-connect

[![PyPI - mypy-boto3-connect](https://img.shields.io/pypi/v/mypy-boto3-connect.svg?color=blue)](https://pypi.org/project/mypy-boto3-connect)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-connect.svg?color=blue)](https://pypi.org/project/mypy-boto3-connect)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.Connect 1.14.55](https://boto3.amazonaws.com/v1/documentation/api/1.14.55/reference/services/connect.html#Connect) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.0.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-connect](#mypy-boto3-connect)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `Connect` service.

```bash
python -m pip install boto3-stubs[connect]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[connect]` in your environment: `python -m pip install 'boto3-stubs[connect]'`

Both type checking and auto-complete should work for `Connect` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[connect]` in your environment: `python -m pip install 'boto3-stubs[connect]'`

Both type checking and auto-complete should work for `Connect` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[connect]` in your environment: `python -m pip install 'boto3-stubs[connect]'`
- Run `mypy` as usual

Type checking should work for `Connect` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[connect]` in your environment: `python -m pip install 'boto3-stubs[connect]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `Connect` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`ConnectClient` provides annotations for `boto3.client("connect")`.

```python
import boto3

from mypy_boto3_connect import ConnectClient

client: ConnectClient = boto3.client("connect")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ConnectClient = session.client("connect")
```

### Paginators annotations

`mypy_boto3_connect.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_connect import ConnectClient
from mypy_boto3_connect.paginator import (
    GetMetricDataPaginator,
    ListContactFlowsPaginator,
    ListHoursOfOperationsPaginator,
    ListPhoneNumbersPaginator,
    ListQueuesPaginator,
    ListRoutingProfilesPaginator,
    ListSecurityProfilesPaginator,
    ListUserHierarchyGroupsPaginator,
    ListUsersPaginator,
)

client: ConnectClient = boto3.client("connect")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
get_metric_data_paginator: GetMetricDataPaginator = client.get_paginator("get_metric_data")
list_contact_flows_paginator: ListContactFlowsPaginator = client.get_paginator("list_contact_flows")
list_hours_of_operations_paginator: ListHoursOfOperationsPaginator = client.get_paginator("list_hours_of_operations")
list_phone_numbers_paginator: ListPhoneNumbersPaginator = client.get_paginator("list_phone_numbers")
list_queues_paginator: ListQueuesPaginator = client.get_paginator("list_queues")
list_routing_profiles_paginator: ListRoutingProfilesPaginator = client.get_paginator("list_routing_profiles")
list_security_profiles_paginator: ListSecurityProfilesPaginator = client.get_paginator("list_security_profiles")
list_user_hierarchy_groups_paginator: ListUserHierarchyGroupsPaginator = client.get_paginator("list_user_hierarchy_groups")
list_users_paginator: ListUsersPaginator = client.get_paginator("list_users")
```







### Typed dictionations

`mypy_boto3_connect.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_connect.type_defs import (
    ChatMessageTypeDef,
    ContactFlowSummaryTypeDef,
    CreateUserResponseTypeDef,
    CredentialsTypeDef,
    CurrentMetricDataTypeDef,
    CurrentMetricResultTypeDef,
    CurrentMetricTypeDef,
    DescribeUserHierarchyGroupResponseTypeDef,
    DescribeUserHierarchyStructureResponseTypeDef,
    DescribeUserResponseTypeDef,
    DimensionsTypeDef,
    FiltersTypeDef,
    GetContactAttributesResponseTypeDef,
    GetCurrentMetricDataResponseTypeDef,
    GetFederationTokenResponseTypeDef,
    GetMetricDataResponseTypeDef,
    HierarchyGroupSummaryTypeDef,
    HierarchyGroupTypeDef,
    HierarchyLevelTypeDef,
    HierarchyPathTypeDef,
    HierarchyStructureTypeDef,
    HistoricalMetricDataTypeDef,
    HistoricalMetricResultTypeDef,
    HistoricalMetricTypeDef,
    HoursOfOperationSummaryTypeDef,
    ListContactFlowsResponseTypeDef,
    ListHoursOfOperationsResponseTypeDef,
    ListPhoneNumbersResponseTypeDef,
    ListQueuesResponseTypeDef,
    ListRoutingProfilesResponseTypeDef,
    ListSecurityProfilesResponseTypeDef,
    ListTagsForResourceResponseTypeDef,
    ListUserHierarchyGroupsResponseTypeDef,
    ListUsersResponseTypeDef,
    PaginatorConfigTypeDef,
    ParticipantDetailsTypeDef,
    PhoneNumberSummaryTypeDef,
    QueueReferenceTypeDef,
    QueueSummaryTypeDef,
    RoutingProfileSummaryTypeDef,
    SecurityProfileSummaryTypeDef,
    StartChatContactResponseTypeDef,
    StartOutboundVoiceContactResponseTypeDef,
    ThresholdTypeDef,
    UserIdentityInfoTypeDef,
    UserPhoneConfigTypeDef,
    UserSummaryTypeDef,
    UserTypeDef,
    VoiceRecordingConfigurationTypeDef,
)

def get_structure() -> ContactFlowSummaryTypeDef:
    return {
      ...
    }
```
