from typing import Literal
import zarr
import numpy.typing as npt


def zarr_astype(self: zarr.Array, dtype: npt.DTypeLike, order: Literal["K", "A", "C", "F"] = "K", copy: bool = True):
    return self[:].astype(dtype, order=order, copy=copy)  # pyright: ignore[reportUnknownVariableType, reportAttributeAccessIssue]


zarr.Array.__len__ = lambda self: self.shape[0]  # pyright: ignore[reportAttributeAccessIssue]
zarr.Array.astype = zarr_astype  # pyright: ignore[reportAttributeAccessIssue]
