# R-Group mols (76185, 26399)
r_group = {
    76185: {
        "molfile": "\n  Mrv0541 11121316402D          \n\n 20 19  0  0  0  0            999 V2000\n    5.1512    0.7444    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    4.4368    1.1569    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    3.7223    0.7444    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    3.0079    1.1569    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    2.2934    0.7444    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    1.5789    1.1569    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    0.8645    0.7444    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    0.8645   -0.0806    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    0.1500   -0.4931    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    5.8657    1.1569    0.0000 R   0  0  0  0  0  0  0  0  0  0  0  0\n    0.1500   -1.3181    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    0.8645   -1.7306    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    0.8645   -2.5555    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    1.5789   -2.9681    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    2.2934   -2.5555    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    3.0079   -2.9681    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    3.7223   -2.5555    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    3.7223   -1.7306    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    4.4368   -1.3181    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    5.1512   -0.0806    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  1  2  1  0  0  0  0\n  2  3  1  0  0  0  0\n  3  4  1  0  0  0  0\n  4  5  1  0  0  0  0\n  5  6  1  0  0  0  0\n  6  7  2  0  0  0  0\n  7  8  1  0  0  0  0\n  8  9  1  0  0  0  0\n  1 10  1  0  0  0  0\n 11  9  2  0  0  0  0\n 12 11  1  0  0  0  0\n 13 12  1  0  0  0  0\n 14 13  2  0  0  0  0\n 15 14  1  0  0  0  0\n 16 15  1  0  0  0  0\n 17 16  2  0  0  0  0\n 18 17  1  0  0  0  0\n 19 18  1  0  0  0  0\n 20  1  2  0  0  0  0\nM  END\n",
        "mol_formula": "C18H27OR",
        "avg_mass": 259.41299999999995,
        "monoisotopic_mass": 259.20619,
        "net_charge": 0,
    },
    26399: {
        "molfile": "\n  Ketcher 06151811402D 1   1.00000     0.00000     0\n\n 10 10  0     1  0            999 V2000\n   10.9985   -3.4662    0.0000 R   0  0  0  0  0  0  0  0  0  0  0  0\n   11.3076   -4.4174    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   10.7197   -5.2263    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   11.3074   -6.0354    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   10.9984   -6.9864    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   11.6676   -7.7295    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   12.2585   -5.7263    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   13.0675   -6.3142    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   12.2585   -4.7264    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   13.0676   -4.1388    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  2  1  1  1     0  0\n  2  3  1  0     0  0\n  2  9  1  0     0  0\n  3  4  1  0     0  0\n  4  5  1  1     0  0\n  4  7  1  0     0  0\n  5  6  1  0     0  0\n  7  8  1  6     0  0\n  7  9  1  0     0  0\n  9 10  1  6     0  0\nM  END\n",
        "mol_formula": "C5H9O4R",
        "avg_mass": 133.123,
        "monoisotopic_mass": 133.05008,
        "net_charge": 0,
    },
}

# Multiple R-Group mols (52595, 77272)
m_r_groups = {
    52595: {
        "molfile": "\n  Marvin  06170915082D          \n\n 10  9  0  0  0  0            999 V2000\n   -3.4915    0.0159    0.0000 R#  0  0  0  0  0  0  0  0  0  0  0  0\n   -4.2059   -0.3966    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -6.3493    0.0159    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   -7.0638   -0.3966    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -5.6349   -0.3966    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n   -4.9204    0.0159    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   -5.6348   -1.2216    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -4.9203   -1.6340    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   -4.9202   -2.4590    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -4.2059   -1.2214    0.0000 R#  0  0  0  0  0  0  0  0  0  0  0  0\n  1  2  1  0  0  0  0\n  4  3  1  0  0  0  0\n  5  3  1  0  0  0  0\n  5  7  1  1  0  0  0\n  5  6  1  0  0  0  0\n  2  6  1  0  0  0  0\n  7  8  1  0  0  0  0\n  8  9  2  0  0  0  0\n  8 10  1  0  0  0  0\nM  RGP  1   1   1\nM  END\n",
        "mol_formula": "C4H6O4R2",
        "avg_mass": 118.088,
        "monoisotopic_mass": 118.02661,
        "net_charge": 0,
    },
    77272: {
        "molfile": "\n  Mrv0541 08131417202D          \n\n 12 11  0  0  0  0            999 V2000\n   -3.3295    1.8562    0.0000 R#  0  0  0  0  0  0  0  0  0  0  0  0\n   -2.6150    2.2687    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   -1.9005    1.8562    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -1.1861    2.2687    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   -0.4716    1.8562    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n    0.2429    2.2687    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    0.9574    1.8562    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    1.6718    2.2687    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    2.3863    1.8562    0.0000 R#  0  0  0  0  0  0  0  0  0  0  0  0\n   -0.4716    1.0312    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -2.6150    3.0937    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    1.6718    3.0937    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  1  2  1  0  0  0  0\n  2  3  1  0  0  0  0\n  3  4  1  0  0  0  0\n  4  5  1  0  0  0  0\n  5  6  1  0  0  0  0\n  6  7  1  0  0  0  0\n  7  8  1  0  0  0  0\n  8  9  1  0  0  0  0\n  5 10  1  6  0  0  0\n  2 11  2  0  0  0  0\n  8 12  2  0  0  0  0\nM  RGP  2   1   1   9   2\nM  END\n",
        "mol_formula": "C5H6O5R2",
        "avg_mass": 146.098,
        "monoisotopic_mass": 146.02152,
        "net_charge": 0,
    },
}

# group (*), single point of attachment
single_star = {
    47265: {
        "molfile": "\n  Marvin  11210717262D          \n\n  2  1  0  0  0  0            999 V2000\n    0.4125    0.0000    0.0000 Br  0  0  0  0  0  0  0  0  0  0  0  0\n   -0.4125    0.0000    0.0000 *   0  0  0  0  0  0  0  0  0  0  0  0\n  1  2  1  0  0  0  0\nM  END\n",
        "mol_formula": "Br",
        "avg_mass": 79.90400,
        "monoisotopic_mass": 78.91834,
        "net_charge": 0,
    },
    142521: {
        "molfile": "\n  Ketcher 11081809362D 1   1.00000     0.00000     0\n\n 47 49  0     1  0            999 V2000\n   15.2563  -22.6837    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   15.2563  -23.6964    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   16.1001  -22.1774    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   14.3786  -22.9200    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   16.1340  -24.1689    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   16.9779  -22.6837    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   16.9779  -23.6626    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   16.1340  -25.1817    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   17.8218  -22.1774    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   17.8218  -24.1689    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n   15.2900  -25.6544    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   17.0115  -25.6544    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   18.6994  -23.6626    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   14.4461  -25.1817    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   15.2900  -26.6332    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   18.6994  -22.6498    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   19.5433  -24.1353    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   14.4461  -27.1396    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   13.6696  -22.2111    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   14.1085  -23.8990    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   17.0115  -24.6753    0.0000 H   0  0  0  0  0  0  0  0  0  0  0  0\n   11.8936  -20.2818    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   11.0162  -20.7879    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   11.8936  -19.2686    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   10.1391  -20.2805    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   11.0162  -21.8010    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n   11.0165  -18.7613    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   10.1394  -19.2673    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    9.2910  -20.7697    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   10.1390  -22.3071    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   10.9873  -17.7648    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    9.2620  -18.7599    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   10.1390  -23.3202    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    9.2618  -21.7998    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   10.0960  -17.2843    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   12.7706  -20.7883    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   14.4920  -21.7336    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   14.4920  -20.8224    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   13.6481  -20.3160    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   15.3697  -20.3160    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   13.6481  -19.3033    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   15.3697  -19.3033    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   16.2138  -20.8224    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   14.4920  -18.8305    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   12.7706  -18.8305    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   16.2138  -18.8305    0.0000 *   0  0  0  0  0  0  0  0  0  0  0  0\n   12.7407  -17.8182    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  1  2  1  0     0  0\n  1  3  1  0     0  0\n  1  4  1  1     0  0\n  2  5  1  0     0  0\n  3  6  1  0     0  0\n  5  7  1  0     0  0\n  5  8  1  0     0  0\n  6  9  1  6     0  0\n  7 10  1  1     0  0\n  8 11  1  0     0  0\n  8 12  1  6     0  0\n 10 13  1  0     0  0\n 11 14  1  1     0  0\n 11 15  1  0     0  0\n 13 16  2  0     0  0\n 13 17  1  0     0  0\n 15 18  1  0     0  0\n  6  7  1  0     0  0\n  4 19  1  0     0  0\n  4 20  2  0     0  0\n  5 21  1  1     0  0\n 22 23  1  0     0  0\n 22 24  1  0     0  0\n 23 25  1  0     0  0\n 23 26  1  6     0  0\n 24 27  1  0     0  0\n 25 28  1  0     0  0\n 25 29  1  1     0  0\n 26 30  1  0     0  0\n 27 31  1  1     0  0\n 28 32  1  1     0  0\n 30 33  1  0     0  0\n 30 34  2  0     0  0\n 27 28  1  0     0  0\n 31 35  1  0     0  0\n 22 36  1  1     0  0\n 38 37  1  1     0  0\n 38 39  1  0     0  0\n 38 40  1  0     0  0\n 39 41  1  0     0  0\n 39 36  1  1     0  0\n 40 42  1  0     0  0\n 40 43  1  6     0  0\n 41 44  1  0     0  0\n 41 45  1  1     0  0\n 42 46  1  1     0  0\n 42 44  1  0     0  0\n 45 47  1  0     0  0\n  1 37  1  6     0  0\nM  END\n",
        "mol_formula": "C25H41N2O18",
        "avg_mass": 657.5990000000003,
        "monoisotopic_mass": 657.23544,
        "net_charge": 0,
    },
}

# polymers: can be homopolymers, co-polymers etc. (85119, 4439, 137080, 76109)
polymers = {
    85119: {
        "molfile": "\n  Mrv0541 03051516352D          \n\n 16 16  0  0  0  0            999 V2000\n    1.3941    0.4970    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    0.6796    0.0845    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    0.6796   -0.7405    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    1.3941   -1.1530    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    2.1085   -0.7405    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    2.1085    0.0845    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    1.3941    1.3220    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    2.0586    1.7595    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   -0.0462    1.3187    0.0000 *   0  0  0  0  0  0  0  0  0  0  0  0\n    3.8186    1.7596    0.0000 *   0  0  0  0  0  0  0  0  0  0  0  0\n    1.3941   -1.9780    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    0.6796   -2.3905    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    2.8230   -1.1529    0.0000 S   0  0  0  0  0  0  0  0  0  0  0  0\n    3.5374   -0.7404    0.0000 O   0  5  0  0  0  0  0  0  0  0  0  0\n    2.4105   -1.8674    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    3.2355   -1.8674    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  1  2  1  0  0  0  0\n  1  6  2  0  0  0  0\n  2  3  2  0  0  0  0\n  3  4  1  0  0  0  0\n  4  5  2  0  0  0  0\n  5  6  1  0  0  0  0\n  1  7  1  0  0  0  0\n  7  8  1  0  0  0  0\n  7  9  1  0  0  0  0\n  8 10  1  0  0  0  0\n  4 11  1  0  0  0  0\n 11 12  1  0  0  0  0\n  5 13  1  0  0  0  0\n 13 14  1  0  0  0  0\n 13 15  2  0  0  0  0\n 13 16  2  0  0  0  0\nM  CHG  1  14  -1\nM  STY  1   1 SRU\nM  SCN  1   1 HT \nM  SAL   1 14   7   1   6   5  13  16  15  14   4  11  12   3   2   8\nM  SDI   1  4    3.1154    2.2486    3.1099    1.2586\nM  SDI   1  4    0.6470    0.8198    0.6375    1.8097\nM  SBL   1  2   9  10\nM  SMT   1 n\nM  END\n",
        "mol_formula": "(C9H9O4S)n",
        "net_charge": None,
    },
    4439: {
        "molfile": "\n  Marvin  11091214282D          \n\n 28 29  0  0  1  0            999 V2000\n   11.1054   -6.0718    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n   11.1054   -6.8968    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n   11.8198   -7.3093    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n   12.5342   -6.8968    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n   12.5342   -6.0718    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n   11.8198   -5.6593    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    8.2458   -6.9332    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   13.2597   -7.3158    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   11.8198   -8.1343    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   10.3908   -5.6593    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    9.6864   -6.0662    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   10.3908   -4.8344    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   13.2486   -5.6593    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   13.2486   -4.5933    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n   13.9558   -4.1846    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n   13.9558   -3.3596    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n   13.2411   -2.9226    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   12.5337   -3.3560    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n   12.5339   -4.1810    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n   14.6604   -2.9526    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   11.8222   -2.9454    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   11.8227   -4.5918    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   14.6573   -4.5894    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n   14.6573   -5.4181    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   15.3601   -5.8238    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   17.4167   -2.9972    0.0000 H   0  0  0  0  0  0  0  0  0  0  0  0\n   13.9313   -5.8377    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   11.8219   -2.1204    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  1  2  1  0  0  0  0\n  2  3  1  0  0  0  0\n  3  4  1  0  0  0  0\n  4  5  1  0  0  0  0\n  5  6  1  0  0  0  0\n  1  6  1  0  0  0  0\n  2  7  1  6  0  0  0\n  4  8  1  6  0  0  0\n  3  9  1  1  0  0  0\n  1 10  1  6  0  0  0\n 10 11  1  0  0  0  0\n 10 12  2  0  0  0  0\n  5 13  1  1  0  0  0\n 14 15  1  0  0  0  0\n 15 16  1  0  0  0  0\n 16 17  1  0  0  0  0\n 17 18  1  0  0  0  0\n 18 19  1  0  0  0  0\n 14 19  1  0  0  0  0\n 14 13  1  1  0  0  0\n 16 20  1  1  0  0  0\n 18 21  1  1  0  0  0\n 19 22  1  1  0  0  0\n 15 23  1  6  0  0  0\n 23 24  1  0  0  0  0\n 24 25  1  0  0  0  0\n 20 26  1  0  0  0  0\n 24 27  2  0  0  0  0\n 21 28  1  0  0  0  0\nM  STY  1   1 SRU\nM  SCN  1   1 HT \nM  SAL   1 15   1   2   3   4   5   6   8   9  10  11  12  13  14  15  16\nM  SAL   1 11  17  18  19  20  21  22  23  24  25  27  28\nM  SDI   1  4   15.8020   -2.5585   15.7887   -3.3834\nM  SDI   1  4    9.9332   -7.3243    9.9227   -6.4993\nM  SBL   1  2   7  27\nM  SMT   1 n\nM  END\n",
        "mol_formula": "(C14H21NO11)n.H2O",
        "net_charge": 0,
    },
    137080: {
        "molfile": "\n  Ketcher 05291721232D 1   1.00000     0.00000     0\n\n 81 80  0     1  0            999 V2000\n    3.9258  -12.8487    0.0000 Na  0  0  0  0  0  0  0  0  0  0  0  0\n    4.4219  -16.1486    0.0000 Na  0  0  0  0  0  0  0  0  0  0  0  0\n   26.0254   -9.6755    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   25.2503   -9.2279    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   25.2505   -8.3327    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   24.4751   -7.8851    0.0000 S   0  0  0  0  0  0  0  0  0  0  0  0\n   23.7000   -8.3325    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   22.9248   -7.8848    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   22.1495   -8.3323    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n   22.9249   -6.9897    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   21.3744   -7.8845    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   21.3745   -6.9893    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   20.5994   -6.5418    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   20.5996   -5.6467    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   21.2351   -4.8498    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   22.0104   -4.4023    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n   20.4598   -3.5071    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   20.4598   -4.4023    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   24.9544   -4.3636    0.0000 *   0  0  0  0  0  0  0  0  0  0  0  0\n   21.8795   -5.6819    0.0000 H   0  0  0  0  0  0  0  0  0  0  0  0\n   24.4749   -9.6753    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   26.0253  -10.5708    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   18.5025   -4.4118    0.0000 *   0  0  0  0  0  0  0  0  0  0  0  0\n   10.3536  -10.4843    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    9.5784  -10.9319    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    9.5784  -11.8271    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    8.8032  -10.4843    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    8.8032  -12.2748    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    8.0280  -10.9319    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    8.0280  -11.8271    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   10.3536  -12.2748    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    8.8032  -13.1699    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    7.2527  -12.2748    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    7.2527  -10.4843    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    6.4778  -10.9319    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    8.0278  -13.6173    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    8.0278  -14.5123    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    7.2527  -13.1699    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    7.2527  -14.9599    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    6.4775  -13.6173    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    6.4775  -14.5123    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    8.8032  -14.9599    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    7.2527  -15.8552    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    5.7023  -14.9599    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    5.7023  -13.1699    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    4.9270  -13.6173    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    5.7023  -12.2748    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    6.4775  -16.3026    0.0000 S   0  0  0  0  0  0  0  0  0  0  0  0\n    6.9251  -17.0778    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    6.0300  -15.5275    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    5.7023  -16.7502    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   11.1287  -10.9319    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   11.9041  -10.4845    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   11.1287  -11.8271    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   12.6792  -10.9320    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   11.9039  -12.2746    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   12.6791  -11.8272    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   13.4543  -12.2748    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   14.2294  -11.8273    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   14.2297  -10.9321    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n   15.0049  -10.4847    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   15.7800  -10.9324    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   15.0050   -9.5894    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   14.2297   -9.1418    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   14.2299   -8.2467    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   13.4548   -7.7989    0.0000 S   0  0  0  0  0  0  0  0  0  0  0  0\n   12.6797   -8.2463    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   11.9045   -7.7987    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   11.1292   -8.2462    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n   11.9047   -6.9037    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   10.3542   -7.7985    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   10.3543   -6.9033    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    9.5792   -6.4557    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    9.5793   -5.5605    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   10.2148   -4.7638    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   10.9901   -4.3163    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n    9.4396   -3.4211    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    9.4396   -4.3163    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    5.4121   -4.3108    0.0000 *   0  0  0  0  0  0  0  0  0  0  0  0\n   10.8485   -5.6281    0.0000 H   0  0  0  0  0  0  0  0  0  0  0  0\n   13.4487   -4.3140    0.0000 *   0  0  0  0  0  0  0  0  0  0  0  0\n  3  4  1  0     0  0\n  4  5  1  0     0  0\n  5  6  1  0     0  0\n  6  7  1  0     0  0\n  7  8  1  0     0  0\n  8  9  1  0     0  0\n  8 10  2  0     0  0\n  9 11  1  0     0  0\n 11 12  1  0     0  0\n 12 13  1  0     0  0\n 13 14  1  0     0  0\n 15 14  1  1     0  0\n 15 16  1  0     0  0\n 18 15  1  0     0  0\n 18 17  2  0     0  0\n 16 19  1  0     0  0\n 15 20  1  6     0  0\n  4 21  1  0     0  0\n  3 22  1  0     0  0\n 18 23  1  0     0  0\n 25 26  1  0     0  0\n 25 27  1  0     0  0\n 26 28  1  0     0  0\n 27 29  1  0     0  0\n 28 30  1  0     0  0\n 29 30  1  0     0  0\n 25 24  1  1     0  0\n 26 31  1  6     0  0\n 28 32  1  1     0  0\n 30 33  1  1     0  0\n 29 34  1  1     0  0\n 35 34  1  0     0  0\n 36 37  1  0     0  0\n 36 38  1  0     0  0\n 37 39  1  0     0  0\n 38 40  1  0     0  0\n 39 41  1  0     0  0\n 40 41  1  0     0  0\n 36 32  1  1     0  0\n 37 42  1  6     0  0\n 39 43  1  1     0  0\n 41 44  1  6     0  0\n 40 45  1  1     0  0\n 46 45  1  0     0  0\n 45 47  2  0     0  0\n 49 48  2  0     0  0\n 50 48  2  0     0  0\n 51 48  1  0     0  0\n 43 48  1  0     0  0\n 53 52  2  0     0  0\n 54 52  1  0     0  0\n 55 53  1  0     0  0\n 56 54  2  0     0  0\n 57 55  2  0     0  0\n 57 56  1  0     0  0\n 24 52  1  0     0  0\n 59 58  1  0     0  0\n 57 58  1  0     0  0\n 59 60  1  0     0  0\n 60 61  1  0     0  0\n 61 62  2  0     0  0\n 61 63  1  0     0  0\n 63 64  1  0     0  0\n 64 65  1  0     0  0\n 65 66  1  0     0  0\n 66 67  1  0     0  0\n 67 68  1  0     0  0\n 68 69  1  0     0  0\n 68 70  2  0     0  0\n 69 71  1  0     0  0\n 71 72  1  0     0  0\n 72 73  1  0     0  0\n 73 74  1  0     0  0\n 75 74  1  1     0  0\n 75 76  1  0     0  0\n 78 75  1  0     0  0\n 78 77  2  0     0  0\n 78 79  1  0     0  0\n 75 80  1  6     0  0\n 76 81  1  0     0  0\nM  CHG  4   1   1   2   1  46  -1  51  -1\nM  STY  1   1 SRU\nM  SLB  1   1   1\nM  SCN  1   1 HT \nM  SMT   1 m\nM  SAL   1 15   1   2  24  25  26  27  28  29  30  31  32  33  34  35  36\nM  SAL   1 15  37  38  39  40  41  42  43  44  45  46  47  48  49  50  51\nM  SAL   1 15  52  53  54  55  56  57  58  59  60  61  62  63  64  65  66\nM  SAL   1 15  67  68  69  70  71  72  73  74  75  76  77  78  79  80  81\nM  SDI   1  4    3.5758  -17.6278    3.5758   -2.8711\nM  SDI   1  4   16.1300   -2.8711   16.1300  -17.6278\nM  STY  1   2 SRU\nM  SLB  1   2   2\nM  SCN  1   2 HT \nM  SMT   2 n\nM  SAL   2 15   3   4   5   6   7   8   9  10  11  12  13  14  15  16  17\nM  SAL   2  6  18  19  20  21  22  23\nM  SDI   2  4   18.1525  -11.1208   18.1525   -2.9571\nM  SDI   2  4   26.3754   -2.9571   26.3754  -11.1208\nM  END\n",
        "mol_formula": "(C32H45N3Na2O18S2)m.(C11H20N2O4S)n",
        "net_charge": 0,
    },
    76109: {
        "molfile": "\n  Ketcher 10072214522D 1   1.00000     0.00000     0\n\n 22 22  0     1  0            999 V2000\n    7.6763   -6.5666    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    7.6763   -7.5686    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    6.8222   -8.0619    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    6.8223   -9.0639    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    7.6902   -9.5647    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    8.5443   -9.0714    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    8.5441   -8.0694    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    5.9547   -9.5649    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    9.4122   -9.5724    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    7.6902  -10.5667    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    9.4119   -7.5685    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    5.9547  -10.5668    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    4.9530   -5.5647    0.0000 H   0  0  0  0  0  0  0  0  0  0  0  0\n    5.9549   -5.5647    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    6.8086   -5.0637    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    7.6763   -5.5647    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    8.5441   -5.0637    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    9.4118   -5.5647    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   10.4138   -5.5647    0.0000 P   0  0  0  0  0  0  0  0  0  0  0  0\n   10.4138   -6.5666    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   11.4157   -5.5647    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   10.4138   -4.5627    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  2  1  1  6     0  0\n  2  3  1  0     0  0\n  3  4  1  0     0  0\n  4  5  1  0     0  0\n  5  6  1  0     0  0\n  6  7  1  0     0  0\n  2  7  1  0     0  0\n  4  8  1  1     0  0\n  6  9  1  1     0  0\n  5 10  1  6     0  0\n  7 11  1  6     0  0\n  8 12  1  0     0  0\n 13 14  1  0     0  0\n 14 15  1  0     0  0\n 15 16  1  0     0  0\n 16 17  1  0     0  0\n 17 18  1  0     0  0\n 18 19  1  0     0  0\n 19 20  2  0     0  0\n 19 21  1  0     0  0\n 19 22  1  0     0  0\n 16  1  1  0     0  0\nM  CHG  1  22  -1\nM  STY  1   1 SRU\nM  SLB  1   1   1\nM  SCN  1   1 HT \nM  SMT   1 n\nM  SAL   1 15   1   2   3   4   5   6   7   8   9  10  11  12  14  15  16\nM  SAL   1  5  17  18  19  20  22\nM  SBL   1  2  13  20\nM  SDI   1  4    5.4539   -6.3147    5.4539   -4.8147\nM  SDI   1  4   10.9147   -4.8147   10.9147   -6.3147\nM  END\n",
        "mol_formula": "(C9H16O10P)n.H2O",
        "net_charge": -1,
    },

    53020: {
        "molfile": "\n  Mrv0541 03311411242D          \n\n183195  0  0  0  0            999 V2000\n    0.0000   -1.3392    0.0000 P   0  0  0  0  0  0  0  0  0  0  0  0\n    8.5736   -1.3392    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    7.8592   -0.9267    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    7.1447   -1.3392    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    7.1447   -2.1642    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    5.7157   -1.3392    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    6.4302   -0.9267    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    5.0013   -0.9267    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    4.2868   -1.3392    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    4.2868   -2.1642    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    2.8579   -1.3392    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    3.5723   -0.9267    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    2.1434   -0.9267    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    1.4289   -1.3392    0.0000 P   0  0  0  0  0  0  0  0  0  0  0  0\n    0.7144   -0.9267    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    1.4289   -2.1642    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -0.7145   -0.9267    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    0.0000   -2.1642    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -1.4290   -1.3392    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n   -2.1434   -0.9267    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -2.8579   -1.3392    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n   -2.8579   -2.1642    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n   -2.1434   -2.5767    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n   -1.4290   -2.1642    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n   -3.5724   -0.9267    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   -3.5724   -2.5767    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -2.1434   -3.4017    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -0.7145   -2.5767    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n   -3.5724   -0.1017    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   16.4328   -0.9267    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   15.7183   -1.3392    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   15.0039   -0.9267    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   15.7183   -2.1642    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   14.2894   -1.3392    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   13.5749   -0.9267    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   12.8605   -1.3392    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   12.1460   -0.9267    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   12.8605   -2.1642    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   11.4315   -1.3392    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   10.7170   -0.9267    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   10.0026   -1.3392    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    9.2881   -0.9267    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   10.0026   -2.1642    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   -4.2868   -2.1642    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n   -4.2868   -1.3392    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -5.0013   -0.9267    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n   -5.7158   -1.3392    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n   -5.7158   -2.1642    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n   -5.0013   -2.5767    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n   -5.0013   -0.1017    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   -6.4303   -2.5767    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -6.4303   -0.9267    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -5.0013   -3.4017    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n   -0.7145   -3.4017    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   -1.4290   -3.8142    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    0.0000   -3.8142    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   -5.7158   -3.8142    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   -6.4303   -3.4017    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   -5.7158   -4.6392    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -4.2868    0.3108    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -6.4303   -0.1017    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n   -5.7158    0.3108    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -5.7158    1.1358    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n   -6.4303    1.5483    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n   -7.1447    1.1358    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n   -7.1447    0.3108    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n   -5.0013    1.5483    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   -7.8592    1.5483    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -7.8592   -0.1017    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -6.4303    2.3733    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -7.8592    2.3733    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n   -7.1447    2.7858    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -7.1447    3.6108    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n   -7.8592    4.0233    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n   -8.5737    3.6108    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n   -8.5737    2.7858    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n   -6.4303    4.0233    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   -9.2881    4.0233    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -7.8592    4.8483    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -6.4303    4.8483    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    0.0000   -0.5142    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    1.4289   -0.5142    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -9.2881    2.3733    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  -10.0026    2.7858    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n  -10.0026    3.6108    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  -10.7171    4.0233    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n  -11.4315    3.6108    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n  -11.4315    2.7857    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n  -10.7171    2.3732    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n  -10.7171    4.8482    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n  -12.1460    2.3733    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  -12.1460    4.0232    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  -11.4316    5.2607    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  -12.1460   -0.9266    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  -12.8605   -1.3391    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n  -13.5750   -0.9266    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  -14.2894   -1.3391    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n  -14.2894   -2.1641    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n  -13.5750   -2.5766    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n  -12.8605   -2.1641    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n  -15.0039   -0.9266    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n  -12.1461   -2.5766    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  -15.0039   -2.5766    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  -15.7184   -1.3391    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  -10.7170    1.5483    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  -11.4315    1.1358    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n  -12.1460    1.5484    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  -12.8604    1.1359    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n  -12.8604    0.3108    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n  -12.1460   -0.1017    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n  -11.4315    0.3108    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n  -13.5749    1.5483    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n  -10.7171   -0.1017    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  -13.5749   -0.1016    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  -14.2893    1.1358    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  -13.5751   -5.0515    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  -13.5750   -3.4016    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  -14.2895   -3.8141    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n  -15.0040   -3.4015    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  -15.7185   -3.8140    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n  -15.7185   -4.6390    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n  -15.0040   -5.0516    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n  -14.2895   -4.6391    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n  -16.4329   -3.4016    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n  -15.0040   -5.8765    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  -16.4329   -5.0515    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  -17.1474   -3.8140    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -5.0013    2.3733    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -4.2868    2.7858    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n   -3.5723    2.3732    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -2.8579    2.7857    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n   -2.8579    3.6108    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n   -3.5723    4.0233    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n   -4.2868    3.6108    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n   -2.1434    2.3733    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   -5.0013    4.0233    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -2.1434    4.0232    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    3.0835    1.5413    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n    3.7980    1.1288    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    4.5124    1.5413    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n    4.5124    2.3663    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n    3.7980    2.7789    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n    3.0835    2.3664    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n    5.2269    1.1288    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    3.7980    3.6038    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    2.3691    2.7788    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    5.2269    2.7788    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    5.9413    1.5413    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -1.4290    2.7858    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -0.7145    2.3733    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n   -0.7145    1.5483    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    0.0000    1.1358    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n    0.7145    1.5483    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n    0.7145    2.3733    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n    0.0000    2.7858    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n    0.0000    0.3108    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    1.4289    2.7858    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -0.0001    3.6108    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    2.0154    0.9815    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    0.7145   -0.1017    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -3.5723    4.8482    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -2.8578    5.2607    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n   -2.1433    4.8482    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -1.4289    5.2607    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n   -1.4289    6.0857    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n   -2.1433    6.4982    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n   -2.8578    6.0858    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n   -0.7144    4.8482    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   -2.1433    7.3232    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -3.5722    6.4982    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    0.0000    5.2607    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -0.7144    6.4982    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    0.0001    6.9107    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n    0.7146    6.4981    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    1.4291    6.9106    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n    1.4291    7.7357    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n    0.7146    8.1482    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n    0.0001    7.7357    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n    2.1435    6.4982    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    0.7146    8.9731    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -0.7143    8.1482    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    2.1435    8.1481    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    2.8580    6.9107    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n 15  1  1  0  0  0  0\n  1 17  1  0  0  0  0\n  1 18  2  0  0  0  0\n  1 81  1  0  0  0  0\n  2  3  1  0  0  0  0\n  4  5  1  0  0  0  0\n  4  3  1  0  0  0  0\n  7  6  1  0  0  0  0\n  7  4  2  0  0  0  0\n  6  8  1  0  0  0  0\n  9 10  1  0  0  0  0\n  9  8  1  0  0  0  0\n 11 12  1  0  0  0  0\n 12  9  1  0  0  0  0\n 11 13  1  0  0  0  0\n 13 14  1  0  0  0  0\n 14 15  1  0  0  0  0\n 14 16  2  0  0  0  0\n 19 17  1  6  0  0  0\n 19 20  1  0  0  0  0\n 20 21  1  0  0  0  0\n 21 22  1  0  0  0  0\n 22 23  1  0  0  0  0\n 23 24  1  0  0  0  0\n 19 24  1  0  0  0  0\n 21 25  1  1  0  0  0\n 22 26  1  6  0  0  0\n 23 27  1  1  0  0  0\n 24 28  1  6  0  0  0\n 25 29  1  0  0  0  0\n 34 35  1  0  0  0  0\n 35 36  1  0  0  0  0\n 36 37  2  0  0  0  0\n 36 38  1  0  0  0  0\n 37 39  1  0  0  0  0\n 32 34  1  0  0  0  0\n 30 31  1  0  0  0  0\n 31 32  2  0  0  0  0\n 39 40  1  0  0  0  0\n 40 41  1  0  0  0  0\n 41 42  2  0  0  0  0\n 41 43  1  0  0  0  0\n 42  2  1  0  0  0  0\n 31 33  1  0  0  0  0\n 44 26  1  1  0  0  0\n 44 45  1  0  0  0  0\n 45 46  1  0  0  0  0\n 46 47  1  0  0  0  0\n 47 48  1  0  0  0  0\n 48 49  1  0  0  0  0\n 44 49  1  0  0  0  0\n 46 50  1  1  0  0  0\n 48 51  1  1  0  0  0\n 47 52  1  6  0  0  0\n 49 53  1  6  0  0  0\n 28 54  1  0  0  0  0\n 54 55  2  0  0  0  0\n 54 56  1  0  0  0  0\n 53 57  1  0  0  0  0\n 57 58  1  0  0  0  0\n 57 59  2  0  0  0  0\n 50 60  1  0  0  0  0\n 61 52  1  1  0  0  0\n 61 62  1  0  0  0  0\n 62 63  1  0  0  0  0\n 63 64  1  0  0  0  0\n 64 65  1  0  0  0  0\n 65 66  1  0  0  0  0\n 61 66  1  0  0  0  0\n 63 67  1  1  0  0  0\n 65 68  1  1  0  0  0\n 66 69  1  1  0  0  0\n 64 70  1  6  0  0  0\n 67128  1  0  0  0  0\n 71 68  1  6  0  0  0\n 71 72  1  0  0  0  0\n 72 73  1  0  0  0  0\n 73 74  1  0  0  0  0\n 74 75  1  0  0  0  0\n 75 76  1  0  0  0  0\n 71 76  1  0  0  0  0\n 73 77  1  1  0  0  0\n 75 78  1  1  0  0  0\n 76 83  1  1  0  0  0\n 74 79  1  6  0  0  0\n 77 80  1  0  0  0  0\n 14 82  1  0  0  0  0\n 84 83  1  6  0  0  0\n 84 85  1  0  0  0  0\n 85 86  1  0  0  0  0\n 86 87  1  0  0  0  0\n 87 88  1  0  0  0  0\n 88 89  1  0  0  0  0\n 84 89  1  0  0  0  0\n 86 90  1  1  0  0  0\n 88 91  1  1  0  0  0\n 89105  1  1  0  0  0\n 87 92  1  6  0  0  0\n 90 93  1  0  0  0  0\n 95 94  1  6  0  0  0\n 95 96  1  0  0  0  0\n 96 97  1  0  0  0  0\n 97 98  1  0  0  0  0\n 98 99  1  0  0  0  0\n 99100  1  0  0  0  0\n 95100  1  0  0  0  0\n 97101  1  1  0  0  0\n 99117  1  1  0  0  0\n100102  1  6  0  0  0\n 98103  1  6  0  0  0\n101104  1  0  0  0  0\n106105  1  6  0  0  0\n106107  1  0  0  0  0\n107108  1  0  0  0  0\n108109  1  0  0  0  0\n109110  1  0  0  0  0\n110111  1  0  0  0  0\n106111  1  0  0  0  0\n108112  1  1  0  0  0\n110 94  1  1  0  0  0\n111113  1  1  0  0  0\n109114  1  6  0  0  0\n112115  1  0  0  0  0\n118117  1  6  0  0  0\n118119  1  0  0  0  0\n119120  1  0  0  0  0\n120121  1  0  0  0  0\n121122  1  0  0  0  0\n122123  1  0  0  0  0\n118123  1  0  0  0  0\n120124  1  1  0  0  0\n122125  1  1  0  0  0\n123116  1  6  0  0  0\n121126  1  6  0  0  0\n124127  1  0  0  0  0\n129128  1  6  0  0  0\n129130  1  0  0  0  0\n130131  1  0  0  0  0\n131132  1  0  0  0  0\n132133  1  0  0  0  0\n133134  1  0  0  0  0\n129134  1  0  0  0  0\n131135  1  1  0  0  0\n133161  1  1  0  0  0\n134136  1  1  0  0  0\n132137  1  6  0  0  0\n135149  1  0  0  0  0\n138159  1  6  0  0  0\n138139  1  0  0  0  0\n139140  1  0  0  0  0\n140141  1  0  0  0  0\n141142  1  0  0  0  0\n142143  1  0  0  0  0\n138143  1  0  0  0  0\n140144  1  1  0  0  0\n142145  1  1  0  0  0\n143146  1  1  0  0  0\n141147  1  6  0  0  0\n144148  1  0  0  0  0\n150149  1  6  0  0  0\n150151  1  0  0  0  0\n151152  1  0  0  0  0\n152153  1  0  0  0  0\n153154  1  0  0  0  0\n154155  1  0  0  0  0\n150155  1  0  0  0  0\n152156  1  1  0  0  0\n154157  1  1  0  0  0\n155158  1  1  0  0  0\n153159  1  6  0  0  0\n156160  1  0  0  0  0\n162161  1  6  0  0  0\n162163  1  0  0  0  0\n163164  1  0  0  0  0\n164165  1  0  0  0  0\n165166  1  0  0  0  0\n166167  1  0  0  0  0\n162167  1  0  0  0  0\n164168  1  1  0  0  0\n166169  1  1  0  0  0\n167170  1  1  0  0  0\n165172  1  6  0  0  0\n168171  1  0  0  0  0\n173172  1  6  0  0  0\n173174  1  0  0  0  0\n174175  1  0  0  0  0\n175176  1  0  0  0  0\n176177  1  0  0  0  0\n177178  1  0  0  0  0\n173178  1  0  0  0  0\n175179  1  1  0  0  0\n177180  1  1  0  0  0\n178181  1  1  0  0  0\n176182  1  6  0  0  0\n179183  1  0  0  0  0\nM  STY  2   1 SUP   2 SRU\nM  SPL  1   1   2\nM  SAL   1  5   3   4   5   6   7\nM  SBL   1  2   5  10\nM  SMT   1 n\nM  SAP   1  2   3   2  1   6   8  2\nM  SCL   1 CXN\nM  SDS EXP  1   1\nM  SCN  1   2 HT \nM  SAL   2  5   3   4   5   6   7\nM  SDI   2  4    5.2153   -1.5266    5.6278   -0.8121\nM  SDI   2  4    8.3596   -0.7393    7.9471   -1.4538\nM  SBL   2  2   5  10\nM  SMT   2 n\nM  END\n",
        "mol_formula": "(C5H8)n.C102H174N2O72P2",
        "net_charge": 0,
    },
}

# Mixtures (91240, 32140)
mixtures = {
    91240: {
        "molfile": "\n  Ketcher 03211612022D 1   1.00000     0.00000     0\n\n 11  7  0     0  0            999 V2000\n    9.6642   -3.6172    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n   10.5289   -3.1180    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   11.3937   -3.6172    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n   10.5289   -2.1195    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    8.5665   -5.6803    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n   10.5529   -5.9427    0.0000 S   0  0  0  0  0  0  0  0  0  0  0  0\n   11.4168   -6.4433    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    9.6768   -6.4433    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   10.0564   -5.0764    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   11.0549   -5.0795    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   12.1980   -5.6439    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n  1  2  1  0     0  0\n  2  3  1  0     0  0\n  2  4  2  0     0  0\n  7  6  1  0     0  0\n  8  6  1  0     0  0\n  9  6  2  0     0  0\n 10  6  2  0     0  0\nM  CHG  4   5   1   7  -1   8  -1  11   1\nM  END\n",
        "mol_formula": "CH4N2O.H4N.O4S.H4N",
        "avg_mass": 192.197,
        "monoisotopic_mass": 192.05284,
        "net_charge": 0,
    },
    32140: {
        "molfile": "\n  Ketcher 02191914552D 1   1.00000     0.00000     0\n\n 24 24  0     0  0            999 V2000\n    8.9616   -9.7800    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    8.9616  -10.7989    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    9.8219   -9.2746    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    8.0303   -9.4709    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n    9.8219  -11.2877    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n    8.0303  -11.1080    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n   10.6948   -9.8008    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n    9.8219   -8.2890    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    7.4456  -10.2977    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    7.5878   -8.5561    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   10.6948  -10.7614    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    9.8219  -12.3108    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   11.6010   -9.2122    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   11.5884  -11.2292    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   14.5604  -10.0329    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   15.4222  -10.5325    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   13.6904  -10.5325    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   14.5645   -9.1338    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   15.4222  -11.5317    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   13.6904  -11.5317    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   13.6944   -8.6259    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   15.4263   -8.6302    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   14.5604  -12.0354    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   16.5180   -8.6197    0.0000 Na  0  0  0  0  0  0  0  0  0  0  0  0\n  4  9  1  0     0  0\n  4 10  1  0     0  0\n  5 11  1  0     0  0\n  5 12  1  0     0  0\n  7 13  1  0     0  0\n 11 14  2  0     0  0\n  6  9  2  0     0  0\n  7 11  1  0     0  0\n  1  2  2  0     0  0\n  1  3  1  0     0  0\n  1  4  1  0     0  0\n  2  5  1  0     0  0\n  2  6  1  0     0  0\n  3  7  1  0     0  0\n  3  8  2  0     0  0\n 15 16  2  0     0  0\n 15 17  1  0     0  0\n 15 18  1  0     0  0\n 16 19  1  0     0  0\n 17 20  2  0     0  0\n 18 21  2  0     0  0\n 18 22  1  0     0  0\n 19 23  2  0     0  0\n 20 23  1  0     0  0\nM  CHG  2  22  -1  24   1\nM  END\n",
        "mol_formula": "C8H10N4O2.C7H5O2.Na",
        "avg_mass": 338.299,
        "monoisotopic_mass": 338.09910,
        "net_charge": 0,
    },
}

# Atoms (25107)
atoms = {
    25107: {
        "molfile": "\n  Marvin  03051212192D          \n\n  1  0  0  0  0  0            999 V2000\n    0.0000    0.0000    0.0000 Mg  0  0  0  0  0 15  0  0  0  0  0  0\nM  END\n",
        "mol_formula": "Mg",
        "avg_mass": 24.30500,
        "monoisotopic_mass": 23.98504,
        "net_charge": 0,
    }
}

# Extra polymers (53334, 59297, 59602)
extra_polymers = {
    53334: {
        "molfile": "\n  Marvin  10140911012D          \n\n 19 18  0  0  0  0            999 V2000\n   -2.0296    1.6372    0.0000 Si  0  0  0  0  0  0  0  0  0  0  0  0\n   -2.0296    2.4622    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   -2.0296    0.8122    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   -2.8546    1.6372    0.0000 *   0  0  0  0  0  0  0  0  0  0  0  0\n   -1.2046    1.6372    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -0.3796    1.6372    0.0000 Si  0  0  0  0  0  0  0  0  0  0  0  0\n    0.4454    1.6372    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -0.3796    0.8122    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   -0.3796    2.4622    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    0.3349    0.3997    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    1.0494    0.8122    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    1.7638    0.3997    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    1.2704    1.6372    0.0000 *   0  0  0  0  0  0  0  0  0  0  0  0\n    2.4783    0.8122    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    3.1928    0.3996    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    3.9072    0.8121    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    4.6217    0.3996    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    5.3362    0.8120    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    6.0506    0.3995    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n  1  2  1  0  0  0  0\n  1  3  1  0  0  0  0\n  1  4  1  0  0  0  0\n  1  5  1  0  0  0  0\n  5  6  1  0  0  0  0\n  6  7  1  0  0  0  0\n  6  8  1  0  0  0  0\n  6  9  1  0  0  0  0\n  8 10  1  0  0  0  0\n 10 11  1  0  0  0  0\n  7 13  1  0  0  0  0\n 11 12  1  0  0  0  0\n 12 14  1  0  0  0  0\n 14 15  1  0  0  0  0\n 15 16  1  0  0  0  0\n 16 17  1  0  0  0  0\n 17 18  1  0  0  0  0\n 18 19  1  0  0  0  0\nM  STY  2   1 SRU   2 SRU\nM  SCN  1   1 HT \nM  SAL   1  4   1   2   3   5\nM  SDI   1  4   -0.8649    2.0497   -0.8649    1.2247\nM  SDI   1  4   -2.3693    1.2247   -2.3693    2.0497\nM  SBL   1  2   3   5\nM  SMT   1 n\nM  SCN  1   2 HT \nM  SAL   2 13   6   7   8   9  10  11  12  14  15  16  17  18  19\nM  SDI   2  4    0.7851    2.0497    0.7851    1.2247\nM  SDI   2  4   -0.7193    1.2247   -0.7193    2.0497\nM  SBL   2  2   5  11\nM  SMT   2 m\nM  END\n",
        "mol_formula": "(C2H6OSi)n.(C8H18O4Si)m",
        "net_charge": 0,
    },
    59297: {
        "molfile": "\n  Marvin  04261016292D          \n\n 46 46  0  0  0  0            999 V2000\n    7.7994   -6.0504    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    7.7994   -5.2254    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    7.0849   -6.4629    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n    7.0849   -7.2879    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    6.3704   -6.0504    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n    9.0145   -6.0800    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    5.5454   -6.0504    0.0000 H   0  0  0  0  0  0  0  0  0  0  0  0\n    6.3704   -7.7004    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    6.3704   -8.5254    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    5.6559   -8.9379    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    5.6559   -9.7629    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n    6.3704  -10.1754    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    6.3704  -11.0004    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    7.0848   -9.7629    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    7.0848   -8.9379    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n    7.7993  -10.1754    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n    7.7993   -8.5254    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    7.7993   -7.7004    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    8.5138   -8.9379    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    9.2282   -8.5254    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    9.9426   -7.2879    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    9.2282   -7.7004    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    9.9426   -8.9379    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   10.6572   -8.5254    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   10.6572   -7.7004    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    8.5828   -9.9171    0.0000 S   0  0  0  0  0  0  0  0  0  0  0  0\n    7.8028  -11.0004    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n    8.5885  -11.2520    0.0000 C   0  0  2  0  0  0  0  0  0  0  0  0\n    9.0706  -10.5825    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    7.7993   -9.3504    0.0000 H   0  0  0  0  0  0  0  0  0  0  0  0\n    8.8468  -12.0356    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    9.6544  -12.2036    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    8.2974  -12.6510    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    9.7850  -10.1700    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    9.7850  -10.9950    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   14.2179   -7.2109    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   14.2179   -6.3859    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   13.5034   -7.6234    0.0000 C   0  0  1  0  0  0  0  0  0  0  0  0\n   13.5034   -8.4484    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   12.7889   -7.2109    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n   15.4330   -7.2405    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   11.9639   -7.2109    0.0000 H   0  0  0  0  0  0  0  0  0  0  0  0\n   12.7889   -8.8609    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   12.7889   -9.6859    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   12.0744  -10.0984    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   12.0744  -10.9234    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n  1  2  2  0  0  0  0\n  1  3  1  0  0  0  0\n  3  4  1  0  0  0  0\n  3  5  1  1  0  0  0\n  6  1  1  0  0  0  0\n  5  7  1  0  0  0  0\n  4  8  1  0  0  0  0\n  8  9  1  0  0  0  0\n  9 10  1  0  0  0  0\n 10 11  1  0  0  0  0\n 11 12  1  0  0  0  0\n 12 13  2  0  0  0  0\n 12 14  1  0  0  0  0\n 14 15  1  0  0  0  0\n 14 16  1  0  0  0  0\n 15 17  1  0  0  0  0\n 17 18  2  0  0  0  0\n 17 19  1  0  0  0  0\n 19 20  1  0  0  0  0\n 22 20  2  0  0  0  0\n 20 23  1  0  0  0  0\n 21 22  1  0  0  0  0\n 23 24  2  0  0  0  0\n 24 25  1  0  0  0  0\n 21 25  2  0  0  0  0\n 26 16  1  0  0  0  0\n 16 27  1  0  0  0  0\n 27 28  1  0  0  0  0\n 28 29  1  0  0  0  0\n 26 29  1  0  0  0  0\n 16 30  1  6  0  0  0\n 28 31  1  6  0  0  0\n 31 32  1  0  0  0  0\n 31 33  2  0  0  0  0\n 29 34  1  0  0  0  0\n 29 35  1  0  0  0  0\n 36 37  2  0  0  0  0\n 36 38  1  0  0  0  0\n 38 39  1  0  0  0  0\n 38 40  1  1  0  0  0\n 41 36  1  0  0  0  0\n 40 42  1  0  0  0  0\n 39 43  1  0  0  0  0\n 43 44  1  0  0  0  0\n 44 45  1  0  0  0  0\n 45 46  1  0  0  0  0\nM  STY  2   1 COP   2 COP\nM  SST  1   1 RAN\nM  SCN  1   1 HT \nM  SAL   1 15   1   2   3   4   5   8   9  10  11  12  13  14  15  16  17\nM  SAL   1 15  18  19  20  21  22  23  24  25  26  27  28  29  30  31  32\nM  SAL   1  3  33  34  35\nM  SDI   1  4    6.0307   -6.4629    6.0307   -5.6379\nM  SDI   1  4    8.3098   -5.6502    8.2897   -6.4750\nM  SBL   1  2   5   6\nM  SMT   1 ran\nM  SST  1   2 RAN\nM  SCN  1   2 HT \nM  SAL   2  9  36  37  38  39  40  43  44  45  46\nM  SDI   2  4   12.4492   -7.6234   12.4492   -6.7984\nM  SDI   2  4   14.7283   -6.8108   14.7082   -7.6355\nM  SBL   2  2  41  42\nM  SMT   2 ran\nM  END\n",
        "mol_formula": "(C22H30N4O5S)ran.(C6H12N2O)ran.H4O2",
        "net_charge": 0,
    },
    59602: {
        "molfile": "\n  Marvin  06091012252D          \n\n 13 11  0  0  0  0            999 V2000\n   -3.5063    2.1509    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n   -2.7918    2.5634    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   -2.0773    2.1509    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   -1.3628    2.5634    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n   -0.6484    2.1509    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    0.0661    2.5634    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n    0.7806    2.1509    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n   -2.9984   -0.4714    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   -2.2839   -0.0589    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   -1.5695   -0.4714    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   -0.8550   -0.0589    0.0000 Cl  0  0  0  0  0  0  0  0  0  0  0  0\n   -2.9984    0.3536    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n    0.6777   -0.1775    0.0000 Cl  0  0  0  0  0  0  0  0  0  0  0  0\n  1  2  1  0  0  0  0\n  2  3  1  0  0  0  0\n  3  4  1  0  0  0  0\n  4  5  1  0  0  0  0\n  5  6  1  0  0  0  0\n  6  7  1  0  0  0  0\n  8  9  1  0  0  0  0\n  9 10  1  0  0  0  0\n 10 11  1  0  0  0  0\n  9 12  1  0  0  0  0\n 12  8  1  0  0  0  0\nM  STY  2   1 MON   2 MON\nM  SAL   1  7   1   2   3   4   5   6   7\nM  SDI   1  4   -3.9263    1.7309   -3.9263    2.9834\nM  SDI   1  4    1.2006    2.9834    1.2006    1.7309\nM  SAL   2  5   8   9  10  11  12\nM  SDI   2  4   -3.4184   -0.8914   -3.4184    0.7736\nM  SDI   2  4   -0.4350    0.7736   -0.4350   -0.8914\nM  END\n",
        "mol_formula": "(C4H13N3).(C3H5ClO).HCl",
        "net_charge": 0,
    },
}
# Isotopes (176516, 41981)
isotopes = {
    176516: {
        "molfile": "\n  Ketcher 06152115322D 1   1.00000     0.00000     0\n\n  9  9  0     1  0            999 V2000\n   15.7383   -8.7689    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   16.4455   -9.4760    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   17.1525   -8.7689    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   16.4455   -8.0617    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   15.7385   -7.3547    0.0000 N   0  0  0  0  0  0  0  0  0  0  0  0\n   17.1525   -7.3547    0.0000 C   0  0  0  0  0  0  0  0  0  0  0  0\n   18.1185   -7.6133    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   16.8937   -6.3886    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   16.4455  -10.4760    0.0000 F   0  0  0  0  0  0  0  0  0  0  0  0\n  1  2  1  0     0  0\n  4  1  1  0     0  0\n  2  3  1  0     0  0\n  3  4  1  0     0  0\n  4  5  1  6     0  0\n  4  6  1  1     0  0\n  6  7  1  0     0  0\n  6  8  2  0     0  0\n  2  9  1  1     0  0\nM  ISO  1   4  14\nM  END\n",
        "mol_formula": "C4[14C]H8FNO2",
        "avg_mass": 135.1142,
        "monoisotopic_mass": 135.05715,
        "net_charge": 0,
    },
    41981: {
        "molfile": "\n  Marvin  01170609232D          \n\n  3  2  0  0  0  0            999 V2000\n   -0.4125    0.7145    0.0000 H   0  0  0  0  0  0  0  0  0  0  0  0\n    0.0000    0.0000    0.0000 O   0  0  0  0  0  0  0  0  0  0  0  0\n   -0.4125   -0.7145    0.0000 H   0  0  0  0  0  0  0  0  0  0  0  0\n  2  1  1  0  0  0  0\n  2  3  1  0  0  0  0\nM  ISO  2   1   2   3   2\nM  END\n",
        "mol_formula": "D2O",
        "avg_mass": 20.0272,
        "monoisotopic_mass": 20.02312,
        "net_charge": 0,
    },
}
