# 🧰 Raiz - Simple CLI Requirements Management Tool

A CLI tool to manage, track, and trace software requirements with automated test case linking, traceability reporting, and seamless integration with Robot Framework.

> Built for developers and teams working with embedded systems, Zephyr RTOS, or other projects where traceability and coverage are crucial.

---

## 🚀 Features

- 📄 **Define and manage software requirements** (Functional, Non-functional, Constraints)
- 🔗 **Link test cases** (from Robot Framework) to specific requirements using tags (e.g., `REQ-001`)
- ✅ **Trace test coverage** — which requirements are tested, which are missing
- 🗃️ **SQLite-backed DB** for performance and reliability
- 🧪 **Robot Framework integration** using `output.xml`
- 📦 Installable via `pip`
- 📊 **Traceability reporting**: Console, CSV, JSON
- 🧹 Automatic renumbering of requirements
- 🧰 Modular and extensible codebase
- 🧪 Unit test ready

---

## 📦 Installation

```bash
pip install raiz
```
