# flake8: noqa
# pylint: disable=C0301

# Some common builtin exeptions we might want to watch for
PYTHON_BUILTIN_EXCEPTIONS = [
    "ArithmeticError",
    "AssertionError",
    "AttributeError",
#    "BaseException",
#    "BlockingIOError",
#    "BrokenPipeError",
#    "BufferError",
    "BytesWarning",
#    "ChildProcessError",
#    "ConnectionAbortedError",
#    "ConnectionError",
#    "ConnectionRefusedError",
    "ConnectionResetError",
#    "DeprecationWarning",
#    "EnvironmentError",
    "EOFError",
#    "Exception",
    "FileExistsError",
    "FileNotFoundError",
    "FloatingPointError",
#    "FutureWarning",
#    "GeneratorExit",
    "ImportError",
    "ImportWarning",
#    "IndentationError",
    "IndexError",
    "InterruptedError",
    "IOError",
    "IsADirectoryError",
#    "KeyboardInterrupt",
    "KeyError",
    "LookupError",
    "MemoryError",
    "ModuleNotFoundError",
    "NameError",
#    "NotADirectoryError",
    "NotImplementedError",
    "OSError",
    "OverflowError",
#    "PendingDeprecationWarning",
    "PermissionError",
    "ProcessLookupError",
    "RecursionError",
    "ReferenceError",
    "ResourceWarning",
    "RuntimeError",
#    "RuntimeWarning",
#    "StopAsyncIteration",
#    "StopIteration",
    "SyntaxError",
#    "SyntaxWarning",
    "SystemError",
    "SystemExit",
#    "TabError",
    "TimeoutError",
    "TypeError",
    "UnboundLocalError",
    "UnicodeDecodeError",
    "UnicodeEncodeError",
    "UnicodeError",
    "UnicodeTranslateError",
    "UnicodeWarning",
    "UserWarning",
    "ValueError",
#    "Warning",
#    "WindowsError",
    "ZeroDivisionError",
]

# https://opendev.org/openstack/oslo.db/src/branch/master/oslo_db/exception.py
OSLO_DB_EXCEPTIONS = [
    "DBError",
    "DBDuplicateEntry",
    "DBConstraintError",
    "DBReferenceError",
    "DBNonExistentConstraint",
    "DBNonExistentTable",
    "DBNonExistentDatabase",
    "DBDeadlock",
    "DBInvalidUnicodeParameter",
    "DBMigrationError",
    "DBConnectionError",
    "DBDataError",
    "DBNotSupportedError",
    "InvalidSortKey",
    "ColumnError",
    "BackendNotAvailable",
    "RetryRequest",
    "NoEngineContextEstablished",
    "ContextNotRequestedError",
    "CantStartEngineError",
]

# https://opendev.org/openstack/oslo.messaging/src/branch/master/oslo_messaging/exceptions.py
OSLO_MESSAGING_EXCEPTIONS = [
    "MessagingException",
    "MessagingTimeout",
    "MessageDeliveryFailure",
    "InvalidTarget",
    "MessageUndeliverable",
]

# From https://github.com/libvirt/libvirt-python used by Nova
PYTHON_LIBVIRT_EXCEPTIONS = [
    "libvirtError",
]

# sed -rn 's/^class\s+(\S+)\(.+/    "\1",/p' keystone/exception.py
KEYSTONE_EXCEPTIONS = [
    "_KeystoneExceptionMeta",
    "Error",
    "ValidationError",
    "URLValidationError",
    "PasswordValidationError",
    "PasswordRequirementsValidationError",
    "PasswordHistoryValidationError",
    "PasswordAgeValidationError",
    "PasswordSelfServiceDisabled",
    "SchemaValidationError",
    "ValidationTimeStampError",
    "InvalidOperatorError",
    "ValidationExpirationError",
    "StringLengthExceeded",
    "AmbiguityError",
    "ApplicationCredentialValidationError",
    "CircularRegionHierarchyError",
    "ForbiddenNotSecurity",
    "PasswordVerificationError",
    "RegionDeletionError",
    "ApplicationCredentialLimitExceeded",
    "CredentialLimitExceeded",
    "SecurityError",
    "Unauthorized",
    "InsufficientAuthMethods",
    "ReceiptNotFound",
    "PasswordExpired",
    "AuthPluginException",
    "UserDisabled",
    "AccountLocked",
    "AuthMethodNotSupported",
    "ApplicationCredentialAuthError",
    "AdditionalAuthRequired",
    "Forbidden",
    "ForbiddenAction",
    "CrossBackendNotAllowed",
    "InvalidPolicyAssociation",
    "InvalidDomainConfig",
    "InvalidLimit",
    "LimitTreeExceedError",
    "NotFound",
    "EndpointNotFound",
    "PolicyNotFound",
    "PolicyAssociationNotFound",
    "RoleNotFound",
    "ImpliedRoleNotFound",
    "InvalidImpliedRole",
    "DomainSpecificRoleMismatch",
    "DomainSpecificRoleNotWithinIdPDomain",
    "DomainIdInvalid",
    "RoleAssignmentNotFound",
    "RegionNotFound",
    "ServiceNotFound",
    "DomainNotFound",
    "ProjectNotFound",
    "ProjectTagNotFound",
    "TokenNotFound",
    "UserNotFound",
    "GroupNotFound",
    "MappingNotFound",
    "TrustNotFound",
    "TrustUseLimitReached",
    "CredentialNotFound",
    "VersionNotFound",
    "EndpointGroupNotFound",
    "IdentityProviderNotFound",
    "ServiceProviderNotFound",
    "FederatedProtocolNotFound",
    "PublicIDNotFound",
    "RegisteredLimitNotFound",
    "LimitNotFound",
    "NoLimitReference",
    "RegisteredLimitError",
    "DomainConfigNotFound",
    "ConfigRegistrationNotFound",
    "ApplicationCredentialNotFound",
    "AccessRuleNotFound",
    "Conflict",
    "UnexpectedError",
    "TrustConsumeMaximumAttempt",
    "MalformedEndpoint",
    "MappedGroupNotFound",
    "MetadataFileError",
    "DirectMappingError",
    "AssignmentTypeCalculationError",
    "NotImplemented",
    "Gone",
    "ConfigFileNotFound",
    "KeysNotFound",
    "MultipleSQLDriversInConfig",
    "MigrationNotProvided",
    "UnsupportedTokenVersionException",
    "SAMLSigningError",
    "OAuthHeadersMissingError",
    "TokenlessAuthConfigError",
    "CredentialEncryptionError",
    "LDAPServerConnectionError",
    "LDAPInvalidCredentialsError",
    "LDAPSizeLimitExceeded",
    "CacheDeserializationError",
    "ResourceUpdateForbidden",
    "ResourceDeleteForbidden",
]

# Since there are many many exception types we need to cherry-pick the ones we
# care about to avoid search expresssions becoming too huge.
# e.g. sed -rn 's/^class\s+(\S+)\(.+/    "\1",/p' nova/exception.py
NOVA_EXCEPTIONS = [
    "ConvertedException",
    "NovaException",
    "EncryptionFailure",
    "VirtualInterfaceCreateException",
    "VirtualInterfaceMacAddressException",
    "VirtualInterfacePlugException",
    "VirtualInterfaceUnplugException",
    "GlanceConnectionFailed",
    "CinderConnectionFailed",
    "UnsupportedCinderAPIVersion",
    "CinderAPIVersionNotAvailable",
    "Forbidden",
    "ForbiddenWithAccelerators",
    "AdminRequired",
    "PolicyNotAuthorized",
    "ImageNotActive",
    "ImageNotAuthorized",
    "Invalid",
    "InvalidConfiguration",
    "InvalidBDM",
    "InvalidBDMSnapshot",
    "InvalidBDMVolume",
    "InvalidBDMImage",
    "InvalidBDMBootSequence",
    "InvalidBDMLocalsLimit",
    "InvalidBDMEphemeralSize",
    "InvalidBDMSwapSize",
    "InvalidBDMFormat",
    "InvalidBDMForLegacy",
    "InvalidBDMVolumeNotBootable",
    "TooManyDiskDevices",
    "InvalidBDMDiskBus",
    "InvalidAttribute",
    "ValidationError",
    "VolumeAttachFailed",
    "VolumeDetachFailed",
    "MultiattachNotSupportedByVirtDriver",
    "MultiattachNotSupportedOldMicroversion",
    "MultiattachToShelvedNotSupported",
    "MultiattachSwapVolumeNotSupported",
    "VolumeNotCreated",
    "ExtendVolumeNotSupported",
    "VolumeEncryptionNotSupported",
    "VolumeTaggedAttachNotSupported",
    "VolumeTaggedAttachToShelvedNotSupported",
    "NetworkInterfaceTaggedAttachNotSupported",
    "InvalidKeypair",
    "InvalidRequest",
    "InvalidInput",
    "InvalidVolume",
    "InvalidVolumeAccessMode",
    "StaleVolumeMount",
    "InvalidMetadata",
    "InvalidMetadataSize",
    "InvalidPortRange",
    "InvalidIpProtocol",
    "InvalidContentType",
    "InvalidAPIVersionString",
    "VersionNotFoundForAPIMethod",
    "InvalidGlobalAPIVersion",
    "ApiVersionsIntersect",
    "InvalidParameterValue",
    "InvalidAggregateAction",
    "InvalidAggregateActionAdd",
    "InvalidAggregateActionDelete",
    "InvalidAggregateActionUpdate",
    "InvalidAggregateActionUpdateMeta",
    "InvalidSortKey",
    "InvalidStrTime",
    "InvalidNUMANodesNumber",
    "InvalidName",
    "InstanceInvalidState",
    "InstanceNotRunning",
    "InstanceNotInRescueMode",
    "InstanceNotRescuable",
    "InstanceNotReady",
    "InstanceSuspendFailure",
    "InstanceResumeFailure",
    "InstancePowerOnFailure",
    "InstancePowerOffFailure",
    "InstanceRebootFailure",
    "InstanceTerminationFailure",
    "InstanceDeployFailure",
    "MultiplePortsNotApplicable",
    "InvalidFixedIpAndMaxCountRequest",
    "ServiceUnavailable",
    "ServiceNotUnique",
    "ComputeResourcesUnavailable",
    "HypervisorUnavailable",
    "ComputeServiceUnavailable",
    "ComputeServiceInUse",
    "UnableToMigrateToSelf",
    "OperationNotSupportedForSEV",
    "OperationNotSupportedForVTPM",
    "OperationNotSupportedForVDPAInterface",
    "InvalidHypervisorType",
    "HypervisorTooOld",
    "DestinationHypervisorTooOld",
    "ServiceTooOld",
    "TooOldComputeService",
    "DestinationDiskExists",
    "InvalidDevicePath",
    "DevicePathInUse",
    "InvalidCPUInfo",
    "InvalidIpAddressError",
    "InvalidDiskFormat",
    "InvalidDiskInfo",
    "DiskInfoReadWriteFail",
    "ImageUnacceptable",
    "ImageBadRequest",
    "ImageImportImpossible",
    "ImageQuotaExceeded",
    "InstanceUnacceptable",
    "InvalidUUID",
    "InvalidID",
    "ConstraintNotMet",
    "NotFound",
    "VolumeAttachmentNotFound",
    "VolumeNotFound",
    "VolumeTypeNotFound",
    "UndefinedRootBDM",
    "BDMNotFound",
    "VolumeBDMNotFound",
    "VolumeBDMIsMultiAttach",
    "VolumeBDMPathNotFound",
    "DeviceDetachFailed",
    "DeviceNotFound",
    "SnapshotNotFound",
    "DiskNotFound",
    "VolumeDriverNotFound",
    "VolumeDriverNotSupported",
    "InvalidImageRef",
    "AutoDiskConfigDisabledByImage",
    "ImageNotFound",
    "ImageDeleteConflict",
    "PreserveEphemeralNotSupported",
    "InstanceMappingNotFound",
    "InvalidCidr",
    "NetworkNotFound",
    "PortNotFound",
    "NetworkNotFoundForBridge",
    "NetworkNotFoundForInstance",
    "NetworkAmbiguous",
    "UnableToAutoAllocateNetwork",
    "NetworkRequiresSubnet",
    "ExternalNetworkAttachForbidden",
    "NetworkMissingPhysicalNetwork",
    "VifDetailsMissingVhostuserSockPath",
    "VifDetailsMissingMacvtapParameters",
    "DatastoreNotFound",
    "PortInUse",
    "PortRequiresFixedIP",
    "PortNotUsable",
    "PortNotUsableDNS",
    "PortBindingFailed",
    "PortBindingDeletionFailed",
    "PortBindingActivationFailed",
    "PortUpdateFailed",
    "AttachSRIOVPortNotSupported",
    "FixedIpNotFoundForAddress",
    "FixedIpNotFoundForInstance",
    "FixedIpAlreadyInUse",
    "FixedIpAssociatedWithMultipleInstances",
    "FixedIpInvalidOnHost",
    "NoMoreFixedIps",
    "FloatingIpNotFound",
    "FloatingIpNotFoundForAddress",
    "FloatingIpMultipleFoundForAddress",
    "FloatingIpPoolNotFound",
    "NoMoreFloatingIps",
    "FloatingIpAssociated",
    "NoFloatingIpInterface",
    "FloatingIpAssociateFailed",
    "FloatingIpBadRequest",
    "KeypairNotFound",
    "ServiceNotFound",
    "ConfGroupForServiceTypeNotFound",
    "ServiceBinaryExists",
    "ServiceTopicExists",
    "HostNotFound",
    "ComputeHostNotFound",
    "HostBinaryNotFound",
    "InvalidQuotaValue",
    "InvalidQuotaMethodUsage",
    "QuotaNotFound",
    "QuotaExists",
    "QuotaResourceUnknown",
    "ProjectUserQuotaNotFound",
    "ProjectQuotaNotFound",
    "QuotaClassNotFound",
    "QuotaClassExists",
    "OverQuota",
    "SecurityGroupNotFound",
    "SecurityGroupNotFoundForProject",
    "SecurityGroupExists",
    "SecurityGroupCannotBeApplied",
    "NoUniqueMatch",
    "NoActiveMigrationForInstance",
    "MigrationNotFound",
    "MigrationNotFoundByStatus",
    "MigrationNotFoundForInstance",
    "InvalidMigrationState",
    "ConsoleLogOutputException",
    "ConsoleNotAvailable",
    "ConsoleTypeInvalid",
    "ConsoleTypeUnavailable",
    "ConsolePortRangeExhausted",
    "FlavorNotFound",
    "FlavorNotFoundByName",
    "FlavorAccessNotFound",
    "FlavorExtraSpecUpdateCreateFailed",
    "CellTimeout",
    "SchedulerHostFilterNotFound",
    "FlavorExtraSpecsNotFound",
    "ComputeHostMetricNotFound",
    "FileNotFound",
    "ClassNotFound",
    "InstanceTagNotFound",
    "KeyPairExists",
    "InstanceExists",
    "FlavorExists",
    "FlavorIdExists",
    "FlavorAccessExists",
    "InvalidSharedStorage",
    "InvalidLocalStorage",
    "StorageError",
    "MigrationError",
    "MigrationPreCheckError",
    "MigrationSchedulerRPCError",
    "MalformedRequestBody",
    "ConfigNotFound",
    "PasteAppNotFound",
    "CannotResizeToSameFlavor",
    "ResizeError",
    "CannotResizeDisk",
    "FlavorMemoryTooSmall",
    "FlavorDiskTooSmall",
    "FlavorDiskSmallerThanImage",
    "FlavorDiskSmallerThanMinDisk",
    "VolumeSmallerThanMinDisk",
    "BootFromVolumeRequiredForZeroDiskFlavor",
    "NoValidHost",
    "RequestFilterFailed",
    "InvalidRoutedNetworkConfiguration",
    "MaxRetriesExceeded",
    "QuotaError",
    "TooManyInstances",
    "FloatingIpLimitExceeded",
    "MetadataLimitExceeded",
    "OnsetFileLimitExceeded",
    "OnsetFilePathLimitExceeded",
    "OnsetFileContentLimitExceeded",
    "KeypairLimitExceeded",
    "SecurityGroupLimitExceeded",
    "PortLimitExceeded",
    "AggregateNotFound",
    "AggregateNameExists",
    "AggregateHostNotFound",
    "AggregateMetadataNotFound",
    "AggregateHostExists",
    "InstancePasswordSetFailed",
    "InstanceNotFound",
    "InstanceInfoCacheNotFound",
    "MarkerNotFound",
    "CouldNotFetchImage",
    "CouldNotUploadImage",
    "TaskAlreadyRunning",
    "TaskNotRunning",
    "InstanceIsLocked",
    "ConfigDriveInvalidValue",
    "ConfigDriveUnsupportedFormat",
    "ConfigDriveMountFailed",
    "ConfigDriveUnknownFormat",
    "ConfigDriveNotFound",
    "InterfaceAttachFailed",
    "InterfaceAttachFailedNoNetwork",
    "InterfaceAttachPciClaimFailed",
    "InterfaceAttachResourceAllocationFailed",
    "InterfaceDetachFailed",
    "InstanceUserDataMalformed",
    "InstanceUpdateConflict",
    "UnknownInstanceUpdateConflict",
    "UnexpectedTaskStateError",
    "UnexpectedDeletingTaskStateError",
    "InstanceActionNotFound",
    "InstanceActionEventNotFound",
    "InstanceEvacuateNotSupported",
    "DBNotAllowed",
    "UnsupportedVirtType",
    "UnsupportedHardware",
    "UnsupportedRescueBus",
    "UnsupportedRescueDevice",
    "UnsupportedRescueImage",
    "Base64Exception",
    "BuildAbortException",
    "RescheduledException",
    "ShadowTableExists",
    "InstanceFaultRollback",
    "OrphanedObjectError",
    "ObjectActionError",
    "InstanceGroupNotFound",
    "InstanceGroupIdExists",
    "InstanceGroupSaveException",
    "ResourceMonitorError",
    "PciDeviceWrongAddressFormat",
    "PciDeviceInvalidDeviceName",
    "PciDeviceNotFoundById",
    "PciDeviceNotFound",
    "PciDeviceInvalidStatus",
    "PciDeviceVFInvalidStatus",
    "PciDevicePFInvalidStatus",
    "PciDeviceInvalidOwner",
    "PciDeviceRequestFailed",
    "PciDevicePoolEmpty",
    "PciInvalidAlias",
    "PciRequestAliasNotDefined",
    "PciConfigInvalidWhitelist",
    "PciRequestFromVIFNotFound",
    "InternalError",
    "PciDeviceDetachFailed",
    "PciDeviceUnsupportedHypervisor",
    "KeyManagerError",
    "VolumesNotRemoved",
    "VolumeRebaseFailed",
    "InvalidVideoMode",
    "RngDeviceNotExist",
    "RequestedVRamTooHigh",
    "SecurityProxyNegotiationFailed",
    "RFBAuthHandshakeFailed",
    "RFBAuthNoAvailableScheme",
    "InvalidWatchdogAction",
    "LiveMigrationNotSubmitted",
    "SelectionObjectsWithOldRPCVersionNotSupported",
    "LiveMigrationURINotAvailable",
    "UnshelveException",
    "MismatchVolumeAZException",
    "UnshelveInstanceInvalidState",
    "ImageVCPULimitsRangeExceeded",
    "ImageVCPUTopologyRangeExceeded",
    "ImageVCPULimitsRangeImpossible",
    "InvalidArchitectureName",
    "ImageNUMATopologyIncomplete",
    "ImageNUMATopologyForbidden",
    "ImageNUMATopologyRebuildConflict",
    "ImagePCINUMAPolicyForbidden",
    "ImageNUMATopologyAsymmetric",
    "ImageNUMATopologyCPUOutOfRange",
    "ImageNUMATopologyCPUDuplicates",
    "ImageNUMATopologyCPUsUnassigned",
    "ImageNUMATopologyMemoryOutOfRange",
    "InvalidHostname",
    "NumaTopologyNotFound",
    "MigrationContextNotFound",
    "SocketPortRangeExhaustedException",
    "SocketPortInUseException",
    "ImageSerialPortNumberInvalid",
    "ImageSerialPortNumberExceedFlavorValue",
    "SerialPortNumberLimitExceeded",
    "InvalidImageConfigDrive",
    "InvalidHypervisorVirtType",
    "InvalidMachineType",
    "InvalidMachineTypeUpdate",
    "UnsupportedMachineType",
    "InvalidVirtualMachineMode",
    "InvalidToken",
    "TokenInUse",
    "InvalidConnectionInfo",
    "InstanceQuiesceNotSupported",
    "InstanceAgentNotEnabled",
    "QemuGuestAgentNotEnabled",
    "SetAdminPasswdNotSupported",
    "MemoryPageSizeInvalid",
    "MemoryPageSizeForbidden",
    "MemoryPageSizeNotSupported",
    "CPUPinningInvalid",
    "CPUUnpinningInvalid",
    "CPUPinningUnknown",
    "CPUUnpinningUnknown",
    "ImageCPUPinningForbidden",
    "ImageCPUThreadPolicyForbidden",
    "ImagePMUConflict",
    "UnsupportedPolicyException",
    "CellMappingNotFound",
    "NUMATopologyUnsupported",
    "MemoryPagesUnsupported",
    "InvalidImageFormat",
    "UnsupportedImageModel",
    "HostMappingNotFound",
    "HostMappingExists",
    "RealtimeConfigurationInvalid",
    "CPUThreadPolicyConfigurationInvalid",
    "RequestSpecNotFound",
    "UEFINotSupported",
    "SecureBootNotSupported",
    "TriggerCrashDumpNotSupported",
    "UnsupportedHostCPUControlPolicy",
    "LibguestfsCannotReadKernel",
    "RealtimeMaskNotFoundOrInvalid",
    "OsInfoNotFound",
    "BuildRequestNotFound",
    "AttachInterfaceNotSupported",
    "AttachInterfaceWithQoSPolicyNotSupported",
    "NetworksWithQoSPolicyNotSupported",
    "CreateWithPortResourceRequestOldVersion",
    "InvalidReservedMemoryPagesOption",
    "ResourceProviderInUse",
    "ResourceProviderRetrievalFailed",
    "ResourceProviderAggregateRetrievalFailed",
    "ResourceProviderTraitRetrievalFailed",
    "ResourceProviderCreationFailed",
    "ResourceProviderDeletionFailed",
    "ResourceProviderUpdateFailed",
    "ResourceProviderNotFound",
    "ResourceProviderSyncFailed",
    "PlacementAPIConnectFailure",
    "PlacementAPIConflict",
    "ResourceProviderUpdateConflict",
    "InvalidResourceClass",
    "InvalidInventory",
    "InventoryInUse",
    "UsagesRetrievalFailed",
    "NotSupportedWithOption",
    "Unauthorized",
    "NeutronAdminCredentialConfigurationInvalid",
    "InvalidEmulatorThreadsPolicy",
    "InvalidCPUAllocationPolicy",
    "InvalidCPUThreadAllocationPolicy",
    "BadRequirementEmulatorThreadsPolicy",
    "InvalidNetworkNUMAAffinity",
    "InvalidPCINUMAAffinity",
    "PowerVMAPIFailed",
    "TraitRetrievalFailed",
    "TraitCreationFailed",
    "CannotMigrateToSameHost",
    "VirtDriverNotReady",
    "InvalidPeerList",
    "InstanceDiskMappingFailed",
    "NewMgmtMappingNotFoundException",
    "NoDiskDiscoveryException",
    "UniqueDiskDiscoveryException",
    "DeviceDeletionException",
    "OptRequiredIfOtherOptValue",
    "AllocationCreateFailed",
    "AllocationUpdateFailed",
    "AllocationMoveFailed",
    "AllocationDeleteFailed",
    "TooManyComputesForHost",
    "CertificateValidationFailed",
    "InstanceRescueFailure",
    "InstanceUnRescueFailure",
    "IronicAPIVersionNotAvailable",
    "ZVMDriverException",
    "ZVMConnectorError",
    "NoResourceClass",
    "ResourceProviderAllocationRetrievalFailed",
    "ConsumerAllocationRetrievalFailed",
    "ReshapeFailed",
    "ReshapeNeeded",
    "FlavorImageConflict",
    "MissingDomainCapabilityFeatureException",
    "HealPortAllocationException",
    "MoreThanOneResourceProviderToHealFrom",
    "NoResourceProviderToHealFrom",
    "UnableToQueryPorts",
    "UnableToUpdatePorts",
    "UnableToRollbackPortUpdates",
    "AssignedResourceNotFound",
    "PMEMNamespaceConfigInvalid",
    "GetPMEMNamespacesFailed",
    "VPMEMCleanupFailed",
    "RequestGroupSuffixConflict",
    "AmbiguousResourceProviderForPCIRequest",
    "UnexpectedResourceProviderNameForPCIRequest",
    "DeviceProfileError",
    "AcceleratorRequestOpFailed",
    "AcceleratorRequestBindingFailed",
    "InvalidLibvirtGPUConfig",
    "RequiredMixedInstancePolicy",
    "RequiredMixedOrRealtimeCPUMask",
    "MixedInstanceNotSupportByComputeService",
    "InvalidMixedInstanceDedicatedMask",
    "ProviderConfigException",
]

# sed -rn 's/^class\s+(\S+)\(.+/    "\1",/p' placement/exception.py
PLACEMENT_EXCEPTIONS = [
    "NotFound",
    "Exists",
    "InvalidInventory",
    "CannotDeleteParentResourceProvider",
    "ConcurrentUpdateDetected",
    "ResourceProviderConcurrentUpdateDetected",
    "ResourceProviderNotFound",
    "InvalidAllocationCapacityExceeded",
    "InvalidAllocationConstraintsViolated",
    "InvalidInventoryCapacity",
    "InvalidInventoryCapacityReservedCanBeTotal",
    "InventoryInUse",
    "InventoryWithResourceClassNotFound",
    "MaxDBRetriesExceeded",
    "ObjectActionError",
    "PolicyNotAuthorized",
    "ResourceClassCannotDeleteStandard",
    "ResourceClassCannotUpdateStandard",
    "ResourceClassExists",
    "ResourceClassInUse",
    "ResourceClassNotFound",
    "ResourceProviderInUse",
    "TraitCannotDeleteStandard",
    "TraitExists",
    "TraitInUse",
    "TraitNotFound",
    "ProjectNotFound",
    "ProjectExists",
    "UserNotFound",
    "UserExists",
    "ConsumerNotFound",
    "ConsumerExists",
    "ConsumerTypeNotFound",
    "ConsumerTypeExists",
]

# From:
#  - https://github.com/openstack/octavia/blob/master/octavia/common/exceptions.py
#  - https://github.com/openstack/octavia/blob/master/octavia/amphorae/driver_exceptions/exceptions.py
# sed -rn 's/^class\s+(\S+)\(.+/    "\1",/p' octavia/common/exceptions.py
# sed -rn 's/^class\s+(\S+)\(.+/    "\1",/p' octavia/network/base.py
OCTAVIA_EXCEPTIONS = [
# common/exceptions.py
    "OctaviaException",
    "APIException",
    "NotFound",
    "PolicyForbidden",
    "InvalidOption",
    "InvalidFilterArgument",
    "DisabledOption",
    "L7RuleValidation",
    "SingleCreateDetailsMissing",
    "InvalidHMACException",
    "MissingArguments",
    "NetworkConfig",
    "NeedsPassphrase",
    "UnreadableCert",
    "UnreadablePKCS12",
    "MisMatchedKey",
    "CertificateRetrievalException",
    "CertificateStorageException",
    "CertificateGenerationException",
    "DuplicateListenerEntry",
    "DuplicateMemberEntry",
    "DuplicateHealthMonitor",
    "DuplicatePoolEntry",
    "PoolInUseByL7Policy",
    "ImmutableObject",
    "LBPendingStateError",
    "TooManyL7RulesOnL7Policy",
    "ComputeBuildException",
    "ComputeBuildQueueTimeoutException",
    "ComputeDeleteException",
    "ComputeGetException",
    "ComputeStatusException",
    "ComputeGetInterfaceException",
    "IDAlreadyExists",
    "RecordAlreadyExists",
    "NoReadyAmphoraeException",
    "ImageGetException",
    "ComputeWaitTimeoutException",
    "ComputePortInUseException",
    "ComputeUnknownException",
    "InvalidTopology",
    "InvalidL7PolicyAction",
    "InvalidL7PolicyArgs",
    "InvalidURL",
    "InvalidURLPath",
    "InvalidString",
    "InvalidRegex",
    "InvalidL7Rule",
    "ServerGroupObjectCreateException",
    "ServerGroupObjectDeleteException",
    "InvalidAmphoraOperatingSystem",
    "QuotaException",
    "ProjectBusyException",
    "MissingProjectID",
    "MissingAPIProjectID",
    "InvalidSubresource",
    "ValidationException",
    "VIPValidationException",
    "InvalidSortKey",
    "InvalidSortDirection",
    "InvalidMarker",
    "InvalidLimit",
    "MissingVIPSecurityGroup",
    "ProviderNotEnabled",
    "ProviderNotFound",
    "ProviderDriverError",
    "ProviderNotImplementedError",
    "ProviderUnsupportedOptionError",
    "InputFileError",
    "ObjectInUse",
    "ProviderFlavorMismatchError",
    "VolumeDeleteException",
    "VolumeGetException",
    "NetworkServiceError",
    "InvalidIPAddress",
# amphora/driver_exceptions/exceptions.py
    "AmphoraDriverError",
    "NotFoundError",
    "InfoException",
    "MetricsException",
    "UnauthorizedException",
    "StatisticsException",
    "TimeOutException",
    "DeleteFailed",
    "SuspendFailed",
    "EnableFailed",
    "ArchiveException",
    "ProvisioningErrors",
    "ListenerProvisioningError",
    "LoadBalancerProvisoningError",
    "HealthMonitorProvisioningError",
    "NodeProvisioningError",
    "AmpDriverNotImplementedError",
    "AmpConnectionRetry",
# network/base.py
    "NetworkException",
    "PlugVIPException",
    "UnplugVIPException",
    "AllocateVIPException",
    "DeallocateVIPException",
    "PlugNetworkException",
    "UnplugNetworkException",
    "VIPInUseException",
    "PortNotFound",
    "NetworkNotFound",
    "SubnetNotFound",
    "AmphoraNotFound",
    "PluggedVIPNotFound",
    "TimeoutException",
    "QosPolicyNotFound",
    "SecurityGroupNotFound",
    "CreatePortException",
    "AbstractNetworkDriver",
]

# From https://github.com/openstack/manila/blob/master/manila/exception.py
# sed -rn 's/^class\s+(\S+)\(.+/    "\1",/p' manila/exception.py
MANILA_EXCEPTIONS = [
    "ConvertedException",
    "Error",
    "ManilaException",
    "NetworkException",
    "NetworkBindException",
    "NetworkBadConfigurationException",
    "BadConfigurationException",
    "NotAuthorized",
    "AdminRequired",
    "PolicyNotAuthorized",
    "Conflict",
    "Invalid",
    "InvalidRequest",
    "InvalidResults",
    "InvalidInput",
    "InvalidContentType",
    "InvalidHost",
    "InvalidParameterValue",
    "InvalidUUID",
    "InvalidDriverMode",
    "InvalidAPIVersionString",
    "VersionNotFoundForAPIMethod",
    "InvalidGlobalAPIVersion",
    "InvalidCapacity",
    "NotFound",
    "MessageNotFound",
    "Found",
    "InUse",
    "AvailabilityZoneNotFound",
    "ShareNetworkNotFound",
    "ShareNetworkSubnetNotFound",
    "ShareServerNotFound",
    "ShareServerNotFoundByFilters",
    "InvalidShareNetwork",
    "ShareServerInUse",
    "ShareServerMigrationError",
    "ShareServerMigrationFailed",
    "InvalidShareServer",
    "ShareMigrationError",
    "ShareMigrationFailed",
    "ShareDataCopyFailed",
    "ShareDataCopyCancelled",
    "ServiceIPNotFound",
    "AdminIPNotFound",
    "ShareServerNotCreated",
    "ShareServerNotReady",
    "ServiceNotFound",
    "ServiceIsDown",
    "HostNotFound",
    "SchedulerHostFilterNotFound",
    "SchedulerHostWeigherNotFound",
    "HostBinaryNotFound",
    "InvalidReservationExpiration",
    "InvalidQuotaValue",
    "QuotaNotFound",
    "QuotaExists",
    "QuotaResourceUnknown",
    "ProjectUserQuotaNotFound",
    "ProjectShareTypeQuotaNotFound",
    "ProjectQuotaNotFound",
    "QuotaClassNotFound",
    "QuotaUsageNotFound",
    "ReservationNotFound",
    "OverQuota",
    "MigrationNotFound",
    "MigrationNotFoundByStatus",
    "FileNotFound",
    "MigrationError",
    "MalformedRequestBody",
    "ConfigNotFound",
    "PasteAppNotFound",
    "NoValidHost",
    "WillNotSchedule",
    "QuotaError",
    "ShareSizeExceedsAvailableQuota",
    "SnapshotSizeExceedsAvailableQuota",
    "ShareSizeExceedsLimit",
    "ShareLimitExceeded",
    "SnapshotLimitExceeded",
    "ShareNetworksLimitExceeded",
    "ShareGroupsLimitExceeded",
    "ShareGroupSnapshotsLimitExceeded",
    "ShareReplicasLimitExceeded",
    "ShareReplicaSizeExceedsAvailableQuota",
#    "GlusterfsException",
    "InvalidShare",
    "ShareBusyException",
    "InvalidShareInstance",
    "ManageInvalidShare",
    "ManageShareServerError",
    "UnmanageInvalidShare",
    "PortLimitExceeded",
    "ShareAccessExists",
    "ShareAccessMetadataNotFound",
    "ShareSnapshotAccessExists",
    "InvalidSnapshotAccess",
    "InvalidShareAccess",
    "InvalidShareAccessLevel",
    "InvalidShareAccessType",
    "ShareBackendException",
    "ExportLocationNotFound",
    "ShareNotFound",
    "ShareSnapshotNotFound",
    "ShareSnapshotInstanceNotFound",
    "ShareSnapshotNotSupported",
    "ShareGroupSnapshotNotSupported",
    "ShareSnapshotIsBusy",
    "InvalidShareSnapshot",
    "InvalidShareSnapshotInstance",
    "ManageInvalidShareSnapshot",
    "UnmanageInvalidShareSnapshot",
    "ShareMetadataNotFound",
    "InvalidMetadata",
    "InvalidMetadataSize",
    "SecurityServiceNotFound",
    "InvalidSecurityService",
    "ShareNetworkSecurityServiceAssociationError",
    "ShareNetworkSecurityServiceDissociationError",
    "SecurityServiceFailedAuth",
    "InvalidVolume",
    "InvalidShareType",
    "InvalidShareGroupType",
    "InvalidExtraSpec",
    "VolumeNotFound",
    "VolumeSnapshotNotFound",
    "ShareTypeNotFound",
    "ShareGroupTypeNotFound",
    "ShareTypeAccessNotFound",
    "ShareGroupTypeAccessNotFound",
    "ShareTypeNotFoundByName",
    "ShareGroupTypeNotFoundByName",
    "ShareTypeExtraSpecsNotFound",
    "ShareGroupTypeSpecsNotFound",
    "ShareTypeInUse",
    "IPAddressInUse",
    "ShareGroupTypeInUse",
    "ShareTypeExists",
    "ShareTypeDoesNotExist",
    "DefaultShareTypeNotConfigured",
    "ShareGroupTypeExists",
    "ShareTypeAccessExists",
    "ShareGroupTypeAccessExists",
    "ShareTypeCreateFailed",
    "ShareTypeUpdateFailed",
    "ShareGroupTypeCreateFailed",
    "ManageExistingShareTypeMismatch",
    "ShareExtendingError",
    "ShareShrinkingError",
    "ShareShrinkingPossibleDataLoss",
    "InstanceNotFound",
    "BridgeDoesNotExist",
    "ServiceInstanceException",
    "ServiceInstanceUnavailable",
    "StorageResourceException",
    "StorageResourceNotFound",
    "SnapshotResourceNotFound",
    "SnapshotUnavailable",
#    "NetAppException",
#    "VserverNotFound",
#    "VserverNotSpecified",
#    "VserverNotReady",
#    "EMCPowerMaxXMLAPIError",
#    "EMCPowerMaxLockRequiredException",
#    "EMCPowerMaxInvalidMoverID",
#    "EMCVnxXMLAPIError",
#    "EMCVnxLockRequiredException",
#    "EMCVnxInvalidMoverID",
#    "EMCUnityError",
#    "HPE3ParInvalidClient",
#    "HPE3ParInvalid",
#    "HPE3ParUnexpectedError",
#    "GPFSException",
#    "GPFSGaneshaException",
    "GaneshaCommandFailure",
    "InvalidSqliteDB",
    "SSHException",
#    "HDFSException",
#    "MapRFSException",
#    "ZFSonLinuxException",
    "QBException",
    "QBRpcException",
    "SSHInjectionThreat",
#    "HNASBackendException",
#    "HNASConnException",
#    "HNASSSCIsBusy",
#    "HNASSSCContextChange",
#    "HNASDirectoryNotEmpty",
#    "HNASItemNotFoundException",
#    "HNASNothingToCloneException",
    "ShareGroupNotFound",
    "ShareGroupSnapshotNotFound",
    "ShareGroupSnapshotMemberNotFound",
    "InvalidShareGroup",
    "InvalidShareGroupSnapshot",
    "DriverNotInitialized",
    "ShareResourceNotFound",
    "ShareUmountException",
    "ShareMountException",
    "ShareCopyDataException",
    "ReplicationException",
    "ShareReplicaNotFound",
#    "TegileAPIException",
    "StorageCommunicationException",
    "EvaluatorParseException",
#    "HSPBackendException",
#    "HSPTimeoutException",
#    "HSPItemNotFoundException",
#    "NexentaException",
    "LockCreationFailed",
    "LockingFailed",
    "GaneshaException",
#    "InfortrendCLIException",
#    "InfortrendNASException",
#    "ZadaraUnknownCmd",
#    "ZadaraSessionRequestException",
#    "ZadaraBadHTTPResponseStatus",
#    "ZadaraFailedCmdWithDump",
#    "ZadaraVPSANoActiveController",
#    "ZadaraServerCreateFailure",
#    "ZadaraAttachmentsNotFound",
#    "ZadaraManilaInvalidAccessKey",
#    "ZadaraVPSAVolumeShareFailed",
#    "ZadaraInvalidShareAccessType",
#    "ZadaraShareNotFound",
#    "ZadaraExtendShareFailed",
#    "ZadaraInvalidProtocol",
#    "ZadaraShareNotValid",
#    "ZadaraVPSASnapshotCreateFailed",
#    "ZadaraVPSASnapshotManageFailed",
#    "ZadaraServerNotFound",
]

# sed -rn 's/^class\s+(\S+)\(.+/    "\1",/p' cinder/exception.py
CINDER_EXCEPTIONS = [
    "ConvertedException",
    "CinderException",
    "VolumeBackendAPIException",
    "VolumeDriverException",
    "BackupDriverException",
    "BackupRestoreCancel",
    "GlanceConnectionFailed",
    "ProgrammingError",
    "NotAuthorized",
    "AdminRequired",
    "PolicyNotAuthorized",
    "ImageNotAuthorized",
    "DriverNotInitialized",
    "Invalid",
    "InvalidSnapshot",
    "InvalidVolumeAttachMode",
    "VolumeAttached",
    "InvalidResults",
    "InvalidInput",
    "InvalidAvailabilityZone",
    "InvalidTypeAvailabilityZones",
    "InvalidVolumeType",
    "InvalidGroupType",
    "InvalidVolume",
    "InvalidContentType",
    "InvalidHost",
    "InvalidParameterValue",
    "InvalidAuthKey",
    "InvalidConfigurationValue",
    "ServiceUnavailable",
    "UnavailableDuringUpgrade",
    "ImageUnacceptable",
    "ImageTooBig",
    "DeviceUnavailable",
    "SnapshotUnavailable",
    "InvalidUUID",
    "InvalidAPIVersionString",
    "VersionNotFoundForAPIMethod",
    "InvalidGlobalAPIVersion",
    "ValidationError",
    "APIException",
    "APITimeout",
    "RPCTimeout",
    "Duplicate",
    "NotFound",
    "GlanceStoreNotFound",
    "GlanceStoreReadOnly",
    "VolumeNotFound",
    "MessageNotFound",
    "VolumeAttachmentNotFound",
    "VolumeMetadataNotFound",
    "InvalidVolumeMetadata",
    "InvalidVolumeMetadataSize",
    "SnapshotMetadataNotFound",
    "VolumeTypeNotFound",
    "VolumeTypeNotFoundByName",
    "VolumeTypeAccessNotFound",
    "VolumeTypeExtraSpecsNotFound",
    "VolumeTypeInUse",
    "VolumeTypeDeletionError",
    "VolumeTypeDefaultDeletionError",
    "VolumeTypeDefaultMisconfiguredError",
    "VolumeTypeProjectDefaultNotFound",
    "GroupTypeNotFound",
    "GroupTypeNotFoundByName",
    "GroupTypeAccessNotFound",
    "GroupTypeSpecsNotFound",
    "GroupTypeInUse",
    "SnapshotNotFound",
    "ServerNotFound",
    "VolumeSnapshotNotFound",
    "VolumeIsBusy",
    "SnapshotIsBusy",
    "InvalidImageRef",
    "InvalidSignatureImage",
    "ImageSignatureVerificationException",
    "ImageNotFound",
    "ServiceNotFound",
    "ServiceTooOld",
    "WorkerNotFound",
    "WorkerExists",
    "CleanableInUse",
    "ClusterNotFound",
    "ClusterHasHosts",
    "ClusterExists",
    "HostNotFound",
    "SchedulerHostFilterNotFound",
    "SchedulerHostWeigherNotFound",
    "InvalidReservationExpiration",
    "InvalidQuotaValue",
    "QuotaNotFound",
    "QuotaResourceUnknown",
    "ProjectQuotaNotFound",
    "QuotaClassNotFound",
    "QuotaUsageNotFound",
    "OverQuota",
    "FileNotFound",
    "VolumeTypeExists",
    "VolumeTypeAccessExists",
    "VolumeTypeEncryptionExists",
    "VolumeTypeEncryptionNotFound",
    "GroupTypeExists",
    "GroupTypeAccessExists",
    "GroupVolumeTypeMappingExists",
    "MalformedRequestBody",
    "ConfigNotFound",
    "ParameterNotFound",
    "NoValidBackend",
    "QuotaError",
    "VolumeSizeExceedsAvailableQuota",
    "VolumeSizeExceedsLimit",
    "VolumeBackupSizeExceedsAvailableQuota",
    "VolumeLimitExceeded",
    "SnapshotLimitExceeded",
    "UnexpectedOverQuota",
    "BackupLimitExceeded",
    "ImageLimitExceeded",
    "VolumeTypeCreateFailed",
    "VolumeTypeUpdateFailed",
    "GroupTypeCreateFailed",
    "GroupTypeUpdateFailed",
    "GroupLimitExceeded",
    "UnknownCmd",
    "MalformedResponse",
    "FailedCmdWithDump",
    "InvalidConnectorException",
    "GlanceMetadataExists",
    "GlanceMetadataNotFound",
    "ImageDownloadFailed",
    "ExportFailure",
    "RemoveExportException",
    "MetadataUpdateFailure",
    "MetadataCopyFailure",
    "InvalidMetadataType",
    "ImageCopyFailure",
    "BackupInvalidCephArgs",
    "BackupOperationError",
    "BackupMetadataUnsupportedVersion",
    "BackupMetadataNotFound",
    "VolumeMetadataBackupExists",
    "BackupRBDOperationFailed",
    "EncryptedBackupOperationFailed",
    "BackupNotFound",
    "InvalidBackup",
    "SwiftConnectionFailed",
    "TransferNotFound",
    "VolumeMigrationFailed",
    "SSHInjectionThreat",
    "QoSSpecsExists",
    "QoSSpecsCreateFailed",
    "QoSSpecsUpdateFailed",
    "QoSSpecsNotFound",
    "QoSSpecsAssociateFailed",
    "QoSSpecsDisassociateFailed",
    "QoSSpecsKeyNotFound",
    "InvalidQoSSpecs",
    "QoSSpecsInUse",
    "KeyManagerError",
    "ManageExistingInvalidReference",
    "ManageExistingAlreadyManaged",
    "InvalidReplicationTarget",
    "UnableToFailOver",
    "ReplicationError",
    "ReplicationGroupError",
    "ManageExistingVolumeTypeMismatch",
    "ExtendVolumeError",
    "EvaluatorParseException",
    "LockCreationFailed",
    "CappedVersionUnknown",
    "VolumeGroupNotFound",
    "VolumeGroupCreationFailed",
    "VolumeNotDeactivated",
    "VolumeDeviceNotFound",
    "RemoteFSException",
    "RemoteFSConcurrentRequest",
    "RemoteFSNoSharesMounted",
    "RemoteFSNoSuitableShareFound",
    "RemoteFSInvalidBackingFile",
    "NfsException",
    "NfsNoSharesMounted",
    "NfsNoSuitableShareFound",
    "ZoneManagerException",
    "FCZoneDriverException",
    "FCSanLookupServiceException",
    "ZoneManagerNotInitialized",
    "ConsistencyGroupNotFound",
    "InvalidConsistencyGroup",
    "GroupNotFound",
    "InvalidGroup",
    "InvalidGroupStatus",
    "CgSnapshotNotFound",
    "InvalidCgSnapshot",
    "GroupSnapshotNotFound",
    "InvalidGroupSnapshot",
    "InvalidGroupSnapshotStatus",
    "ISCSITargetCreateFailed",
    "ISCSITargetRemoveFailed",
    "ISCSITargetAttachFailed",
    "ISCSITargetDetachFailed",
    "TargetUpdateFailed",
    "ISCSITargetHelperCommandFailed",
    "BadHTTPResponseStatus",
    "BadResetResourceStatus",
    "MetadataAbsent",
    "NotSupportedOperation",
    "AttachmentSpecsNotFound",
    "InvalidName",
    "ServiceUserTokenNoAuth",
    "RekeyNotSupported",
    "ImageCompressionNotAllowed",
    "CinderAcceleratorError",
    "SnapshotLimitReached",
]

# sed -rn 's/^class\s+(\S+)\(.+/    "\1",/p' castellan/common/exception.py
CASTELLAN_EXCEPTIONS = [
    "RedirectException",
    "CastellanException",
    "Forbidden",
    "KeyManagerError",
    "ManagedObjectNotFoundError",
    "InvalidManagedObjectDictError",
    "UnknownManagedObjectTypeError",
    "AuthTypeInvalidError",
    "InsufficientCredentialDataError",
]

# sed -rn 's/^class\s+(\S+)\(.+/    "\1",/p' barbican/common/exception.py
BARBICAN_EXCEPTIONS = [
    "BarbicanException",
    "BarbicanHTTPException",
    "MissingArgumentError",
    "MissingMetadataField",
    "InvalidMetadataRequest",
    "InvalidMetadataKey",
    "InvalidSubjectDN",
    "InvalidContainer",
    "InvalidExtensionsData",
    "InvalidCMCData",
    "InvalidPKCS10Data",
    "InvalidCertificateRequestType",
    "CertificateExtensionsNotSupported",
    "FullCMCNotSupported",
    "NotFound",
    "ConstraintCheck",
    "NotSupported",
    "Invalid",
    "NoDataToProcess",
    "LimitExceeded",
    "InvalidObject",
    "PayloadDecodingError",
    "UnsupportedField",
    "FeatureNotImplemented",
    "StoredKeyContainerNotFound",
    "StoredKeyPrivateKeyNotFound",
    "ProvidedTransportKeyNotFound",
    "InvalidCAID",
    "CANotDefinedForProject",
    "QuotaReached",
    "InvalidParentCA",
    "SubCAsNotSupported",
    "SubCANotCreated",
    "CannotDeleteBaseCA",
    "UnauthorizedSubCA",
    "CannotDeletePreferredCA",
    "BadSubCACreationRequest",
    "SubCACreationErrors",
    "SubCADeletionErrors",
    "PKCS11Exception",
    "P11CryptoPluginKeyException",
    "P11CryptoPluginException",
    "P11CryptoKeyHandleException",
    "P11CryptoTokenException",
    "MultipleStorePreferredPluginMissing",
    "MultipleStorePluginStillInUse",
    "MultipleSecretStoreLookupFailed",
    "MultipleStoreIncorrectGlobalDefault",
    "MultipleStorePluginValueMissing",
]

# sed -rn 's/^class\s+(\S+)\(.+/    "\1",/p' glance_store/exceptions.py
GLANCE_STORE_EXCEPTIONS = [
    "BackendException",
    "UnsupportedBackend",
    "RedirectException",
    "GlanceStoreException",
    "MissingCredentialError",
    "BadAuthStrategy",
    "AuthorizationRedirect",
    "NotFound",
    "UnknownHashingAlgo",
    "UnknownScheme",
    "BadStoreUri",
    "Duplicate",
    "StorageFull",
    "StorageWriteDenied",
    "AuthBadRequest",
    "AuthUrlNotFound",
    "AuthorizationFailure",
    "NotAuthenticated",
    "Forbidden",
    "Invalid",
    "BadStoreConfiguration",
    "DriverLoadFailure",
    "StoreDeleteNotSupported",
    "StoreGetNotSupported",
    "StoreRandomGetNotSupported",
    "StoreAddDisabled",
    "MaxRedirectsExceeded",
    "NoServiceEndpoint",
    "RegionAmbiguity",
    "RemoteServiceUnavailable",
    "HasSnapshot",
    "InUseByStore",
    "HostNotInitialized",
]

# sed -rn 's/^class\s+(\S+)\(.+/    "\1",/p' glance/common/exception.py
GLANCE_EXCEPTIONS = [
    "RedirectException",
    "GlanceException",
    "MissingCredentialError",
    "BadAuthStrategy",
    "NotFound",
    "BadStoreUri",
    "Duplicate",
    "Conflict",
    "StorageQuotaFull",
    "AuthBadRequest",
    "AuthUrlNotFound",
    "AuthorizationFailure",
    "NotAuthenticated",
    "UploadException",
    "Forbidden",
    "ForbiddenPublicImage",
    "ProtectedImageDelete",
    "ProtectedMetadefNamespaceDelete",
    "ProtectedMetadefNamespacePropDelete",
    "ProtectedMetadefObjectDelete",
    "ProtectedMetadefResourceTypeAssociationDelete",
    "ProtectedMetadefResourceTypeSystemDelete",
    "ProtectedMetadefTagDelete",
    "Invalid",
    "InvalidSortKey",
    "InvalidSortDir",
    "InvalidPropertyProtectionConfiguration",
    "InvalidSwiftStoreConfiguration",
    "InvalidFilterOperatorValue",
    "InvalidFilterRangeValue",
    "InvalidOptionValue",
    "ReadonlyProperty",
    "ReservedProperty",
    "AuthorizationRedirect",
    "ClientConnectionError",
    "ClientConfigurationError",
    "MultipleChoices",
    "LimitExceeded",
    "ServiceUnavailable",
    "ServerError",
    "UnexpectedStatus",
    "InvalidContentType",
    "BadRegistryConnectionConfiguration",
    "BadDriverConfiguration",
    "MaxRedirectsExceeded",
    "InvalidRedirect",
    "NoServiceEndpoint",
    "RegionAmbiguity",
    "WorkerCreationFailure",
    "SchemaLoadError",
    "InvalidObject",
    "ImageSizeLimitExceeded",
    "FailedToGetScrubberJobs",
    "ImageMemberLimitExceeded",
    "ImagePropertyLimitExceeded",
    "ImageTagLimitExceeded",
    "ImageLocationLimitExceeded",
    "SIGHUPInterrupt",
    "RPCError",
    "TaskException",
    "BadTaskConfiguration",
    "ImageNotFound",
    "TaskNotFound",
    "InvalidTaskStatus",
    "InvalidTaskType",
    "InvalidTaskStatusTransition",
    "ImportTaskError",
    "TaskAbortedError",
    "DuplicateLocation",
    "InvalidParameterValue",
    "InvalidImageStatusTransition",
    "MetadefDuplicateNamespace",
    "MetadefDuplicateObject",
    "MetadefDuplicateProperty",
    "MetadefDuplicateResourceType",
    "MetadefDuplicateResourceTypeAssociation",
    "MetadefDuplicateTag",
    "MetadefForbidden",
    "MetadefIntegrityError",
    "MetadefNamespaceNotFound",
    "MetadefObjectNotFound",
    "MetadefPropertyNotFound",
    "MetadefResourceTypeNotFound",
    "MetadefResourceTypeAssociationNotFound",
    "MetadefTagNotFound",
    "InvalidDataMigrationScript",
]

# Neutron exception definitions are distributed across multiple modules/files
# and projects.
#
# neutron:
# find -name exception\*.py| xargs -l sed -rn 's/^class\s+(\S+)\(.+/    "\1",/p'
#
# neutron-lib:
# sed -rn 's/^class\s+(\S+)\(.+/    "\1",/p' ./neutron_lib/exceptions/*
#
# neutron extras
# sed -rn 's/\S+ (\S+)\(RuntimeError\):.*/    "\1",/p' ./neutron/privileged/agent/linux/ip_lib.py
NEUTRON_EXCEPTIONS = [
    # repo:neutron
    "OVSDBPortError",
    "SriovUnsupportedNetworkType",
    "SriovNicError",
    "InvalidDeviceError",
    "InvalidPciSlotError",
    "MechanismDriverError",
    "ExtensionDriverError",
    "ExtensionDriverNotFound",
    "UnknownNetworkType",
    "OVSFWPortNotFound",
    "OVSFWTagNotFound",
    "OVSFWPortNotHandled",
    "OvsdbSslConfigNotFound",
    "OvsdbSslRequiredOptError",
    "RevisionConflict",
    "UnknownResourceType",
    "StandardAttributeIDNotFound",
    "HashRingIsEmpty",
    "InvalidSubnetRequestType",
    "AddressCalculationFailure",
    "InvalidAddressType",
    "IpAddressAlreadyAllocated",
    "InvalidIpForSubnet",
    "InvalidAddressRequest",
    "InvalidSubnetRequest",
    "IPAddressChangeNotAllowed",
    "AllocationOnAutoAddressSubnet",
    "IpAddressGenerationFailure",
    "IpAddressGenerationFailureAllSubnets",
    "IpAddressGenerationFailureNoMatchingSubnet",
    "IPAllocationFailed",
    "IpamValueInvalid",
    "DeferIpam",
    "SegmentNotFound",
    "NoUpdateSubnetWhenMultipleSegmentsOnNetwork",
    "SubnetsNotAllAssociatedWithSegments",
    "SubnetCantAssociateToDynamicSegment",
    "SubnetSegmentAssociationChangeNotAllowed",
    "NetworkIdsDontMatch",
    "HostNotConnectedToAnySegment",
    "HostNotCompatibleWithFixedIps",
    "SegmentInUse",
    "FixedIpsSubnetsNotOnSameSegment",
    "AutoAllocationFailure",
    "DefaultExternalNetworkExists",
    "UnknownProvisioningError",
    "ConntrackHelperNotFound",
    "ConntrackHelperNotAllowed",
    "InvalidProtocolForHelper",
    "RouterGatewayInUseByNDPProxy",
    "RouterInterfaceInUseByNDPProxy",
    "AddressScopeConflict",
    "RouterGatewayNotValid",
    "RouterNDPProxyNotEnable",
    "PortUnreachableRouter",
    "InvalidAddress",
    "RouterIPv6GatewayInUse",
    "NDPProxyNotFound",
    "LogResourceNotFound",
    "InvalidLogResourceType",
    "LoggingTypeNotSupported",
    "TargetResourceNotFound",
    "ResourceNotFound",
    "InvalidResourceConstraint",
    "LogapiDriverException",
    "CookieNotFound",
    "ValidatedMethodNotFound",
    "ResourceIdNotSpecified",
    "RouterNotEnabledSnat",
    "EventsDisabled",
    "RouterGatewayNotSet",
    "PortForwardingNotFound",
    "PortForwardingNotSupportFilterField",
    "PortHasPortForwarding",
    "FipInUseByPortForwarding",
    "PortHasBindingFloatingIP",
    "MechanismDriverNotFound",
    "TrunkBridgeNotFound",
    "ParentPortNotFound",
    "TrunkPortInUse",
    "TrunkNotFound",
    "SubPortNotFound",
    "DuplicateSubPort",
    "ParentPortInUse",
    "SubPortMtuGreaterThanTrunkPortMtu",
    "PortInUseAsTrunkParent",
    "PortInUseAsSubPort",
    "TrunkInUse",
    "TrunkDisabled",
    "TrunkInErrorState",
    "IncompatibleTrunkPluginConfiguration",
    "IncompatibleDriverSegmentationTypes",
    "SegmentationTypeValidatorNotFound",
    "TrunkPluginDriverConflict",
    "SubPortBindingError",
    "CallbackWrongResourceType",
    "CallbackNotFound",
    "CallbacksMaxLimitReached",
    "NoAgentDbMixinImplemented",
    # repo: neutron (extras)
    "NetworkNamespaceNotFound",
    "NetworkInterfaceNotFound",
    "InterfaceOperationNotSupported",
    "InvalidArgument",
    "IpAddressAlreadyExists",
    "InterfaceAlreadyExists",
    # repo:neutron-lib
    "AddressGroupNotFound",
    "AddressGroupInUse",
    "AddressesNotFound",
    "AddressesAlreadyExist",
    "AddressScopeNotFound",
    "AddressScopeInUse",
    "AddressScopeUpdateError",
    "NetworkAddressScopeAffinityError",
    "AgentNotFound",
    "AgentNotFoundByTypeHost",
    "MultipleAgentFoundByTypeHost",
    "AllowedAddressPairsMissingIP",
    "AddressPairAndPortSecurityRequired",
    "DuplicateAddressPairInRequest",
    "AllowedAddressPairExhausted",
    "AvailabilityZoneNotFound",
    "InvalidDHCPAgent",
    "NetworkHostedByDHCPAgent",
    "NetworkNotHostedByDhcpAgent",
    "DNSDomainNotFound",
    "DuplicateRecordSet",
    "ExternalDNSDriverNotFound",
    "InvalidPTRZoneConfiguration",
    "DVRMacAddressNotFound",
    "ExternalNetworkInUse",
    "InvalidRoutes",
    "RouterInterfaceInUseByRoute",
    "RoutesExhausted",
    "FirewallGroupNotFound",
    "FirewallGroupInUse",
    "FirewallGroupInPendingState",
    "FirewallGroupPortInvalid",
    "FirewallGroupPortInvalidProject",
    "FirewallGroupPortInUse",
    "FirewallPolicyNotFound",
    "FirewallPolicyInUse",
    "FirewallPolicyConflict",
    "FirewallRuleSharingConflict",
    "FirewallPolicySharingConflict",
    "FirewallRuleNotFound",
    "FirewallRuleInUse",
    "FirewallRuleNotAssociatedWithPolicy",
    "FirewallRuleInvalidProtocol",
    "FirewallRuleInvalidAction",
    "FirewallRuleInvalidICMPParameter",
    "FirewallRuleWithPortWithoutProtocolInvalid",
    "FirewallRuleInvalidPortValue",
    "FirewallRuleInfoMissing",
    "FirewallIpAddressConflict",
    "FirewallInternalDriverError",
    "FirewallRuleConflict",
    "FirewallRuleAlreadyAssociated",
    "FirewallGroupCannotRemoveDefault",
    "FirewallGroupCannotUpdateDefault",
    "FirewallGroupDefaultAlreadyExists",
    "FlavorNotFound",
    "FlavorInUse",
    "ServiceProfileNotFound",
    "ServiceProfileInUse",
    "FlavorServiceProfileBindingExists",
    "FlavorServiceProfileBindingNotFound",
    "ServiceProfileDriverNotFound",
    "ServiceProfileEmpty",
    "FlavorDisabled",
    "ServiceProfileDisabled",
    "NeutronException",
    "BadRequest",
    "NotFound",
    "Conflict",
    "NotAuthorized",
    "ServiceUnavailable",
    "AdminRequired",
    "ObjectNotFound",
    "NetworkNotFound",
    "SubnetNotFound",
    "PortNotFound",
    "PortNotFoundOnNetwork",
    "DeviceNotFoundError",
    "InUse",
    "NetworkInUse",
    "SubnetInUse",
    "SubnetPoolInUse",
    "PortInUse",
    "ServicePortInUse",
    "PortBound",
    "PortBoundNUMAAffinityPolicy",
    "MacAddressInUse",
    "InvalidIpForNetwork",
    "InvalidIpForSubnet",
    "IpAddressInUse",
    "VlanIdInUse",
    "TunnelIdInUse",
    "ResourceExhausted",
    "NoNetworkAvailable",
    "SubnetMismatchForPort",
    "Invalid",
    "InvalidInput",
    "IpAddressGenerationFailure",
    "PreexistingDeviceFailure",
    "OverQuota",
    "InvalidContentType",
    "ExternalIpAddressExhausted",
    "InvalidConfigurationOption",
    "NetworkTunnelRangeError",
    "PolicyInitError",
    "PolicyCheckError",
    "MultipleExceptions",
    "HostMacAddressGenerationFailure",
    "NetworkMacAddressGenerationFailure",
    "InvalidServiceType",
    "NetworkVlanRangeError",
    "PhysicalNetworkNameError",
    "TenantIdProjectIdFilterConflict",
    "SubnetPoolNotFound",
    "StateInvalid",
    "DhcpPortInUse",
    "HostRoutesExhausted",
    "DNSNameServersExhausted",
    "FlatNetworkInUse",
    "NoNetworkFoundInMaximumAllowedAttempts",
    "MalformedRequestBody",
    "InvalidAllocationPool",
    "UnsupportedPortDeviceOwner",
    "OverlappingAllocationPools",
    "OutOfBoundsAllocationPool",
    "BridgeDoesNotExist",
    "QuotaResourceUnknown",
    "QuotaMissingTenant",
    "InvalidQuotaValue",
    "InvalidSharedSetting",
    "ExtensionsNotFound",
    "GatewayConflictWithAllocationPools",
    "GatewayIpInUse",
    "NetworkVxlanPortRangeError",
    "VxlanNetworkUnsupported",
    "DuplicatedExtension",
    "DriverCallError",
    "DeviceIDNotOwnedByTenant",
    "InvalidCIDR",
    "FailToDropPrivilegesExit",
    "NetworkIdOrRouterIdRequiredError",
    "EmptySubnetPoolPrefixList",
    "PrefixVersionMismatch",
    "UnsupportedMinSubnetPoolPrefix",
    "IllegalSubnetPoolPrefixBounds",
    "IllegalSubnetPoolPrefixUpdate",
    "SubnetAllocationError",
    "AddressScopePrefixConflict",
    "IllegalSubnetPoolAssociationToAddressScope",
    "IllegalSubnetPoolIpVersionAssociationToAddressScope",
    "IllegalSubnetPoolUpdate",
    "MinPrefixSubnetAllocationError",
    "MaxPrefixSubnetAllocationError",
    "SubnetPoolDeleteError",
    "SubnetPoolQuotaExceeded",
    "NetworkSubnetPoolAffinityError",
    "ObjectActionError",
    "CTZoneExhaustedError",
    "TenantQuotaNotFound",
    "MultipleFilterIDForIPFound",
    "FilterIDForIPNotFound",
    "FailedToAddQdiscToDevice",
    "PortBindingNotFound",
    "PortBindingAlreadyActive",
    "PortBindingAlreadyExists",
    "PortBindingError",
    "ProcessExecutionError",
    "InvalidSubnetServiceType",
    "InvalidInputSubnetServiceType",
    "MaxVRIDAllocationTriesReached",
    "NoVRIDAvailable",
    "HANetworkConcurrentDeletion",
    "HANetworkCIDRNotValid",
    "HAMaximumAgentsNumberNotValid",
    "RouterNotFound",
    "RouterInUse",
    "RouterInterfaceNotFound",
    "RouterInterfaceNotFoundForSubnet",
    "RouterInterfaceInUseByFloatingIP",
    "FloatingIPNotFound",
    "ExternalGatewayForFloatingIPNotFound",
    "FloatingIPPortAlreadyAssociated",
    "RouterExternalGatewayInUseByFloatingIp",
    "RouterInterfaceAttachmentConflict",
    "RouterNotCompatibleWithAgent",
    "RouterNotFoundInRouterFactory",
    "FloatingIpSetupException",
    "AbortSyncRouters",
    "IpTablesApplyException",
    "MeteringLabelNotFound",
    "DuplicateMeteringRuleInPost",
    "MeteringLabelRuleNotFound",
    "MeteringLabelRuleOverlaps",
    "SegmentsSetInConjunctionWithProviders",
    "SegmentsContainDuplicateEntry",
    "NetworkSegmentRangeNetTypeNotSupported",
    "NetworkSegmentRangeNotFound",
    "NetworkSegmentRangeReferencedByProject",
    "NetworkSegmentRangeDefaultReadOnly",
    "NetworkSegmentRangeOverlaps",
    "PlacementEndpointNotFound",
    "PlacementResourceNotFound",
    "PlacementResourceProviderNotFound",
    "PlacementResourceProviderGenerationConflict",
    "PlacementInventoryNotFound",
    "PlacementInventoryUpdateConflict",
    "PlacementAggregateNotFound",
    "PlacementTraitNotFound",
    "PlacementResourceClassNotFound",
    "PlacementAPIVersionIncorrect",
    "PlacementResourceProviderNameNotUnique",
    "PlacementClientError",
    "UnknownResourceProvider",
    "AmbiguousResponsibilityForResourceProvider",
    "PlacementAllocationGenerationConflict",
    "PlacementAllocationRemoved",
    "PlacementAllocationRpNotExists",
    "PortSecurityPortHasSecurityGroup",
    "PortSecurityAndIPRequiredForSecurityGroups",
    "QosPolicyNotFound",
    "QosRuleNotFound",
    "QoSPolicyDefaultAlreadyExists",
    "PortQosBindingNotFound",
    "PortQosBindingError",
    "NetworkQosBindingNotFound",
    "FloatingIPQosBindingNotFound",
    "QosPolicyInUse",
    "FloatingIPQosBindingError",
    "NetworkQosBindingError",
    "QosRuleNotSupported",
    "QoSRuleParameterConflict",
    "QoSRulesConflict",
    "PolicyRemoveAuthorizationError",
    "TcLibQdiscTypeError",
    "TcLibQdiscNeededArguments",
    "RouterQosBindingNotFound",
    "RouterQosBindingError",
    "QosPlacementAllocationConflict",
    "VlanTransparencyDriverError",
    "VPNServiceNotFound",
    "IPsecSiteConnectionNotFound",
    "IPsecSiteConnectionDpdIntervalValueError",
    "IPsecSiteConnectionMtuError",
    "IPsecSiteConnectionPeerCidrError",
    "IKEPolicyNotFound",
    "IPsecPolicyNotFound",
    "IKEPolicyInUse",
    "VPNServiceInUse",
    "SubnetInUseByVPNService",
    "SubnetInUseByEndpointGroup",
    "SubnetInUseByIPsecSiteConnection",
    "VPNStateInvalidToUpdate",
    "IPsecPolicyInUse",
    "DeviceDriverImportError",
    "SubnetIsNotConnectedToRouter",
    "RouterIsNotExternal",
    "VPNPeerAddressNotResolved",
    "ExternalNetworkHasNoSubnet",
    "VPNEndpointGroupNotFound",
    "InvalidEndpointInEndpointGroup",
    "MissingEndpointForEndpointGroup",
    "NonExistingSubnetInEndpointGroup",
    "MixedIPVersionsForIPSecEndpoints",
    "MixedIPVersionsForPeerCidrs",
    "MixedIPVersionsForIPSecConnection",
    "InvalidEndpointGroup",
    "WrongEndpointGroupType",
    "PeerCidrsInvalid",
    "MissingPeerCidrs",
    "MissingRequiredEndpointGroup",
    "EndpointGroupInUse",
    "FlavorsPluginNotLoaded",
    "NoProviderFoundForFlavor",
    "IpsecValidationFailure",
    "IkeValidationFailure",
    "CsrInternalError",
    "CsrValidationFailure",
]

# sed -rn 's/^class\s+(\S+)\(.+/    "\1",/p' ./neutronclient/common/exceptions.py
_NEUTRONCLIENT_EXCEPTIONS = [
    "NeutronException",
    "NeutronClientException",
    "BadRequest",
    "Unauthorized",
    "Forbidden",
    "NotFound",
    "Conflict",
    "InternalServerError",
    "ServiceUnavailable",
    "NetworkNotFoundClient",
    "PortNotFoundClient",
    "StateInvalidClient",
    "NetworkInUseClient",
    "PortInUseClient",
    "IpAddressInUseClient",
    "IpAddressAlreadyAllocatedClient",
    "InvalidIpForNetworkClient",
    "InvalidIpForSubnetClient",
    "OverQuotaClient",
    "IpAddressGenerationFailureClient",
    "MacAddressInUseClient",
    "HostNotCompatibleWithFixedIpsClient",
    "ExternalIpAddressExhaustedClient",
    "NoAuthURLProvided",
    "EndpointNotFound",
    "EndpointTypeNotFound",
    "AmbiguousEndpoints",
    "RequestURITooLong",
    "ConnectionFailed",
    "SslCertificateValidationError",
    "MalformedResponseBody",
    "InvalidContentType",
    "NeutronCLIError",
    "CommandError",
    "UnsupportedVersion",
    "NeutronClientNoUniqueMatch",
]
NEUTRONCLIENT_EXCEPTIONS = ["neutronclient.common.exceptions.{}".format(exc)
                            for exc in _NEUTRONCLIENT_EXCEPTIONS]

# Including this as a dep of (at least) Neutron
# sed -rn 's/^class\s+(\S+)\(.+/    "\1",/p' ovsdbapp/exceptions.py
OVSDBAPP_EXCEPTIONS = [
    "OvsdbAppException",
    "TimeoutException",
    "OvsdbConnectionUnavailable",
]

# sed -rn 's/^class\s+(\S+)\(.+/    "\1",/p' masakari/exception.py
MASAKARI_EXCEPTIONS = [
    "ConvertedException",
    "MasakariException",
    "APIException",
    "APITimeout",
    "Conflict",
    "Invalid",
    "InvalidName",
    "InvalidInput",
    "InvalidAPIVersionString",
    "MalformedRequestBody",
    "NotFound",
    "ConfigNotFound",
    "Forbidden",
    "AdminRequired",
    "PolicyNotAuthorized",
    "PasteAppNotFound",
    "InvalidContentType",
    "VersionNotFoundForAPIMethod",
    "InvalidGlobalAPIVersion",
    "ApiVersionsIntersect",
    "ValidationError",
    "InvalidSortKey",
    "MarkerNotFound",
    "FailoverSegmentNotFound",
    "HostNotFound",
    "NotificationNotFound",
    "FailoverSegmentNotFoundByName",
    "HostNotFoundByName",
    "ComputeNotFoundByName",
    "FailoverSegmentExists",
    "HostExists",
    "Unauthorized",
    "ObjectActionError",
    "OrphanedObjectError",
    "DuplicateNotification",
    "HostOnMaintenanceError",
    "HostRecoveryFailureException",
    "InstanceRecoveryFailureException",
    "SkipInstanceRecoveryException",
    "SkipProcessRecoveryException",
    "SkipHostRecoveryException",
    "ProcessRecoveryFailureException",
    "DBNotAllowed",
    "FailoverSegmentInUse",
    "HostInUse",
    "ReservedHostsUnavailable",
    "LockAlreadyAcquired",
    "IgnoreInstanceRecoveryException",
    "HostNotFoundUnderFailoverSegment",
    "InstanceEvacuateFailed",
    "FailoverSegmentDisabled",
]

# sed -rn 's/^class\s+(\S+)\(.+/    "\1",/p' designate/exceptions.py
DESIGNATE_EXCEPTIONS = [
    "DesignateException",
    "Backend",
    "RelationNotLoaded",
    "AdapterNotFound",
    "NSD4SlaveBackendError",
    "NotImplemented",
    "XFRFailure",
    "ConfigurationError",
    "UnknownFailure",
    "CommunicationFailure",
    "KeystoneCommunicationFailure",
    "NeutronCommunicationFailure",
    "NoFiltersConfigured",
    "NoServersConfigured",
    "MultiplePoolsFound",
    "NoPoolTargetsConfigured",
    "OverQuota",
    "QuotaResourceUnknown",
    "InvalidObject",
    "BadAction",
    "BadRequest",
    "EmptyRequestBody",
    "InvalidProject",
    "InvalidUUID",
    "NetworkEndpointNotFound",
    "MarkerNotFound",
    "ValueError",
    "InvalidMarker",
    "InvalidSortDir",
    "InvalidLimit",
    "InvalidSortKey",
    "InvalidJson",
    "InvalidOperation",
    "UnsupportedAccept",
    "UnsupportedContentType",
    "InvalidZoneName",
    "InvalidRecordSetName",
    "InvalidRecordSetLocation",
    "InvaildZoneTransfer",
    "InvalidTTL",
    "ZoneHasSubZone",
    "Forbidden",
    "IllegalChildZone",
    "IllegalParentZone",
    "IncorrectZoneTransferKey",
    "InvalidTokenScope",
    "Duplicate",
    "DuplicateServiceStatus",
    "DuplicateQuota",
    "DuplicateServer",
    "DuplicateTsigKey",
    "DuplicateZone",
    "DuplicateTld",
    "DuplicateRecordSet",
    "DuplicateRecord",
    "DuplicateBlacklist",
    "DuplicatePool",
    "DuplicatePoolAttribute",
    "DuplicatePoolNsRecord",
    "DuplicatePoolNameserver",
    "DuplicatePoolTarget",
    "DuplicatePoolTargetOption",
    "DuplicatePoolTargetMaster",
    "DuplicatePoolAlsoNotify",
    "DuplicateZoneImport",
    "DuplicateZoneExport",
    "MethodNotAllowed",
    "DuplicateZoneTransferRequest",
    "DuplicateZoneTransferAccept",
    "DuplicateZoneAttribute",
    "DuplicateZoneMaster",
    "NotFound",
    "ServiceStatusNotFound",
    "QuotaNotFound",
    "ServerNotFound",
    "TsigKeyNotFound",
    "BlacklistNotFound",
    "ZoneNotFound",
    "ZoneMasterNotFound",
    "ZoneAttributeNotFound",
    "TldNotFound",
    "RecordSetNotFound",
    "RecordNotFound",
    "ReportNotFound",
    "PoolNotFound",
    "NoValidPoolFound",
    "PoolAttributeNotFound",
    "PoolNsRecordNotFound",
    "PoolNameserverNotFound",
    "PoolTargetNotFound",
    "PoolTargetOptionNotFound",
    "PoolTargetMasterNotFound",
    "PoolAlsoNotifyNotFound",
    "ZoneTransferRequestNotFound",
    "ZoneTransferAcceptNotFound",
    "ZoneImportNotFound",
    "ZoneExportNotFound",
    "LastServerDeleteNotAllowed",
    "ResourceNotFound",
    "MissingProjectID",
]

# sed -rn 's/^class\s+(\S+)\(.+/    "\1",/p'  ./heat/common/exception.py
HEAT_EXCEPTIONS = [
    "HeatException",
    "MissingCredentialError",
    "AuthorizationFailure",
    "NotAuthenticated",
    "Forbidden",
    "NotAuthorized",
    "Invalid",
    "UserParameterMissing",
    "UnknownUserParameter",
    "InvalidTemplateVersion",
    "InvalidTemplateSection",
    "ImmutableParameterModified",
    "InvalidMergeStrategyForParam",
    "ConflictingMergeStrategyForParam",
    "InvalidTemplateAttribute",
    "InvalidTemplateReference",
    "TemplateOutputError",
    "InvalidEncryptionKey",
    "InvalidExternalResourceDependency",
    "EntityNotFound",
    "PhysicalResourceExists",
    "PhysicalResourceNameAmbiguity",
    "PhysicalResourceIDAmbiguity",
    "InvalidTenant",
    "StackExists",
    "HeatExceptionWithPath",
    "StackValidationFailed",
    "InvalidSchemaError",
    "ResourceNotFound",
    "SnapshotNotFound",
    "InvalidGlobalResource",
    "ResourceTypeUnavailable",
    "InvalidBreakPointHook",
    "InvalidRestrictedAction",
    "ResourceNotAvailable",
    "ClientNotAvailable",
    "ResourceFailure",
    "NotSupported",
    "ResourceActionNotSupported",
    "ResourceActionRestricted",
    "ResourcePropertyConflict",
    "ResourcePropertyDependency",
    "ResourcePropertyValueDependency",
    "PropertyUnspecifiedError",
    "UpdateReplace",
    "ResourceUnknownStatus",
    "ResourceInError",
    "UpdateInProgress",
    "HTTPExceptionDisguise",
    "EgressRuleNotAllowed",
    "Error",
    "NotFound",
    "InvalidContentType",
    "RequestLimitExceeded",
    "DownloadLimitExceeded",
    "StackResourceLimitExceeded",
    "ActionInProgress",
    "ActionNotComplete",
    "StopActionFailed",
    "EventSendFailed",
    "InterfaceAttachFailed",
    "InterfaceDetachFailed",
    "UnsupportedObjectError",
    "OrphanedObjectError",
    "IncompatibleObjectVersion",
    "ObjectActionError",
    "ReadOnlyFieldError",
    "ConcurrentTransaction",
    "ObjectFieldInvalid",
    "KeystoneServiceNameConflict",
    "SIGHUPInterrupt",
    "InvalidServiceVersion",
    "InvalidTemplateVersions",
    "UnableToAutoAllocateNetwork",
]

# sed -rn 's/^class\s+(\S+)\(.+/    "\1",/p'  ./os_vif/exception.py
# sed -rn 's/^class\s+(\S+)\(.+/    "\1",/p'  ./vif_plug_ovs/exception.py
_OS_VIF_EXCEPTIONS = [
    "ExceptionBase",
    "LibraryNotInitialized",
    "NoMatchingPlugin",
    "NoMatchingPortProfileClass",
    "NoSupportedPortProfileVersion",
    "NoMatchingVIFClass",
    "NoSupportedVIFVersion",
    "PlugException",
    "UnplugException",
    "NetworkMissingPhysicalNetwork",
    "NetworkInterfaceNotFound",
    "NetworkInterfaceTypeNotDefined",
    "ExternalImport",
    "NotImplementedForOS",
    "AgentError",
    "MissingPortProfile",
    "WrongPortProfile",
    "RepresentorNotFound",
    "PciDeviceNotFoundById",
]
OS_VIF_EXCEPTIONS = ["os_vif.exception.{}".format(exc)
                     for exc in _OS_VIF_EXCEPTIONS]

# Exceptions common to any project should be defined here
EXCEPTIONS_COMMON = [
    r'AMQP server on .+ is unreachable',
    r'amqp.exceptions.ConnectionForced',
    r'OSError: Server unexpectedly closed connection',
] + OSLO_DB_EXCEPTIONS \
  + OSLO_MESSAGING_EXCEPTIONS \
  + PYTHON_BUILTIN_EXCEPTIONS
