

# Sage: The Unified C/C++ Orchestrator

![Sage Logo](https://raw.githubusercontent.com/viuvlabs/sage/main/docs/logo.png)
---

**Sage by [viuvlabs](https://github.com/viuvlabs) is the intelligent project and package manager that acts as the "missing piece" for modern C/C++ development. It elegantly unifies and orchestrates essential tools like CMake, Conan, Clang, and Ninja, bringing clarity, consistency, and control to your entire C/C++ workflow.**

---

## ✨ Why Sage?

Developing in C/C++ can often feel like assembling a complex puzzle, with disparate tools, dependencies, and build systems. Sage steps in to provide the much-needed cohesion, guiding your projects from conception to compilation with wisdom and precision.

* **Unified Workflow:** Say goodbye to juggling multiple command-line interfaces and configurations. Sage provides a single, intuitive entry point for all your C/C++ project needs.
* **Intelligent Orchestration:** Seamlessly integrates and manages industry-leading tools:
    * **CMake:** For robust and cross-platform build system generation.
    * **Conan:** For efficient C/C++ dependency management and package consumption.
    * **Clang:** For modern, fast, and feature-rich compilation.
    * **Ninja:** For lightning-fast build execution.
* **"The Missing Piece":** Designed to fill the gaps in the C/C++ ecosystem, Sage ensures your projects are structured, dependencies are resolved, and builds are consistent, regardless of complexity or platform.
* **Boost Productivity:** Reduce boilerplate, automate repetitive tasks, and focus on writing great C/C++ code, not on battling build systems.
* **Scalable & Maintainable:** Facilitates the creation of projects that are easier to manage, scale, and onboard new developers to.

## 🚀 Getting Started

Getting started with Sage is designed to be straightforward.

### Installation

You can install Sage via pip:

```bash
pip install cppsage
sage about
````

### Quick Start

Coming Soon ..

## 📋 Features

Sage aims to provide a comprehensive set of features for modern C/C++ development:

  * **Project Definition:** Intuitive definition of project structure, targets (executables, libraries), and configurations.
  * **Dependency Management:** Seamless integration with Conan for declarative dependency resolution and consumption.
  * **Build System Generation:** Automated generation of CMake build scripts.
  * **Toolchain Integration:** Easy configuration and management of compilers (Clang), build tools (Ninja), and other development utilities.
  * **Testing & Linting:** Integrated commands for running tests and enforcing code style (e.g., clang-format, clang-tidy).
  * **Platform Agnostic:** Designed to work across various operating systems (Linux, macOS, Windows).
  * **Extensible:** Built with extensibility in mind, allowing for custom commands and integrations.

## 📚 Documentation

For more in-depth information, detailed usage guides, and advanced configurations, please refer to our official documentation:

[https://docs.viuvlabs.com/sage](https://www.google.com/search?q=https://docs.viuvlabs.com/sage)

## 🛠️ Project Structure

The `viuvlabs/sage` repository contains:

```
.
├── .vscode/             # VSCode workspace settings and configurations
├── cmake/               # Sage's internal CMake modules
├── packages/            # requirement.txt 
├── res/                 # Resources for Sage itself (e.g., templates)
├── sage/                # Sage's core source code
├── .clang-format        # Code formatting rules for C/C++ source
├── .clang-tidy          # Static analysis rules for C/C++ source
├── .clangd              # Configuration for Clangd (LSP server)
├── .editorconfig        # Universal code style settings
├── .gitignore           # Files and directories to ignore in Git
├── CMakeLists.txt       # CMake build script for Sage itself
├── CMakePresets.json    # CMake presets for Sage's own development
└── README.md            # This README file
```

## 🤝 Contributing

We welcome contributions to Sage\! Whether it's reporting a bug, suggesting a feature, or submitting a pull request, your help is invaluable.

Please refer to our [CONTRIBUTING.md](https://www.google.com/search?q=CONTRIBUTING.md) guide for detailed information on how to get involved.

## 🐞 Reporting Issues

Found a bug or have a feature request? Please open an issue on our [GitHub Issues page](https://www.google.com/search?q=https://github.com/viuvlabs/sage/issues).

## 📄 License

Sage is open-source software licensed under the [MIT License](https://www.google.com/search?q=LICENSE).

-----

## 📞 Contact

For questions, support, or general inquiries, please reach out to us:
  * **GitHub Issues:** [https://github.com/viuvlabs/sage/issues](https://www.google.com/search?q=https://github.com/viuvlabs/sage/issues)

-----

Made with ❤️ by the team at [viuvlabs](https://www.google.com/url?sa=E&source=gmail&q=https://github.com/viuvlabs).

```
```
