# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.checkout_callback import CheckoutCallback
from ..types.create_subscription_checkout_session_response import CreateSubscriptionCheckoutSessionResponse
from .raw_client import AsyncRawCheckoutClient, RawCheckoutClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CheckoutClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCheckoutClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCheckoutClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCheckoutClient
        """
        return self._raw_client

    def create_subscription_checkout_session(
        self,
        *,
        subject_id: str,
        rate_card_id: str,
        checkout_callback_urls: CheckoutCallback,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateSubscriptionCheckoutSessionResponse:
        """
        Parameters
        ----------
        subject_id : str
            The ID or external ID of the subject to create the checkout for.

        rate_card_id : str
            The ID of the rate card to subscribe to.

        checkout_callback_urls : CheckoutCallback
            The URLs to redirect to after the checkout is completed or cancelled.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateSubscriptionCheckoutSessionResponse
            Successful Response

        Examples
        --------
        from lark import CheckoutCallback, Lark

        client = Lark(
            api_key="YOUR_API_KEY",
        )
        client.checkout.create_subscription_checkout_session(
            subject_id="subj_VyX6Q96h5avMho8O7QWlKeXE",
            rate_card_id="rc_AJWMxR81jxoRlli6p13uf3JB",
            checkout_callback_urls=CheckoutCallback(
                cancelled_url="https://example.com/callback",
                success_url="https://example.com/callback",
            ),
        )
        """
        _response = self._raw_client.create_subscription_checkout_session(
            subject_id=subject_id,
            rate_card_id=rate_card_id,
            checkout_callback_urls=checkout_callback_urls,
            request_options=request_options,
        )
        return _response.data


class AsyncCheckoutClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCheckoutClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCheckoutClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCheckoutClient
        """
        return self._raw_client

    async def create_subscription_checkout_session(
        self,
        *,
        subject_id: str,
        rate_card_id: str,
        checkout_callback_urls: CheckoutCallback,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateSubscriptionCheckoutSessionResponse:
        """
        Parameters
        ----------
        subject_id : str
            The ID or external ID of the subject to create the checkout for.

        rate_card_id : str
            The ID of the rate card to subscribe to.

        checkout_callback_urls : CheckoutCallback
            The URLs to redirect to after the checkout is completed or cancelled.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateSubscriptionCheckoutSessionResponse
            Successful Response

        Examples
        --------
        import asyncio

        from lark import AsyncLark, CheckoutCallback

        client = AsyncLark(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.checkout.create_subscription_checkout_session(
                subject_id="subj_VyX6Q96h5avMho8O7QWlKeXE",
                rate_card_id="rc_AJWMxR81jxoRlli6p13uf3JB",
                checkout_callback_urls=CheckoutCallback(
                    cancelled_url="https://example.com/callback",
                    success_url="https://example.com/callback",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_subscription_checkout_session(
            subject_id=subject_id,
            rate_card_id=rate_card_id,
            checkout_callback_urls=checkout_callback_urls,
            request_options=request_options,
        )
        return _response.data
