# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.checkout_callback import CheckoutCallback
from ..types.create_subscription_checkout_session_response import CreateSubscriptionCheckoutSessionResponse
from ..types.http_validation_error import HttpValidationError

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawCheckoutClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create_subscription_checkout_session(
        self,
        *,
        subject_id: str,
        rate_card_id: str,
        checkout_callback_urls: CheckoutCallback,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[CreateSubscriptionCheckoutSessionResponse]:
        """
        Parameters
        ----------
        subject_id : str
            The ID or external ID of the subject to create the checkout for.

        rate_card_id : str
            The ID of the rate card to subscribe to.

        checkout_callback_urls : CheckoutCallback
            The URLs to redirect to after the checkout is completed or cancelled.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CreateSubscriptionCheckoutSessionResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "checkout",
            method="POST",
            json={
                "subject_id": subject_id,
                "rate_card_id": rate_card_id,
                "checkout_callback_urls": convert_and_respect_annotation_metadata(
                    object_=checkout_callback_urls, annotation=CheckoutCallback, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateSubscriptionCheckoutSessionResponse,
                    parse_obj_as(
                        type_=CreateSubscriptionCheckoutSessionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawCheckoutClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create_subscription_checkout_session(
        self,
        *,
        subject_id: str,
        rate_card_id: str,
        checkout_callback_urls: CheckoutCallback,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[CreateSubscriptionCheckoutSessionResponse]:
        """
        Parameters
        ----------
        subject_id : str
            The ID or external ID of the subject to create the checkout for.

        rate_card_id : str
            The ID of the rate card to subscribe to.

        checkout_callback_urls : CheckoutCallback
            The URLs to redirect to after the checkout is completed or cancelled.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CreateSubscriptionCheckoutSessionResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "checkout",
            method="POST",
            json={
                "subject_id": subject_id,
                "rate_card_id": rate_card_id,
                "checkout_callback_urls": convert_and_respect_annotation_metadata(
                    object_=checkout_callback_urls, annotation=CheckoutCallback, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateSubscriptionCheckoutSessionResponse,
                    parse_obj_as(
                        type_=CreateSubscriptionCheckoutSessionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
