# This file was auto-generated by Fern from our API Definition.

from __future__ import annotations

import typing

import httpx
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .environment import LarkEnvironment

if typing.TYPE_CHECKING:
    from .checkout.client import AsyncCheckoutClient, CheckoutClient
    from .customer_access.client import AsyncCustomerAccessClient, CustomerAccessClient
    from .customer_portal.client import AsyncCustomerPortalClient, CustomerPortalClient
    from .invoices.client import AsyncInvoicesClient, InvoicesClient
    from .pricing_metrics.client import AsyncPricingMetricsClient, PricingMetricsClient
    from .rate_cards.client import AsyncRateCardsClient, RateCardsClient
    from .subjects.client import AsyncSubjectsClient, SubjectsClient
    from .subscriptions.client import AsyncSubscriptionsClient, SubscriptionsClient
    from .usage_events.client import AsyncUsageEventsClient, UsageEventsClient


class Lark:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : LarkEnvironment
        The environment to use for requests from the client. from .environment import LarkEnvironment



        Defaults to LarkEnvironment.DEFAULT



    api_key : str
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from lark import Lark

    client = Lark(
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: LarkEnvironment = LarkEnvironment.DEFAULT,
        api_key: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._checkout: typing.Optional[CheckoutClient] = None
        self._customer_portal: typing.Optional[CustomerPortalClient] = None
        self._rate_cards: typing.Optional[RateCardsClient] = None
        self._usage_events: typing.Optional[UsageEventsClient] = None
        self._subscriptions: typing.Optional[SubscriptionsClient] = None
        self._subjects: typing.Optional[SubjectsClient] = None
        self._pricing_metrics: typing.Optional[PricingMetricsClient] = None
        self._customer_access: typing.Optional[CustomerAccessClient] = None
        self._invoices: typing.Optional[InvoicesClient] = None

    @property
    def checkout(self):
        if self._checkout is None:
            from .checkout.client import CheckoutClient  # noqa: E402

            self._checkout = CheckoutClient(client_wrapper=self._client_wrapper)
        return self._checkout

    @property
    def customer_portal(self):
        if self._customer_portal is None:
            from .customer_portal.client import CustomerPortalClient  # noqa: E402

            self._customer_portal = CustomerPortalClient(client_wrapper=self._client_wrapper)
        return self._customer_portal

    @property
    def rate_cards(self):
        if self._rate_cards is None:
            from .rate_cards.client import RateCardsClient  # noqa: E402

            self._rate_cards = RateCardsClient(client_wrapper=self._client_wrapper)
        return self._rate_cards

    @property
    def usage_events(self):
        if self._usage_events is None:
            from .usage_events.client import UsageEventsClient  # noqa: E402

            self._usage_events = UsageEventsClient(client_wrapper=self._client_wrapper)
        return self._usage_events

    @property
    def subscriptions(self):
        if self._subscriptions is None:
            from .subscriptions.client import SubscriptionsClient  # noqa: E402

            self._subscriptions = SubscriptionsClient(client_wrapper=self._client_wrapper)
        return self._subscriptions

    @property
    def subjects(self):
        if self._subjects is None:
            from .subjects.client import SubjectsClient  # noqa: E402

            self._subjects = SubjectsClient(client_wrapper=self._client_wrapper)
        return self._subjects

    @property
    def pricing_metrics(self):
        if self._pricing_metrics is None:
            from .pricing_metrics.client import PricingMetricsClient  # noqa: E402

            self._pricing_metrics = PricingMetricsClient(client_wrapper=self._client_wrapper)
        return self._pricing_metrics

    @property
    def customer_access(self):
        if self._customer_access is None:
            from .customer_access.client import CustomerAccessClient  # noqa: E402

            self._customer_access = CustomerAccessClient(client_wrapper=self._client_wrapper)
        return self._customer_access

    @property
    def invoices(self):
        if self._invoices is None:
            from .invoices.client import InvoicesClient  # noqa: E402

            self._invoices = InvoicesClient(client_wrapper=self._client_wrapper)
        return self._invoices


class AsyncLark:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : LarkEnvironment
        The environment to use for requests from the client. from .environment import LarkEnvironment



        Defaults to LarkEnvironment.DEFAULT



    api_key : str
    headers : typing.Optional[typing.Dict[str, str]]
        Additional headers to send with every request.

    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from lark import AsyncLark

    client = AsyncLark(
        api_key="YOUR_API_KEY",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: LarkEnvironment = LarkEnvironment.DEFAULT,
        api_key: str,
        headers: typing.Optional[typing.Dict[str, str]] = None,
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            api_key=api_key,
            headers=headers,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self._checkout: typing.Optional[AsyncCheckoutClient] = None
        self._customer_portal: typing.Optional[AsyncCustomerPortalClient] = None
        self._rate_cards: typing.Optional[AsyncRateCardsClient] = None
        self._usage_events: typing.Optional[AsyncUsageEventsClient] = None
        self._subscriptions: typing.Optional[AsyncSubscriptionsClient] = None
        self._subjects: typing.Optional[AsyncSubjectsClient] = None
        self._pricing_metrics: typing.Optional[AsyncPricingMetricsClient] = None
        self._customer_access: typing.Optional[AsyncCustomerAccessClient] = None
        self._invoices: typing.Optional[AsyncInvoicesClient] = None

    @property
    def checkout(self):
        if self._checkout is None:
            from .checkout.client import AsyncCheckoutClient  # noqa: E402

            self._checkout = AsyncCheckoutClient(client_wrapper=self._client_wrapper)
        return self._checkout

    @property
    def customer_portal(self):
        if self._customer_portal is None:
            from .customer_portal.client import AsyncCustomerPortalClient  # noqa: E402

            self._customer_portal = AsyncCustomerPortalClient(client_wrapper=self._client_wrapper)
        return self._customer_portal

    @property
    def rate_cards(self):
        if self._rate_cards is None:
            from .rate_cards.client import AsyncRateCardsClient  # noqa: E402

            self._rate_cards = AsyncRateCardsClient(client_wrapper=self._client_wrapper)
        return self._rate_cards

    @property
    def usage_events(self):
        if self._usage_events is None:
            from .usage_events.client import AsyncUsageEventsClient  # noqa: E402

            self._usage_events = AsyncUsageEventsClient(client_wrapper=self._client_wrapper)
        return self._usage_events

    @property
    def subscriptions(self):
        if self._subscriptions is None:
            from .subscriptions.client import AsyncSubscriptionsClient  # noqa: E402

            self._subscriptions = AsyncSubscriptionsClient(client_wrapper=self._client_wrapper)
        return self._subscriptions

    @property
    def subjects(self):
        if self._subjects is None:
            from .subjects.client import AsyncSubjectsClient  # noqa: E402

            self._subjects = AsyncSubjectsClient(client_wrapper=self._client_wrapper)
        return self._subjects

    @property
    def pricing_metrics(self):
        if self._pricing_metrics is None:
            from .pricing_metrics.client import AsyncPricingMetricsClient  # noqa: E402

            self._pricing_metrics = AsyncPricingMetricsClient(client_wrapper=self._client_wrapper)
        return self._pricing_metrics

    @property
    def customer_access(self):
        if self._customer_access is None:
            from .customer_access.client import AsyncCustomerAccessClient  # noqa: E402

            self._customer_access = AsyncCustomerAccessClient(client_wrapper=self._client_wrapper)
        return self._customer_access

    @property
    def invoices(self):
        if self._invoices is None:
            from .invoices.client import AsyncInvoicesClient  # noqa: E402

            self._invoices = AsyncInvoicesClient(client_wrapper=self._client_wrapper)
        return self._invoices


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: LarkEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
