# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.billing_state_response import BillingStateResponse
from .raw_client import AsyncRawCustomerAccessClient, RawCustomerAccessClient


class CustomerAccessClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCustomerAccessClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCustomerAccessClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCustomerAccessClient
        """
        return self._raw_client

    def get_billing_state(
        self, subject_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> BillingStateResponse:
        """
        Parameters
        ----------
        subject_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BillingStateResponse
            Successful Response

        Examples
        --------
        from lark import Lark

        client = Lark(
            api_key="YOUR_API_KEY",
        )
        client.customer_access.get_billing_state(
            subject_id="subject_id",
        )
        """
        _response = self._raw_client.get_billing_state(subject_id, request_options=request_options)
        return _response.data


class AsyncCustomerAccessClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCustomerAccessClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCustomerAccessClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCustomerAccessClient
        """
        return self._raw_client

    async def get_billing_state(
        self, subject_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> BillingStateResponse:
        """
        Parameters
        ----------
        subject_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        BillingStateResponse
            Successful Response

        Examples
        --------
        import asyncio

        from lark import AsyncLark

        client = AsyncLark(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.customer_access.get_billing_state(
                subject_id="subject_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_billing_state(subject_id, request_options=request_options)
        return _response.data
