# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.create_customer_portal_session_response import CreateCustomerPortalSessionResponse
from .raw_client import AsyncRawCustomerPortalClient, RawCustomerPortalClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CustomerPortalClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCustomerPortalClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCustomerPortalClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCustomerPortalClient
        """
        return self._raw_client

    def create_customer_portal_session(
        self, *, subject_id: str, return_url: str, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateCustomerPortalSessionResponse:
        """
        Parameters
        ----------
        subject_id : str
            The ID or external ID of the subject to create the customer portal session for.

        return_url : str
            The URL to redirect customers to if they click the back button on the customer portal.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateCustomerPortalSessionResponse
            Successful Response

        Examples
        --------
        from lark import Lark

        client = Lark(
            api_key="YOUR_API_KEY",
        )
        client.customer_portal.create_customer_portal_session(
            subject_id="subj_VyX6Q96h5avMho8O7QWlKeXE",
            return_url="https://example.com/dashboard",
        )
        """
        _response = self._raw_client.create_customer_portal_session(
            subject_id=subject_id, return_url=return_url, request_options=request_options
        )
        return _response.data


class AsyncCustomerPortalClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCustomerPortalClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCustomerPortalClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCustomerPortalClient
        """
        return self._raw_client

    async def create_customer_portal_session(
        self, *, subject_id: str, return_url: str, request_options: typing.Optional[RequestOptions] = None
    ) -> CreateCustomerPortalSessionResponse:
        """
        Parameters
        ----------
        subject_id : str
            The ID or external ID of the subject to create the customer portal session for.

        return_url : str
            The URL to redirect customers to if they click the back button on the customer portal.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateCustomerPortalSessionResponse
            Successful Response

        Examples
        --------
        import asyncio

        from lark import AsyncLark

        client = AsyncLark(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.customer_portal.create_customer_portal_session(
                subject_id="subj_VyX6Q96h5avMho8O7QWlKeXE",
                return_url="https://example.com/dashboard",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_customer_portal_session(
            subject_id=subject_id, return_url=return_url, request_options=request_options
        )
        return _response.data
