# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.create_customer_portal_session_response import CreateCustomerPortalSessionResponse
from ..types.http_validation_error import HttpValidationError

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawCustomerPortalClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create_customer_portal_session(
        self, *, subject_id: str, return_url: str, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[CreateCustomerPortalSessionResponse]:
        """
        Parameters
        ----------
        subject_id : str
            The ID or external ID of the subject to create the customer portal session for.

        return_url : str
            The URL to redirect customers to if they click the back button on the customer portal.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[CreateCustomerPortalSessionResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "customer-portal/sessions",
            method="POST",
            json={
                "subject_id": subject_id,
                "return_url": return_url,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateCustomerPortalSessionResponse,
                    parse_obj_as(
                        type_=CreateCustomerPortalSessionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawCustomerPortalClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create_customer_portal_session(
        self, *, subject_id: str, return_url: str, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[CreateCustomerPortalSessionResponse]:
        """
        Parameters
        ----------
        subject_id : str
            The ID or external ID of the subject to create the customer portal session for.

        return_url : str
            The URL to redirect customers to if they click the back button on the customer portal.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[CreateCustomerPortalSessionResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "customer-portal/sessions",
            method="POST",
            json={
                "subject_id": subject_id,
                "return_url": return_url,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    CreateCustomerPortalSessionResponse,
                    parse_obj_as(
                        type_=CreateCustomerPortalSessionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
