# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.list_invoices_response import ListInvoicesResponse
from .raw_client import AsyncRawInvoicesClient, RawInvoicesClient


class InvoicesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawInvoicesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawInvoicesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawInvoicesClient
        """
        return self._raw_client

    def list_invoices(
        self,
        *,
        subject_id: str,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListInvoicesResponse:
        """
        Parameters
        ----------
        subject_id : str
            The ID or external ID of the subject to list invoices for.

        limit : typing.Optional[int]

        offset : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListInvoicesResponse
            Successful Response

        Examples
        --------
        from lark import Lark

        client = Lark(
            api_key="YOUR_API_KEY",
        )
        client.invoices.list_invoices(
            subject_id="subject_id",
            limit=1,
            offset=1,
        )
        """
        _response = self._raw_client.list_invoices(
            subject_id=subject_id, limit=limit, offset=offset, request_options=request_options
        )
        return _response.data


class AsyncInvoicesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawInvoicesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawInvoicesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawInvoicesClient
        """
        return self._raw_client

    async def list_invoices(
        self,
        *,
        subject_id: str,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListInvoicesResponse:
        """
        Parameters
        ----------
        subject_id : str
            The ID or external ID of the subject to list invoices for.

        limit : typing.Optional[int]

        offset : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListInvoicesResponse
            Successful Response

        Examples
        --------
        import asyncio

        from lark import AsyncLark

        client = AsyncLark(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.invoices.list_invoices(
                subject_id="subject_id",
                limit=1,
                offset=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_invoices(
            subject_id=subject_id, limit=limit, offset=offset, request_options=request_options
        )
        return _response.data
