# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.list_pricing_metrics_response import ListPricingMetricsResponse
from ..types.period import Period
from ..types.pricing_metric_resource import PricingMetricResource
from ..types.pricing_metric_summary_resource import PricingMetricSummaryResource
from .raw_client import AsyncRawPricingMetricsClient, RawPricingMetricsClient
from .types.pricing_metric_aggregation import PricingMetricAggregation

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PricingMetricsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPricingMetricsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPricingMetricsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPricingMetricsClient
        """
        return self._raw_client

    def list_pricing_metrics(
        self, *, limit: typing.Optional[int] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> ListPricingMetricsResponse:
        """
        Parameters
        ----------
        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListPricingMetricsResponse
            Successful Response

        Examples
        --------
        from lark import Lark

        client = Lark(
            api_key="YOUR_API_KEY",
        )
        client.pricing_metrics.list_pricing_metrics(
            limit=1,
        )
        """
        _response = self._raw_client.list_pricing_metrics(limit=limit, request_options=request_options)
        return _response.data

    def create_pricing_metric(
        self,
        *,
        name: str,
        event_name: str,
        aggregation: PricingMetricAggregation,
        unit: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PricingMetricResource:
        """
        Parameters
        ----------
        name : str
            The name of the pricing metric.

        event_name : str
            The name of the event that the pricing metric is computed on.

        aggregation : PricingMetricAggregation
            The aggregation function used to compute the value of the pricing metric.

        unit : str
            Unit of measurement for the pricing metric.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PricingMetricResource
            Successful Response

        Examples
        --------
        from lark import Lark
        from lark.pricing_metrics import PricingMetricAggregation_Sum

        client = Lark(
            api_key="YOUR_API_KEY",
        )
        client.pricing_metrics.create_pricing_metric(
            name="Compute Hours",
            event_name="job_completed",
            aggregation=PricingMetricAggregation_Sum(
                value_field="value_field",
            ),
            unit="hours",
        )
        """
        _response = self._raw_client.create_pricing_metric(
            name=name, event_name=event_name, aggregation=aggregation, unit=unit, request_options=request_options
        )
        return _response.data

    def get_pricing_metric(
        self, pricing_metric_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PricingMetricResource:
        """
        Parameters
        ----------
        pricing_metric_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PricingMetricResource
            Successful Response

        Examples
        --------
        from lark import Lark

        client = Lark(
            api_key="YOUR_API_KEY",
        )
        client.pricing_metrics.get_pricing_metric(
            pricing_metric_id="pricing_metric_id",
        )
        """
        _response = self._raw_client.get_pricing_metric(pricing_metric_id, request_options=request_options)
        return _response.data

    def create_pricing_metric_summary(
        self,
        pricing_metric_id: str,
        *,
        subject_id: str,
        period: Period,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PricingMetricSummaryResource:
        """
        Parameters
        ----------
        pricing_metric_id : str

        subject_id : str
            The ID or external ID of the subject that the summary should be computed for.

        period : Period
            The period that the summary should be computed over.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PricingMetricSummaryResource
            Successful Response

        Examples
        --------
        import datetime

        from lark import Lark, Period

        client = Lark(
            api_key="YOUR_API_KEY",
        )
        client.pricing_metrics.create_pricing_metric_summary(
            pricing_metric_id="pricing_metric_id",
            subject_id="subj_VyX6Q96h5avMho8O7QWlKeXE",
            period=Period(
                start=datetime.datetime.fromisoformat(
                    "2025-10-01 00:00:00+00:00",
                ),
                end=datetime.datetime.fromisoformat(
                    "2025-11-01 00:00:00+00:00",
                ),
            ),
        )
        """
        _response = self._raw_client.create_pricing_metric_summary(
            pricing_metric_id, subject_id=subject_id, period=period, request_options=request_options
        )
        return _response.data


class AsyncPricingMetricsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPricingMetricsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPricingMetricsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPricingMetricsClient
        """
        return self._raw_client

    async def list_pricing_metrics(
        self, *, limit: typing.Optional[int] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> ListPricingMetricsResponse:
        """
        Parameters
        ----------
        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListPricingMetricsResponse
            Successful Response

        Examples
        --------
        import asyncio

        from lark import AsyncLark

        client = AsyncLark(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pricing_metrics.list_pricing_metrics(
                limit=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_pricing_metrics(limit=limit, request_options=request_options)
        return _response.data

    async def create_pricing_metric(
        self,
        *,
        name: str,
        event_name: str,
        aggregation: PricingMetricAggregation,
        unit: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PricingMetricResource:
        """
        Parameters
        ----------
        name : str
            The name of the pricing metric.

        event_name : str
            The name of the event that the pricing metric is computed on.

        aggregation : PricingMetricAggregation
            The aggregation function used to compute the value of the pricing metric.

        unit : str
            Unit of measurement for the pricing metric.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PricingMetricResource
            Successful Response

        Examples
        --------
        import asyncio

        from lark import AsyncLark
        from lark.pricing_metrics import PricingMetricAggregation_Sum

        client = AsyncLark(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pricing_metrics.create_pricing_metric(
                name="Compute Hours",
                event_name="job_completed",
                aggregation=PricingMetricAggregation_Sum(
                    value_field="value_field",
                ),
                unit="hours",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_pricing_metric(
            name=name, event_name=event_name, aggregation=aggregation, unit=unit, request_options=request_options
        )
        return _response.data

    async def get_pricing_metric(
        self, pricing_metric_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> PricingMetricResource:
        """
        Parameters
        ----------
        pricing_metric_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PricingMetricResource
            Successful Response

        Examples
        --------
        import asyncio

        from lark import AsyncLark

        client = AsyncLark(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pricing_metrics.get_pricing_metric(
                pricing_metric_id="pricing_metric_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_pricing_metric(pricing_metric_id, request_options=request_options)
        return _response.data

    async def create_pricing_metric_summary(
        self,
        pricing_metric_id: str,
        *,
        subject_id: str,
        period: Period,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PricingMetricSummaryResource:
        """
        Parameters
        ----------
        pricing_metric_id : str

        subject_id : str
            The ID or external ID of the subject that the summary should be computed for.

        period : Period
            The period that the summary should be computed over.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PricingMetricSummaryResource
            Successful Response

        Examples
        --------
        import asyncio
        import datetime

        from lark import AsyncLark, Period

        client = AsyncLark(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.pricing_metrics.create_pricing_metric_summary(
                pricing_metric_id="pricing_metric_id",
                subject_id="subj_VyX6Q96h5avMho8O7QWlKeXE",
                period=Period(
                    start=datetime.datetime.fromisoformat(
                        "2025-10-01 00:00:00+00:00",
                    ),
                    end=datetime.datetime.fromisoformat(
                        "2025-11-01 00:00:00+00:00",
                    ),
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_pricing_metric_summary(
            pricing_metric_id, subject_id=subject_id, period=period, request_options=request_options
        )
        return _response.data
