# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from ..types.list_pricing_metrics_response import ListPricingMetricsResponse
from ..types.period import Period
from ..types.pricing_metric_resource import PricingMetricResource
from ..types.pricing_metric_summary_resource import PricingMetricSummaryResource
from .types.pricing_metric_aggregation import PricingMetricAggregation

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawPricingMetricsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_pricing_metrics(
        self, *, limit: typing.Optional[int] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ListPricingMetricsResponse]:
        """
        Parameters
        ----------
        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ListPricingMetricsResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "pricing-metrics",
            method="GET",
            params={
                "limit": limit,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ListPricingMetricsResponse,
                    parse_obj_as(
                        type_=ListPricingMetricsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_pricing_metric(
        self,
        *,
        name: str,
        event_name: str,
        aggregation: PricingMetricAggregation,
        unit: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PricingMetricResource]:
        """
        Parameters
        ----------
        name : str
            The name of the pricing metric.

        event_name : str
            The name of the event that the pricing metric is computed on.

        aggregation : PricingMetricAggregation
            The aggregation function used to compute the value of the pricing metric.

        unit : str
            Unit of measurement for the pricing metric.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PricingMetricResource]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "pricing-metrics",
            method="POST",
            json={
                "name": name,
                "event_name": event_name,
                "aggregation": convert_and_respect_annotation_metadata(
                    object_=aggregation, annotation=PricingMetricAggregation, direction="write"
                ),
                "unit": unit,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PricingMetricResource,
                    parse_obj_as(
                        type_=PricingMetricResource,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_pricing_metric(
        self, pricing_metric_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[PricingMetricResource]:
        """
        Parameters
        ----------
        pricing_metric_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PricingMetricResource]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"pricing-metrics/{jsonable_encoder(pricing_metric_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PricingMetricResource,
                    parse_obj_as(
                        type_=PricingMetricResource,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_pricing_metric_summary(
        self,
        pricing_metric_id: str,
        *,
        subject_id: str,
        period: Period,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PricingMetricSummaryResource]:
        """
        Parameters
        ----------
        pricing_metric_id : str

        subject_id : str
            The ID or external ID of the subject that the summary should be computed for.

        period : Period
            The period that the summary should be computed over.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PricingMetricSummaryResource]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"pricing-metrics/{jsonable_encoder(pricing_metric_id)}/summary",
            method="POST",
            json={
                "subject_id": subject_id,
                "period": convert_and_respect_annotation_metadata(object_=period, annotation=Period, direction="write"),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PricingMetricSummaryResource,
                    parse_obj_as(
                        type_=PricingMetricSummaryResource,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawPricingMetricsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_pricing_metrics(
        self, *, limit: typing.Optional[int] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ListPricingMetricsResponse]:
        """
        Parameters
        ----------
        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ListPricingMetricsResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "pricing-metrics",
            method="GET",
            params={
                "limit": limit,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ListPricingMetricsResponse,
                    parse_obj_as(
                        type_=ListPricingMetricsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_pricing_metric(
        self,
        *,
        name: str,
        event_name: str,
        aggregation: PricingMetricAggregation,
        unit: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PricingMetricResource]:
        """
        Parameters
        ----------
        name : str
            The name of the pricing metric.

        event_name : str
            The name of the event that the pricing metric is computed on.

        aggregation : PricingMetricAggregation
            The aggregation function used to compute the value of the pricing metric.

        unit : str
            Unit of measurement for the pricing metric.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PricingMetricResource]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "pricing-metrics",
            method="POST",
            json={
                "name": name,
                "event_name": event_name,
                "aggregation": convert_and_respect_annotation_metadata(
                    object_=aggregation, annotation=PricingMetricAggregation, direction="write"
                ),
                "unit": unit,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PricingMetricResource,
                    parse_obj_as(
                        type_=PricingMetricResource,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_pricing_metric(
        self, pricing_metric_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[PricingMetricResource]:
        """
        Parameters
        ----------
        pricing_metric_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PricingMetricResource]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"pricing-metrics/{jsonable_encoder(pricing_metric_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PricingMetricResource,
                    parse_obj_as(
                        type_=PricingMetricResource,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_pricing_metric_summary(
        self,
        pricing_metric_id: str,
        *,
        subject_id: str,
        period: Period,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PricingMetricSummaryResource]:
        """
        Parameters
        ----------
        pricing_metric_id : str

        subject_id : str
            The ID or external ID of the subject that the summary should be computed for.

        period : Period
            The period that the summary should be computed over.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PricingMetricSummaryResource]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"pricing-metrics/{jsonable_encoder(pricing_metric_id)}/summary",
            method="POST",
            json={
                "subject_id": subject_id,
                "period": convert_and_respect_annotation_metadata(object_=period, annotation=Period, direction="write"),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PricingMetricSummaryResource,
                    parse_obj_as(
                        type_=PricingMetricSummaryResource,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
