# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.create_fixed_rate_request import CreateFixedRateRequest
from ..types.list_rate_cards_response import ListRateCardsResponse
from ..types.rate_card_resource import RateCardResource
from .raw_client import AsyncRawRateCardsClient, RawRateCardsClient
from .types.create_rate_card_request_billing_interval import CreateRateCardRequestBillingInterval
from .types.create_rate_card_request_usage_based_rates_item import CreateRateCardRequestUsageBasedRatesItem

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RateCardsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawRateCardsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawRateCardsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawRateCardsClient
        """
        return self._raw_client

    def list_rate_cards(
        self, *, limit: typing.Optional[int] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> ListRateCardsResponse:
        """
        Parameters
        ----------
        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListRateCardsResponse
            Successful Response

        Examples
        --------
        from lark import Lark

        client = Lark(
            api_key="YOUR_API_KEY",
        )
        client.rate_cards.list_rate_cards(
            limit=1,
        )
        """
        _response = self._raw_client.list_rate_cards(limit=limit, request_options=request_options)
        return _response.data

    def create_rate_card(
        self,
        *,
        name: str,
        billing_interval: CreateRateCardRequestBillingInterval,
        description: typing.Optional[str] = OMIT,
        fixed_rates: typing.Optional[typing.Sequence[CreateFixedRateRequest]] = OMIT,
        usage_based_rates: typing.Optional[typing.Sequence[CreateRateCardRequestUsageBasedRatesItem]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RateCardResource:
        """
        Parameters
        ----------
        name : str
            The name of the rate card displayed to the customer.

        billing_interval : CreateRateCardRequestBillingInterval
            How often the customer will be billed for this rate card.

        description : typing.Optional[str]
            The description of the rate card displayed to the customer.

        fixed_rates : typing.Optional[typing.Sequence[CreateFixedRateRequest]]
            The fixed rates of the rate card. These are billed at the start of each billing cycle.

        usage_based_rates : typing.Optional[typing.Sequence[CreateRateCardRequestUsageBasedRatesItem]]
            The usage based rates of the rate card. These are billed at the end of each billing cycle.

        metadata : typing.Optional[typing.Dict[str, str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RateCardResource
            Successful Response

        Examples
        --------
        from lark import Amount, CreateFixedRateRequest, Lark, Price_Flat
        from lark.rate_cards import CreateRateCardRequestUsageBasedRatesItem_Simple

        client = Lark(
            api_key="YOUR_API_KEY",
        )
        client.rate_cards.create_rate_card(
            name="Pro Plan",
            description="For production applications with moderate usage.",
            billing_interval="monthly",
            fixed_rates=[
                CreateFixedRateRequest(
                    name="Base Rate",
                    price=Price_Flat(
                        amount=Amount(
                            value="2500",
                            currency_code="usd",
                        ),
                    ),
                )
            ],
            usage_based_rates=[
                CreateRateCardRequestUsageBasedRatesItem_Simple(
                    name="name",
                    price=Price_Flat(
                        amount=Amount(
                            value="2500",
                            currency_code="usd",
                        ),
                    ),
                    pricing_metric_id="pricing_metric_id",
                )
            ],
            metadata={"key": "value"},
        )
        """
        _response = self._raw_client.create_rate_card(
            name=name,
            billing_interval=billing_interval,
            description=description,
            fixed_rates=fixed_rates,
            usage_based_rates=usage_based_rates,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    def get_rate_card(
        self, rate_card_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> RateCardResource:
        """
        Parameters
        ----------
        rate_card_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RateCardResource
            Successful Response

        Examples
        --------
        from lark import Lark

        client = Lark(
            api_key="YOUR_API_KEY",
        )
        client.rate_cards.get_rate_card(
            rate_card_id="rate_card_id",
        )
        """
        _response = self._raw_client.get_rate_card(rate_card_id, request_options=request_options)
        return _response.data


class AsyncRateCardsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawRateCardsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawRateCardsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawRateCardsClient
        """
        return self._raw_client

    async def list_rate_cards(
        self, *, limit: typing.Optional[int] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> ListRateCardsResponse:
        """
        Parameters
        ----------
        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListRateCardsResponse
            Successful Response

        Examples
        --------
        import asyncio

        from lark import AsyncLark

        client = AsyncLark(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.rate_cards.list_rate_cards(
                limit=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_rate_cards(limit=limit, request_options=request_options)
        return _response.data

    async def create_rate_card(
        self,
        *,
        name: str,
        billing_interval: CreateRateCardRequestBillingInterval,
        description: typing.Optional[str] = OMIT,
        fixed_rates: typing.Optional[typing.Sequence[CreateFixedRateRequest]] = OMIT,
        usage_based_rates: typing.Optional[typing.Sequence[CreateRateCardRequestUsageBasedRatesItem]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> RateCardResource:
        """
        Parameters
        ----------
        name : str
            The name of the rate card displayed to the customer.

        billing_interval : CreateRateCardRequestBillingInterval
            How often the customer will be billed for this rate card.

        description : typing.Optional[str]
            The description of the rate card displayed to the customer.

        fixed_rates : typing.Optional[typing.Sequence[CreateFixedRateRequest]]
            The fixed rates of the rate card. These are billed at the start of each billing cycle.

        usage_based_rates : typing.Optional[typing.Sequence[CreateRateCardRequestUsageBasedRatesItem]]
            The usage based rates of the rate card. These are billed at the end of each billing cycle.

        metadata : typing.Optional[typing.Dict[str, str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RateCardResource
            Successful Response

        Examples
        --------
        import asyncio

        from lark import Amount, AsyncLark, CreateFixedRateRequest, Price_Flat
        from lark.rate_cards import CreateRateCardRequestUsageBasedRatesItem_Simple

        client = AsyncLark(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.rate_cards.create_rate_card(
                name="Pro Plan",
                description="For production applications with moderate usage.",
                billing_interval="monthly",
                fixed_rates=[
                    CreateFixedRateRequest(
                        name="Base Rate",
                        price=Price_Flat(
                            amount=Amount(
                                value="2500",
                                currency_code="usd",
                            ),
                        ),
                    )
                ],
                usage_based_rates=[
                    CreateRateCardRequestUsageBasedRatesItem_Simple(
                        name="name",
                        price=Price_Flat(
                            amount=Amount(
                                value="2500",
                                currency_code="usd",
                            ),
                        ),
                        pricing_metric_id="pricing_metric_id",
                    )
                ],
                metadata={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_rate_card(
            name=name,
            billing_interval=billing_interval,
            description=description,
            fixed_rates=fixed_rates,
            usage_based_rates=usage_based_rates,
            metadata=metadata,
            request_options=request_options,
        )
        return _response.data

    async def get_rate_card(
        self, rate_card_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> RateCardResource:
        """
        Parameters
        ----------
        rate_card_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        RateCardResource
            Successful Response

        Examples
        --------
        import asyncio

        from lark import AsyncLark

        client = AsyncLark(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.rate_cards.get_rate_card(
                rate_card_id="rate_card_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_rate_card(rate_card_id, request_options=request_options)
        return _response.data
