# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.create_fixed_rate_request import CreateFixedRateRequest
from ..types.http_validation_error import HttpValidationError
from ..types.list_rate_cards_response import ListRateCardsResponse
from ..types.rate_card_resource import RateCardResource
from .types.create_rate_card_request_billing_interval import CreateRateCardRequestBillingInterval
from .types.create_rate_card_request_usage_based_rates_item import CreateRateCardRequestUsageBasedRatesItem

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawRateCardsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_rate_cards(
        self, *, limit: typing.Optional[int] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[ListRateCardsResponse]:
        """
        Parameters
        ----------
        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ListRateCardsResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "rate-cards",
            method="GET",
            params={
                "limit": limit,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ListRateCardsResponse,
                    parse_obj_as(
                        type_=ListRateCardsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_rate_card(
        self,
        *,
        name: str,
        billing_interval: CreateRateCardRequestBillingInterval,
        description: typing.Optional[str] = OMIT,
        fixed_rates: typing.Optional[typing.Sequence[CreateFixedRateRequest]] = OMIT,
        usage_based_rates: typing.Optional[typing.Sequence[CreateRateCardRequestUsageBasedRatesItem]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[RateCardResource]:
        """
        Parameters
        ----------
        name : str
            The name of the rate card displayed to the customer.

        billing_interval : CreateRateCardRequestBillingInterval
            How often the customer will be billed for this rate card.

        description : typing.Optional[str]
            The description of the rate card displayed to the customer.

        fixed_rates : typing.Optional[typing.Sequence[CreateFixedRateRequest]]
            The fixed rates of the rate card. These are billed at the start of each billing cycle.

        usage_based_rates : typing.Optional[typing.Sequence[CreateRateCardRequestUsageBasedRatesItem]]
            The usage based rates of the rate card. These are billed at the end of each billing cycle.

        metadata : typing.Optional[typing.Dict[str, str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[RateCardResource]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "rate-cards",
            method="POST",
            json={
                "name": name,
                "description": description,
                "billing_interval": billing_interval,
                "fixed_rates": convert_and_respect_annotation_metadata(
                    object_=fixed_rates, annotation=typing.Sequence[CreateFixedRateRequest], direction="write"
                ),
                "usage_based_rates": convert_and_respect_annotation_metadata(
                    object_=usage_based_rates,
                    annotation=typing.Sequence[CreateRateCardRequestUsageBasedRatesItem],
                    direction="write",
                ),
                "metadata": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    RateCardResource,
                    parse_obj_as(
                        type_=RateCardResource,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_rate_card(
        self, rate_card_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[RateCardResource]:
        """
        Parameters
        ----------
        rate_card_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[RateCardResource]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"rate-cards/{jsonable_encoder(rate_card_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    RateCardResource,
                    parse_obj_as(
                        type_=RateCardResource,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawRateCardsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_rate_cards(
        self, *, limit: typing.Optional[int] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[ListRateCardsResponse]:
        """
        Parameters
        ----------
        limit : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ListRateCardsResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "rate-cards",
            method="GET",
            params={
                "limit": limit,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ListRateCardsResponse,
                    parse_obj_as(
                        type_=ListRateCardsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_rate_card(
        self,
        *,
        name: str,
        billing_interval: CreateRateCardRequestBillingInterval,
        description: typing.Optional[str] = OMIT,
        fixed_rates: typing.Optional[typing.Sequence[CreateFixedRateRequest]] = OMIT,
        usage_based_rates: typing.Optional[typing.Sequence[CreateRateCardRequestUsageBasedRatesItem]] = OMIT,
        metadata: typing.Optional[typing.Dict[str, str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[RateCardResource]:
        """
        Parameters
        ----------
        name : str
            The name of the rate card displayed to the customer.

        billing_interval : CreateRateCardRequestBillingInterval
            How often the customer will be billed for this rate card.

        description : typing.Optional[str]
            The description of the rate card displayed to the customer.

        fixed_rates : typing.Optional[typing.Sequence[CreateFixedRateRequest]]
            The fixed rates of the rate card. These are billed at the start of each billing cycle.

        usage_based_rates : typing.Optional[typing.Sequence[CreateRateCardRequestUsageBasedRatesItem]]
            The usage based rates of the rate card. These are billed at the end of each billing cycle.

        metadata : typing.Optional[typing.Dict[str, str]]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[RateCardResource]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "rate-cards",
            method="POST",
            json={
                "name": name,
                "description": description,
                "billing_interval": billing_interval,
                "fixed_rates": convert_and_respect_annotation_metadata(
                    object_=fixed_rates, annotation=typing.Sequence[CreateFixedRateRequest], direction="write"
                ),
                "usage_based_rates": convert_and_respect_annotation_metadata(
                    object_=usage_based_rates,
                    annotation=typing.Sequence[CreateRateCardRequestUsageBasedRatesItem],
                    direction="write",
                ),
                "metadata": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    RateCardResource,
                    parse_obj_as(
                        type_=RateCardResource,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_rate_card(
        self, rate_card_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[RateCardResource]:
        """
        Parameters
        ----------
        rate_card_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[RateCardResource]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"rate-cards/{jsonable_encoder(rate_card_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    RateCardResource,
                    parse_obj_as(
                        type_=RateCardResource,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
