# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.create_subject_response import CreateSubjectResponse
from ..types.list_subjects_response import ListSubjectsResponse
from ..types.subject_resource import SubjectResource
from .raw_client import AsyncRawSubjectsClient, RawSubjectsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SubjectsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSubjectsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSubjectsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSubjectsClient
        """
        return self._raw_client

    def list_subjects(
        self,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListSubjectsResponse:
        """
        Parameters
        ----------
        limit : typing.Optional[int]

        offset : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListSubjectsResponse
            Successful Response

        Examples
        --------
        from lark import Lark

        client = Lark(
            api_key="YOUR_API_KEY",
        )
        client.subjects.list_subjects(
            limit=1,
            offset=1,
        )
        """
        _response = self._raw_client.list_subjects(limit=limit, offset=offset, request_options=request_options)
        return _response.data

    def create_subject(
        self,
        *,
        external_id: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        email: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateSubjectResponse:
        """
        Parameters
        ----------
        external_id : typing.Optional[str]
            The ID of the subject in your system. If provided, you may use pass it to the API in place of the subject ID. Must be unique.

        name : typing.Optional[str]
            The name of the subject. Used for display in the dashboard.

        email : typing.Optional[str]
            The email of the subject. Must be a valid email address.

        metadata : typing.Optional[typing.Dict[str, str]]
            Additional metadata about the subject. You may use this to store any custom data about the subject.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateSubjectResponse
            Successful Response

        Examples
        --------
        from lark import Lark

        client = Lark(
            api_key="YOUR_API_KEY",
        )
        client.subjects.create_subject(
            external_id="user_1234567890",
            name="John Doe",
            email="john.doe@example.com",
            metadata={"key": "value"},
        )
        """
        _response = self._raw_client.create_subject(
            external_id=external_id, name=name, email=email, metadata=metadata, request_options=request_options
        )
        return _response.data

    def get_subject(
        self, subject_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SubjectResource:
        """
        Parameters
        ----------
        subject_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SubjectResource
            Successful Response

        Examples
        --------
        from lark import Lark

        client = Lark(
            api_key="YOUR_API_KEY",
        )
        client.subjects.get_subject(
            subject_id="subject_id",
        )
        """
        _response = self._raw_client.get_subject(subject_id, request_options=request_options)
        return _response.data

    def update_subject(
        self,
        subject_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        email: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SubjectResource:
        """
        Parameters
        ----------
        subject_id : str

        name : typing.Optional[str]
            The name of the subject. Used for display in the dashboard.

        email : typing.Optional[str]
            The email of the subject. Must be a valid email address.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[str]]]
            Additional metadata about the subject. You may use this to store any custom data about the subject.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SubjectResource
            Successful Response

        Examples
        --------
        from lark import Lark

        client = Lark(
            api_key="YOUR_API_KEY",
        )
        client.subjects.update_subject(
            subject_id="subject_id",
        )
        """
        _response = self._raw_client.update_subject(
            subject_id, name=name, email=email, metadata=metadata, request_options=request_options
        )
        return _response.data

    def delete_subject(
        self, subject_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        subject_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        from lark import Lark

        client = Lark(
            api_key="YOUR_API_KEY",
        )
        client.subjects.delete_subject(
            subject_id="subject_id",
        )
        """
        _response = self._raw_client.delete_subject(subject_id, request_options=request_options)
        return _response.data


class AsyncSubjectsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSubjectsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSubjectsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSubjectsClient
        """
        return self._raw_client

    async def list_subjects(
        self,
        *,
        limit: typing.Optional[int] = None,
        offset: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListSubjectsResponse:
        """
        Parameters
        ----------
        limit : typing.Optional[int]

        offset : typing.Optional[int]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListSubjectsResponse
            Successful Response

        Examples
        --------
        import asyncio

        from lark import AsyncLark

        client = AsyncLark(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.subjects.list_subjects(
                limit=1,
                offset=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_subjects(limit=limit, offset=offset, request_options=request_options)
        return _response.data

    async def create_subject(
        self,
        *,
        external_id: typing.Optional[str] = OMIT,
        name: typing.Optional[str] = OMIT,
        email: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CreateSubjectResponse:
        """
        Parameters
        ----------
        external_id : typing.Optional[str]
            The ID of the subject in your system. If provided, you may use pass it to the API in place of the subject ID. Must be unique.

        name : typing.Optional[str]
            The name of the subject. Used for display in the dashboard.

        email : typing.Optional[str]
            The email of the subject. Must be a valid email address.

        metadata : typing.Optional[typing.Dict[str, str]]
            Additional metadata about the subject. You may use this to store any custom data about the subject.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CreateSubjectResponse
            Successful Response

        Examples
        --------
        import asyncio

        from lark import AsyncLark

        client = AsyncLark(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.subjects.create_subject(
                external_id="user_1234567890",
                name="John Doe",
                email="john.doe@example.com",
                metadata={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_subject(
            external_id=external_id, name=name, email=email, metadata=metadata, request_options=request_options
        )
        return _response.data

    async def get_subject(
        self, subject_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SubjectResource:
        """
        Parameters
        ----------
        subject_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SubjectResource
            Successful Response

        Examples
        --------
        import asyncio

        from lark import AsyncLark

        client = AsyncLark(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.subjects.get_subject(
                subject_id="subject_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_subject(subject_id, request_options=request_options)
        return _response.data

    async def update_subject(
        self,
        subject_id: str,
        *,
        name: typing.Optional[str] = OMIT,
        email: typing.Optional[str] = OMIT,
        metadata: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SubjectResource:
        """
        Parameters
        ----------
        subject_id : str

        name : typing.Optional[str]
            The name of the subject. Used for display in the dashboard.

        email : typing.Optional[str]
            The email of the subject. Must be a valid email address.

        metadata : typing.Optional[typing.Dict[str, typing.Optional[str]]]
            Additional metadata about the subject. You may use this to store any custom data about the subject.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SubjectResource
            Successful Response

        Examples
        --------
        import asyncio

        from lark import AsyncLark

        client = AsyncLark(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.subjects.update_subject(
                subject_id="subject_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_subject(
            subject_id, name=name, email=email, metadata=metadata, request_options=request_options
        )
        return _response.data

    async def delete_subject(
        self, subject_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        subject_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio

        from lark import AsyncLark

        client = AsyncLark(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.subjects.delete_subject(
                subject_id="subject_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_subject(subject_id, request_options=request_options)
        return _response.data
