# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.change_subscription_rate_card_response import ChangeSubscriptionRateCardResponse
from ..types.checkout_callback import CheckoutCallback
from ..types.list_subscriptions_response import ListSubscriptionsResponse
from ..types.subscription_resource import SubscriptionResource
from .raw_client import AsyncRawSubscriptionsClient, RawSubscriptionsClient
from .types.change_subscription_rate_card_request_upgrade_behavior import (
    ChangeSubscriptionRateCardRequestUpgradeBehavior,
)

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class SubscriptionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSubscriptionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSubscriptionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSubscriptionsClient
        """
        return self._raw_client

    def list_subscriptions(
        self,
        *,
        limit: typing.Optional[int] = None,
        subject_id: typing.Optional[str] = None,
        rate_card_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListSubscriptionsResponse:
        """
        Parameters
        ----------
        limit : typing.Optional[int]

        subject_id : typing.Optional[str]
            The ID or external ID of the subject to list subscriptions for. Cannot be used with rate_card_id.

        rate_card_id : typing.Optional[str]
            The ID of the rate card to list subscriptions for. Cannot be used with subject_id.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListSubscriptionsResponse
            Successful Response

        Examples
        --------
        from lark import Lark

        client = Lark(
            api_key="YOUR_API_KEY",
        )
        client.subscriptions.list_subscriptions(
            limit=1,
            subject_id="subject_id",
            rate_card_id="rate_card_id",
        )
        """
        _response = self._raw_client.list_subscriptions(
            limit=limit, subject_id=subject_id, rate_card_id=rate_card_id, request_options=request_options
        )
        return _response.data

    def create_subscription(
        self,
        *,
        rate_card_id: str,
        subject_id: str,
        metadata: typing.Optional[typing.Dict[str, str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SubscriptionResource:
        """
        Parameters
        ----------
        rate_card_id : str
            The ID of the rate card to use for the subscription.

        subject_id : str
            The ID or external ID of the subject to create the subscription for.

        metadata : typing.Optional[typing.Dict[str, str]]
            Additional metadata about the subscription. You may use this to store any custom data about the subscription.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SubscriptionResource
            Successful Response

        Examples
        --------
        from lark import Lark

        client = Lark(
            api_key="YOUR_API_KEY",
        )
        client.subscriptions.create_subscription(
            rate_card_id="rc_AJWMxR81jxoRlli6p13uf3JB",
            subject_id="subj_VyX6Q96h5avMho8O7QWlKeXE",
        )
        """
        _response = self._raw_client.create_subscription(
            rate_card_id=rate_card_id, subject_id=subject_id, metadata=metadata, request_options=request_options
        )
        return _response.data

    def get_subscription(
        self, subscription_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SubscriptionResource:
        """
        Parameters
        ----------
        subscription_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SubscriptionResource
            Successful Response

        Examples
        --------
        from lark import Lark

        client = Lark(
            api_key="YOUR_API_KEY",
        )
        client.subscriptions.get_subscription(
            subscription_id="subscription_id",
        )
        """
        _response = self._raw_client.get_subscription(subscription_id, request_options=request_options)
        return _response.data

    def cancel_subscription(
        self,
        subscription_id: str,
        *,
        reason: typing.Optional[str] = OMIT,
        cancel_at_end_of_cycle: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SubscriptionResource:
        """
        Parameters
        ----------
        subscription_id : str

        reason : typing.Optional[str]
            The reason for cancelling the subscription.

        cancel_at_end_of_cycle : typing.Optional[bool]
            Whether to cancel the subscription at end of cycle.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SubscriptionResource
            Successful Response

        Examples
        --------
        from lark import Lark

        client = Lark(
            api_key="YOUR_API_KEY",
        )
        client.subscriptions.cancel_subscription(
            subscription_id="subscription_id",
        )
        """
        _response = self._raw_client.cancel_subscription(
            subscription_id,
            reason=reason,
            cancel_at_end_of_cycle=cancel_at_end_of_cycle,
            request_options=request_options,
        )
        return _response.data

    def change_subscription_rate_card(
        self,
        subscription_id: str,
        *,
        rate_card_id: str,
        checkout_callback_urls: CheckoutCallback,
        upgrade_behavior: typing.Optional[ChangeSubscriptionRateCardRequestUpgradeBehavior] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ChangeSubscriptionRateCardResponse:
        """
        Parameters
        ----------
        subscription_id : str

        rate_card_id : str
            The ID of the rate card to change the subscription to.

        checkout_callback_urls : CheckoutCallback
            The URLs to redirect to after the checkout is completed or cancelled, if a checkout is required.

        upgrade_behavior : typing.Optional[ChangeSubscriptionRateCardRequestUpgradeBehavior]
            The behavior to use when upgrading the subscription. If 'prorate', the customer will be charged for the prorated difference. If 'rate_difference', the customer will be charged for the difference in the rate cards without respect to time.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ChangeSubscriptionRateCardResponse
            Successful Response

        Examples
        --------
        from lark import CheckoutCallback, Lark

        client = Lark(
            api_key="YOUR_API_KEY",
        )
        client.subscriptions.change_subscription_rate_card(
            subscription_id="subscription_id",
            rate_card_id="rc_jQK2n0wutCj6bBcAIrL6o07g",
            checkout_callback_urls=CheckoutCallback(
                cancelled_url="https://example.com/callback",
                success_url="https://example.com/callback",
            ),
        )
        """
        _response = self._raw_client.change_subscription_rate_card(
            subscription_id,
            rate_card_id=rate_card_id,
            checkout_callback_urls=checkout_callback_urls,
            upgrade_behavior=upgrade_behavior,
            request_options=request_options,
        )
        return _response.data


class AsyncSubscriptionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSubscriptionsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSubscriptionsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSubscriptionsClient
        """
        return self._raw_client

    async def list_subscriptions(
        self,
        *,
        limit: typing.Optional[int] = None,
        subject_id: typing.Optional[str] = None,
        rate_card_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ListSubscriptionsResponse:
        """
        Parameters
        ----------
        limit : typing.Optional[int]

        subject_id : typing.Optional[str]
            The ID or external ID of the subject to list subscriptions for. Cannot be used with rate_card_id.

        rate_card_id : typing.Optional[str]
            The ID of the rate card to list subscriptions for. Cannot be used with subject_id.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ListSubscriptionsResponse
            Successful Response

        Examples
        --------
        import asyncio

        from lark import AsyncLark

        client = AsyncLark(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.subscriptions.list_subscriptions(
                limit=1,
                subject_id="subject_id",
                rate_card_id="rate_card_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list_subscriptions(
            limit=limit, subject_id=subject_id, rate_card_id=rate_card_id, request_options=request_options
        )
        return _response.data

    async def create_subscription(
        self,
        *,
        rate_card_id: str,
        subject_id: str,
        metadata: typing.Optional[typing.Dict[str, str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SubscriptionResource:
        """
        Parameters
        ----------
        rate_card_id : str
            The ID of the rate card to use for the subscription.

        subject_id : str
            The ID or external ID of the subject to create the subscription for.

        metadata : typing.Optional[typing.Dict[str, str]]
            Additional metadata about the subscription. You may use this to store any custom data about the subscription.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SubscriptionResource
            Successful Response

        Examples
        --------
        import asyncio

        from lark import AsyncLark

        client = AsyncLark(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.subscriptions.create_subscription(
                rate_card_id="rc_AJWMxR81jxoRlli6p13uf3JB",
                subject_id="subj_VyX6Q96h5avMho8O7QWlKeXE",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_subscription(
            rate_card_id=rate_card_id, subject_id=subject_id, metadata=metadata, request_options=request_options
        )
        return _response.data

    async def get_subscription(
        self, subscription_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> SubscriptionResource:
        """
        Parameters
        ----------
        subscription_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SubscriptionResource
            Successful Response

        Examples
        --------
        import asyncio

        from lark import AsyncLark

        client = AsyncLark(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.subscriptions.get_subscription(
                subscription_id="subscription_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_subscription(subscription_id, request_options=request_options)
        return _response.data

    async def cancel_subscription(
        self,
        subscription_id: str,
        *,
        reason: typing.Optional[str] = OMIT,
        cancel_at_end_of_cycle: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SubscriptionResource:
        """
        Parameters
        ----------
        subscription_id : str

        reason : typing.Optional[str]
            The reason for cancelling the subscription.

        cancel_at_end_of_cycle : typing.Optional[bool]
            Whether to cancel the subscription at end of cycle.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SubscriptionResource
            Successful Response

        Examples
        --------
        import asyncio

        from lark import AsyncLark

        client = AsyncLark(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.subscriptions.cancel_subscription(
                subscription_id="subscription_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.cancel_subscription(
            subscription_id,
            reason=reason,
            cancel_at_end_of_cycle=cancel_at_end_of_cycle,
            request_options=request_options,
        )
        return _response.data

    async def change_subscription_rate_card(
        self,
        subscription_id: str,
        *,
        rate_card_id: str,
        checkout_callback_urls: CheckoutCallback,
        upgrade_behavior: typing.Optional[ChangeSubscriptionRateCardRequestUpgradeBehavior] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ChangeSubscriptionRateCardResponse:
        """
        Parameters
        ----------
        subscription_id : str

        rate_card_id : str
            The ID of the rate card to change the subscription to.

        checkout_callback_urls : CheckoutCallback
            The URLs to redirect to after the checkout is completed or cancelled, if a checkout is required.

        upgrade_behavior : typing.Optional[ChangeSubscriptionRateCardRequestUpgradeBehavior]
            The behavior to use when upgrading the subscription. If 'prorate', the customer will be charged for the prorated difference. If 'rate_difference', the customer will be charged for the difference in the rate cards without respect to time.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ChangeSubscriptionRateCardResponse
            Successful Response

        Examples
        --------
        import asyncio

        from lark import AsyncLark, CheckoutCallback

        client = AsyncLark(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.subscriptions.change_subscription_rate_card(
                subscription_id="subscription_id",
                rate_card_id="rc_jQK2n0wutCj6bBcAIrL6o07g",
                checkout_callback_urls=CheckoutCallback(
                    cancelled_url="https://example.com/callback",
                    success_url="https://example.com/callback",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.change_subscription_rate_card(
            subscription_id,
            rate_card_id=rate_card_id,
            checkout_callback_urls=checkout_callback_urls,
            upgrade_behavior=upgrade_behavior,
            request_options=request_options,
        )
        return _response.data
