# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.change_subscription_rate_card_response import ChangeSubscriptionRateCardResponse
from ..types.checkout_callback import CheckoutCallback
from ..types.http_validation_error import HttpValidationError
from ..types.list_subscriptions_response import ListSubscriptionsResponse
from ..types.subscription_resource import SubscriptionResource
from .types.change_subscription_rate_card_request_upgrade_behavior import (
    ChangeSubscriptionRateCardRequestUpgradeBehavior,
)

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawSubscriptionsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list_subscriptions(
        self,
        *,
        limit: typing.Optional[int] = None,
        subject_id: typing.Optional[str] = None,
        rate_card_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ListSubscriptionsResponse]:
        """
        Parameters
        ----------
        limit : typing.Optional[int]

        subject_id : typing.Optional[str]
            The ID or external ID of the subject to list subscriptions for. Cannot be used with rate_card_id.

        rate_card_id : typing.Optional[str]
            The ID of the rate card to list subscriptions for. Cannot be used with subject_id.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ListSubscriptionsResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "subscriptions",
            method="GET",
            params={
                "limit": limit,
                "subject_id": subject_id,
                "rate_card_id": rate_card_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ListSubscriptionsResponse,
                    parse_obj_as(
                        type_=ListSubscriptionsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create_subscription(
        self,
        *,
        rate_card_id: str,
        subject_id: str,
        metadata: typing.Optional[typing.Dict[str, str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SubscriptionResource]:
        """
        Parameters
        ----------
        rate_card_id : str
            The ID of the rate card to use for the subscription.

        subject_id : str
            The ID or external ID of the subject to create the subscription for.

        metadata : typing.Optional[typing.Dict[str, str]]
            Additional metadata about the subscription. You may use this to store any custom data about the subscription.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SubscriptionResource]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "subscriptions",
            method="POST",
            json={
                "rate_card_id": rate_card_id,
                "subject_id": subject_id,
                "metadata": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SubscriptionResource,
                    parse_obj_as(
                        type_=SubscriptionResource,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def get_subscription(
        self, subscription_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[SubscriptionResource]:
        """
        Parameters
        ----------
        subscription_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SubscriptionResource]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"subscriptions/{jsonable_encoder(subscription_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SubscriptionResource,
                    parse_obj_as(
                        type_=SubscriptionResource,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def cancel_subscription(
        self,
        subscription_id: str,
        *,
        reason: typing.Optional[str] = OMIT,
        cancel_at_end_of_cycle: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[SubscriptionResource]:
        """
        Parameters
        ----------
        subscription_id : str

        reason : typing.Optional[str]
            The reason for cancelling the subscription.

        cancel_at_end_of_cycle : typing.Optional[bool]
            Whether to cancel the subscription at end of cycle.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[SubscriptionResource]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"subscriptions/{jsonable_encoder(subscription_id)}/cancel",
            method="POST",
            json={
                "reason": reason,
                "cancel_at_end_of_cycle": cancel_at_end_of_cycle,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SubscriptionResource,
                    parse_obj_as(
                        type_=SubscriptionResource,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def change_subscription_rate_card(
        self,
        subscription_id: str,
        *,
        rate_card_id: str,
        checkout_callback_urls: CheckoutCallback,
        upgrade_behavior: typing.Optional[ChangeSubscriptionRateCardRequestUpgradeBehavior] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ChangeSubscriptionRateCardResponse]:
        """
        Parameters
        ----------
        subscription_id : str

        rate_card_id : str
            The ID of the rate card to change the subscription to.

        checkout_callback_urls : CheckoutCallback
            The URLs to redirect to after the checkout is completed or cancelled, if a checkout is required.

        upgrade_behavior : typing.Optional[ChangeSubscriptionRateCardRequestUpgradeBehavior]
            The behavior to use when upgrading the subscription. If 'prorate', the customer will be charged for the prorated difference. If 'rate_difference', the customer will be charged for the difference in the rate cards without respect to time.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ChangeSubscriptionRateCardResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"subscriptions/{jsonable_encoder(subscription_id)}/change-rate-card",
            method="POST",
            json={
                "rate_card_id": rate_card_id,
                "upgrade_behavior": upgrade_behavior,
                "checkout_callback_urls": convert_and_respect_annotation_metadata(
                    object_=checkout_callback_urls, annotation=CheckoutCallback, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ChangeSubscriptionRateCardResponse,
                    parse_obj_as(
                        type_=ChangeSubscriptionRateCardResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawSubscriptionsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list_subscriptions(
        self,
        *,
        limit: typing.Optional[int] = None,
        subject_id: typing.Optional[str] = None,
        rate_card_id: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ListSubscriptionsResponse]:
        """
        Parameters
        ----------
        limit : typing.Optional[int]

        subject_id : typing.Optional[str]
            The ID or external ID of the subject to list subscriptions for. Cannot be used with rate_card_id.

        rate_card_id : typing.Optional[str]
            The ID of the rate card to list subscriptions for. Cannot be used with subject_id.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ListSubscriptionsResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "subscriptions",
            method="GET",
            params={
                "limit": limit,
                "subject_id": subject_id,
                "rate_card_id": rate_card_id,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ListSubscriptionsResponse,
                    parse_obj_as(
                        type_=ListSubscriptionsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create_subscription(
        self,
        *,
        rate_card_id: str,
        subject_id: str,
        metadata: typing.Optional[typing.Dict[str, str]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SubscriptionResource]:
        """
        Parameters
        ----------
        rate_card_id : str
            The ID of the rate card to use for the subscription.

        subject_id : str
            The ID or external ID of the subject to create the subscription for.

        metadata : typing.Optional[typing.Dict[str, str]]
            Additional metadata about the subscription. You may use this to store any custom data about the subscription.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SubscriptionResource]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "subscriptions",
            method="POST",
            json={
                "rate_card_id": rate_card_id,
                "subject_id": subject_id,
                "metadata": metadata,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SubscriptionResource,
                    parse_obj_as(
                        type_=SubscriptionResource,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def get_subscription(
        self, subscription_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[SubscriptionResource]:
        """
        Parameters
        ----------
        subscription_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SubscriptionResource]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"subscriptions/{jsonable_encoder(subscription_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SubscriptionResource,
                    parse_obj_as(
                        type_=SubscriptionResource,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def cancel_subscription(
        self,
        subscription_id: str,
        *,
        reason: typing.Optional[str] = OMIT,
        cancel_at_end_of_cycle: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[SubscriptionResource]:
        """
        Parameters
        ----------
        subscription_id : str

        reason : typing.Optional[str]
            The reason for cancelling the subscription.

        cancel_at_end_of_cycle : typing.Optional[bool]
            Whether to cancel the subscription at end of cycle.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[SubscriptionResource]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"subscriptions/{jsonable_encoder(subscription_id)}/cancel",
            method="POST",
            json={
                "reason": reason,
                "cancel_at_end_of_cycle": cancel_at_end_of_cycle,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    SubscriptionResource,
                    parse_obj_as(
                        type_=SubscriptionResource,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def change_subscription_rate_card(
        self,
        subscription_id: str,
        *,
        rate_card_id: str,
        checkout_callback_urls: CheckoutCallback,
        upgrade_behavior: typing.Optional[ChangeSubscriptionRateCardRequestUpgradeBehavior] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ChangeSubscriptionRateCardResponse]:
        """
        Parameters
        ----------
        subscription_id : str

        rate_card_id : str
            The ID of the rate card to change the subscription to.

        checkout_callback_urls : CheckoutCallback
            The URLs to redirect to after the checkout is completed or cancelled, if a checkout is required.

        upgrade_behavior : typing.Optional[ChangeSubscriptionRateCardRequestUpgradeBehavior]
            The behavior to use when upgrading the subscription. If 'prorate', the customer will be charged for the prorated difference. If 'rate_difference', the customer will be charged for the difference in the rate cards without respect to time.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ChangeSubscriptionRateCardResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"subscriptions/{jsonable_encoder(subscription_id)}/change-rate-card",
            method="POST",
            json={
                "rate_card_id": rate_card_id,
                "upgrade_behavior": upgrade_behavior,
                "checkout_callback_urls": convert_and_respect_annotation_metadata(
                    object_=checkout_callback_urls, annotation=CheckoutCallback, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ChangeSubscriptionRateCardResponse,
                    parse_obj_as(
                        type_=ChangeSubscriptionRateCardResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
