# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .active_subscription import ActiveSubscription
from .usage_data_for_rate import UsageDataForRate


class BillingStateResponse(UniversalBaseModel):
    has_active_subscription: bool = pydantic.Field()
    """
    Whether the subject has an active subscription.
    """

    has_overage_for_usage: bool = pydantic.Field()
    """
    Whether the subject has exceeded the included usage (if any) on a usage-based rate they are subscribed to.
    """

    active_subscriptions: typing.List[ActiveSubscription] = pydantic.Field()
    """
    List of active subscriptions the subject is subscribed to.
    """

    usage_data: typing.List[UsageDataForRate] = pydantic.Field()
    """
    The usage data for the usage-based rates the subject is subscribed to.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
