# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .price import Price


class CreateSimpleUsageBasedRateRequest(UniversalBaseModel):
    name: str = pydantic.Field()
    """
    The name of the rate displayed to the customer.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the rate displayed to the customer.
    """

    price: Price
    included_units: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of units included in the rate before the price is applied.
    """

    pricing_metric_id: str = pydantic.Field()
    """
    The ID of the pricing metric to use for this rate.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
