# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel


class CreateSubjectResponse(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    The ID of the subject.
    """

    external_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The ID of the subject in your system. You may pass it to the API in place of the subject ID.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the subject. Used for display in the dashboard.
    """

    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    The email of the subject.
    """

    metadata: typing.Dict[str, str] = pydantic.Field()
    """
    Additional metadata about the subject. You may use this to store any custom data about the subject.
    """

    created_at: dt.datetime = pydantic.Field()
    """
    The date and time the subject was created.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
