# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .amount import Amount
from .package_price_output_rounding_behavior import PackagePriceOutputRoundingBehavior


class PackagePrice(UniversalBaseModel):
    """
    Package price is a price that is charged for a fixed number of units. For example, $10 per 1000 units. If the quantity is not a multiple of the package units, the rounding behavior will be applied.
    """

    amount: Amount
    package_units: int
    rounding_behavior: PackagePriceOutputRoundingBehavior

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
