# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .aggregation import Aggregation


class PricingMetricResource(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    The ID of the pricing metric.
    """

    name: str = pydantic.Field()
    """
    The name of the pricing metric.
    """

    event_name: str = pydantic.Field()
    """
    The event name that the pricing metric is computed on.
    """

    aggregation: Aggregation = pydantic.Field()
    """
    The aggregation function used to compute the value of the pricing metric.
    """

    unit: str = pydantic.Field()
    """
    The unit of the value computed by the pricing metric.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
