# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .period import Period


class PricingMetricSummaryResource(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    The ID of the pricing metric summary.
    """

    pricing_metric_id: str = pydantic.Field()
    """
    The ID of the pricing metric that the summary is for.
    """

    subject_id: str = pydantic.Field()
    """
    The ID of the subject that the summary is for.
    """

    period: Period = pydantic.Field()
    """
    The period that the summary is computed over.
    """

    value: typing.Optional[str] = pydantic.Field(default=None)
    """
    The computed value of the pricing metric for the period. If the pricing metric does not have any usage events for the period, this will be `null`.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
