# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .fixed_rate_interface import FixedRateInterface
from .rate_card_resource_billing_interval import RateCardResourceBillingInterval
from .rate_card_resource_usage_based_rates_item import RateCardResourceUsageBasedRatesItem


class RateCardResource(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    The ID of the rate card.
    """

    name: str = pydantic.Field()
    """
    The name of the rate card.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the rate card.
    """

    usage_based_rates: typing.List[RateCardResourceUsageBasedRatesItem] = pydantic.Field()
    """
    The usage based rates of the rate card.
    """

    fixed_rates: typing.List[FixedRateInterface] = pydantic.Field()
    """
    The fixed rates of the rate card.
    """

    billing_interval: RateCardResourceBillingInterval
    created_at: dt.datetime = pydantic.Field()
    """
    The date and time the rate card was created.
    """

    updated_at: dt.datetime = pydantic.Field()
    """
    The date and time the rate card was last updated.
    """

    metadata: typing.Dict[str, str]

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
