# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from .period_resource import PeriodResource
from .subscription_status import SubscriptionStatus


class SubscriptionResource(UniversalBaseModel):
    id: str = pydantic.Field()
    """
    The ID of the subscription.
    """

    subject_id: str = pydantic.Field()
    """
    The ID of the subject that the subscription is for.
    """

    rate_card_id: str = pydantic.Field()
    """
    The ID of the rate card of the subscription.
    """

    effective_at: dt.datetime = pydantic.Field()
    """
    The date and time the subscription became effective.
    """

    cycles_next_at: typing.Optional[dt.datetime] = pydantic.Field(default=None)
    """
    The date and time the next cycle of the subscription will start.
    """

    current_period: typing.Optional[PeriodResource] = pydantic.Field(default=None)
    """
    The current period of the subscription if it is active.
    """

    metadata: typing.Dict[str, str]
    status: SubscriptionStatus = pydantic.Field()
    """
    The status of the subscription.
    """

    cancels_at_end_of_cycle: bool = pydantic.Field()
    """
    Whether the subscription will be cancelled at the end of the current cycle.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
