# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawUsageEventsClient, RawUsageEventsClient
from .types.create_usage_event_request_data_value import CreateUsageEventRequestDataValue

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class UsageEventsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawUsageEventsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawUsageEventsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawUsageEventsClient
        """
        return self._raw_client

    def create_usage_event(
        self,
        *,
        idempotency_key: str,
        event_name: str,
        subject_id: str,
        data: typing.Dict[str, CreateUsageEventRequestDataValue],
        timestamp: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        idempotency_key : str
            The idempotency key for the usage event. This ensures that the same event is not processed multiple times.

        event_name : str
            The name of the event. This is used by pricing metrics to aggregate usage events.

        subject_id : str
            The ID or external ID of the subject that the usage event is for.

        data : typing.Dict[str, CreateUsageEventRequestDataValue]
            The data of the usage event. This should contain any data that is needed to aggregate the usage event.

        timestamp : typing.Optional[dt.datetime]
            The timestamp of the usage event. It is highly recommended to provide a timestamp. If not provided, the current timestamp will be used.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import datetime

        from lark import Lark

        client = Lark(
            api_key="YOUR_API_KEY",
        )
        client.usage_events.create_usage_event(
            idempotency_key="4a1d819c-7d3e-47cf-bc06-ecb185702540",
            event_name="compute_hours",
            subject_id="subj_VyX6Q96h5avMho8O7QWlKeXE",
            timestamp=datetime.datetime.fromisoformat(
                "2025-11-06 21:43:48+00:00",
            ),
            data={
                "compute_hours": 100,
                "instance_type": "t2.micro",
                "region": "us-east-1",
            },
        )
        """
        _response = self._raw_client.create_usage_event(
            idempotency_key=idempotency_key,
            event_name=event_name,
            subject_id=subject_id,
            data=data,
            timestamp=timestamp,
            request_options=request_options,
        )
        return _response.data


class AsyncUsageEventsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawUsageEventsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawUsageEventsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawUsageEventsClient
        """
        return self._raw_client

    async def create_usage_event(
        self,
        *,
        idempotency_key: str,
        event_name: str,
        subject_id: str,
        data: typing.Dict[str, CreateUsageEventRequestDataValue],
        timestamp: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[typing.Any]:
        """
        Parameters
        ----------
        idempotency_key : str
            The idempotency key for the usage event. This ensures that the same event is not processed multiple times.

        event_name : str
            The name of the event. This is used by pricing metrics to aggregate usage events.

        subject_id : str
            The ID or external ID of the subject that the usage event is for.

        data : typing.Dict[str, CreateUsageEventRequestDataValue]
            The data of the usage event. This should contain any data that is needed to aggregate the usage event.

        timestamp : typing.Optional[dt.datetime]
            The timestamp of the usage event. It is highly recommended to provide a timestamp. If not provided, the current timestamp will be used.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[typing.Any]
            Successful Response

        Examples
        --------
        import asyncio
        import datetime

        from lark import AsyncLark

        client = AsyncLark(
            api_key="YOUR_API_KEY",
        )


        async def main() -> None:
            await client.usage_events.create_usage_event(
                idempotency_key="4a1d819c-7d3e-47cf-bc06-ecb185702540",
                event_name="compute_hours",
                subject_id="subj_VyX6Q96h5avMho8O7QWlKeXE",
                timestamp=datetime.datetime.fromisoformat(
                    "2025-11-06 21:43:48+00:00",
                ),
                data={
                    "compute_hours": 100,
                    "instance_type": "t2.micro",
                    "region": "us-east-1",
                },
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_usage_event(
            idempotency_key=idempotency_key,
            event_name=event_name,
            subject_id=subject_id,
            data=data,
            timestamp=timestamp,
            request_options=request_options,
        )
        return _response.data
