# This file was auto-generated by Fern from our API Definition.

import datetime as dt
import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.http_validation_error import HttpValidationError
from .types.create_usage_event_request_data_value import CreateUsageEventRequestDataValue

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawUsageEventsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def create_usage_event(
        self,
        *,
        idempotency_key: str,
        event_name: str,
        subject_id: str,
        data: typing.Dict[str, CreateUsageEventRequestDataValue],
        timestamp: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.Optional[typing.Any]]:
        """
        Parameters
        ----------
        idempotency_key : str
            The idempotency key for the usage event. This ensures that the same event is not processed multiple times.

        event_name : str
            The name of the event. This is used by pricing metrics to aggregate usage events.

        subject_id : str
            The ID or external ID of the subject that the usage event is for.

        data : typing.Dict[str, CreateUsageEventRequestDataValue]
            The data of the usage event. This should contain any data that is needed to aggregate the usage event.

        timestamp : typing.Optional[dt.datetime]
            The timestamp of the usage event. It is highly recommended to provide a timestamp. If not provided, the current timestamp will be used.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            "usage-events",
            method="POST",
            json={
                "idempotency_key": idempotency_key,
                "event_name": event_name,
                "subject_id": subject_id,
                "timestamp": timestamp,
                "data": convert_and_respect_annotation_metadata(
                    object_=data, annotation=typing.Dict[str, CreateUsageEventRequestDataValue], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if _response is None or not _response.text.strip():
                return HttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawUsageEventsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def create_usage_event(
        self,
        *,
        idempotency_key: str,
        event_name: str,
        subject_id: str,
        data: typing.Dict[str, CreateUsageEventRequestDataValue],
        timestamp: typing.Optional[dt.datetime] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.Optional[typing.Any]]:
        """
        Parameters
        ----------
        idempotency_key : str
            The idempotency key for the usage event. This ensures that the same event is not processed multiple times.

        event_name : str
            The name of the event. This is used by pricing metrics to aggregate usage events.

        subject_id : str
            The ID or external ID of the subject that the usage event is for.

        data : typing.Dict[str, CreateUsageEventRequestDataValue]
            The data of the usage event. This should contain any data that is needed to aggregate the usage event.

        timestamp : typing.Optional[dt.datetime]
            The timestamp of the usage event. It is highly recommended to provide a timestamp. If not provided, the current timestamp will be used.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.Optional[typing.Any]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            "usage-events",
            method="POST",
            json={
                "idempotency_key": idempotency_key,
                "event_name": event_name,
                "subject_id": subject_id,
                "timestamp": timestamp,
                "data": convert_and_respect_annotation_metadata(
                    object_=data, annotation=typing.Dict[str, CreateUsageEventRequestDataValue], direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if _response is None or not _response.text.strip():
                return AsyncHttpResponse(response=_response, data=None)
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.Optional[typing.Any],
                    parse_obj_as(
                        type_=typing.Optional[typing.Any],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
