import queue
from rupython import __Общие_функции__

Очередь_пуста = queue.Empty
Очередь_полна = queue.Full

Словарь_параметров = {
    'максимальный_размер': 'maxsize',
    'элемент': 'item',
    'блоковать': 'block',
    'таймаут': 'timeout',
    'приоритет': 'priority'
}

Словарь_склонений = {
    'элемент': ['элемент', 'элемента', 'элементов'],
    'задача': ['задача', 'задачи', 'задач']
}

class Очередь:
    def __init__(экземпляр, максимальный_размер = 0):
        ИА = {'maxsize': максимальный_размер}
        экземпляр._queue = queue.Queue(**ИА)
    
    def Добавить(экземпляр, элемент, блоковать = True, таймаут = None):
        ИА = {'item': элемент, 'block': блоковать}
        if таймаут is not None:
            ИА['timeout'] = таймаут
        экземпляр._queue.put(**ИА)
    
    def Добавить_без_блокования(экземпляр, элемент):
        экземпляр._queue.put_nowait(элемент)
    
    def Получить(экземпляр, блоковать = True, таймаут = None):
        ИА = {'block': блоковать}
        if таймаут is not None:
            ИА['timeout'] = таймаут
        return экземпляр._queue.get(**ИА)
    
    def Получить_без_блокования(экземпляр):
        return экземпляр._queue.get_nowait()
    
    def Задача_выполнена(экземпляр):
        экземпляр._queue.task_done()
    
    def Ждать_завершения(экземпляр):
        экземпляр._queue.join()
    
    def Пустая(экземпляр):
        return экземпляр._queue.empty()
    
    def Полная(экземпляр):
        return экземпляр._queue.full()
    
    def Размер(экземпляр):
        return экземпляр._queue.qsize()
    
    def __len__(экземпляр):
        return экземпляр._queue.qsize()
    
    def __str__(экземпляр):
        размер = экземпляр.Размер()
        return f"Очередь с {__Общие_функции__.Склонение_после_числительного(размер, Словарь_склонений['элемент'])}"

    def В_строку_с_задачами(экземпляр):
        размер = экземпляр.Размер()
        return f"Очередь с {__Общие_функции__.Склонение_после_числительного(размер, Словарь_склонений['задача'])}"

class Стековая_очередь:
    def __init__(экземпляр, максимальный_размер = 0):
        ИА = {'maxsize': максимальный_размер}
        экземпляр._queue = queue.LifoQueue(**ИА)
    
    def Добавить(экземпляр, элемент, блоковать = True, таймаут = None):
        ИА = {'item': элемент, 'block': блоковать}
        if таймаут is not None:
            ИА['timeout'] = таймаут
        экземпляр._queue.put(**ИА)
    
    def Добавить_без_блокования(экземпляр, элемент):
        экземпляр._queue.put_nowait(элемент)
    
    def Получить(экземпляр, блоковать = True, таймаут = None):
        ИА = {'block': блоковать}
        if таймаут is not None:
            ИА['timeout'] = таймаут
        return экземпляр._queue.get(**ИА)
    
    def Получить_без_блокования(экземпляр):
        return экземпляр._queue.get_nowait()
    
    def Задача_выполнена(экземпляр):
        экземпляр._queue.task_done()
    
    def Ждать_завершения(экземпляр):
        экземпляр._queue.join()
    
    def Пустая(экземпляр):
        return экземпляр._queue.empty()
    
    def Полная(экземпляр):
        return экземпляр._queue.full()
    
    def Размер(экземпляр):
        return экземпляр._queue.qsize()
    
    def __len__(экземпляр):
        return экземпляр._queue.qsize()
    
    def __str__(экземпляр):
        размер = экземпляр.Размер()
        return f"Стековая_очередь с {__Общие_функции__.Склонение_после_числительного(размер, Словарь_склонений['элемент'])}"

    def В_строку_с_задачами(экземпляр):
        размер = экземпляр.Размер()
        return f"Стековая_очередь с {__Общие_функции__.Склонение_после_числительного(размер, Словарь_склонений['задача'])}"

class Приоритетная_очередь:
    def __init__(экземпляр, максимальный_размер = 0):
        ИА = {'maxsize': максимальный_размер}
        экземпляр._queue = queue.PriorityQueue(**ИА)
    
    def Добавить(экземпляр, элемент, приоритет, блоковать = True, таймаут = None):
        ИА = {'item': (приоритет, элемент), 'block': блоковать}
        if таймаут is not None:
            ИА['timeout'] = таймаут
        экземпляр._queue.put(**ИА)
    
    def Добавить_без_блокования(экземпляр, элемент, приоритет):
        экземпляр._queue.put_nowait((приоритет, элемент))
    
    def Получить(экземпляр, блоковать = True, таймаут = None):
        ИА = {'block': блоковать}
        if таймаут is not None:
            ИА['timeout'] = таймаут
        приоритет, элемент = экземпляр._queue.get(**ИА)
        return элемент
    
    def Получить_с_приоритетом(экземпляр, блоковать = True, таймаут = None):
        ИА = {'block': блоковать}
        if таймаут is not None:
            ИА['timeout'] = таймаут
        return экземпляр._queue.get(**ИА)
    
    def Получить_без_блокования(экземпляр):
        приоритет, элемент = экземпляр._queue.get_nowait()
        return элемент
    
    def Получить_без_блокования_с_приоритетом(экземпляр):
        return экземпляр._queue.get_nowait()
    
    def Задача_выполнена(экземпляр):
        экземпляр._queue.task_done()
    
    def Ждать_завершения(экземпляр):
        экземпляр._queue.join()
    
    def Пустая(экземпляр):
        return экземпляр._queue.empty()
    
    def Полная(экземпляр):
        return экземпляр._queue.full()
    
    def Размер(экземпляр):
        return экземпляр._queue.qsize()
    
    def __len__(экземпляр):
        return экземпляр._queue.qsize()
    
    def __str__(экземпляр):
        размер = экземпляр.Размер()
        return f"Приоритетная_очередь с {__Общие_функции__.Склонение_после_числительного(размер, Словарь_склонений['элемент'])}"

    def В_строку_с_задачами(экземпляр):
        размер = экземпляр.Размер()
        return f"Приоритетная_очередь с {__Общие_функции__.Склонение_после_числительного(размер, Словарь_склонений['задача'])}"

class Простая_очередь:
    def __init__(экземпляр):
        экземпляр._queue = queue.SimpleQueue()
    
    def Добавить(экземпляр, элемент):
        экземпляр._queue.put(элемент)
    
    def Получить(экземпляр):
        return экземпляр._queue.get()
    
    def Получить_без_блокования(экземпляр):
        return экземпляр._queue.get_nowait()
    
    def Пустая(экземпляр):
        экземпляр._queue.empty()
    
    def Размер(экземпляр):
        return экземпляр._queue.qsize()
    
    def __len__(экземпляр):
        return экземпляр._queue.qsize()
    
    def __str__(экземпляр):
        размер = экземпляр.Размер()
        return f"Простая_очередь с {__Общие_функции__.Склонение_после_числительного(размер, Словарь_склонений['элемент'])}"

    def В_строку_с_задачами(экземпляр):
        размер = экземпляр.Размер()
        return f"Простая_очередь с {__Общие_функции__.Склонение_после_числительного(размер, Словарь_склонений['задача'])}"
