import os
import shutil
import pathlib

Путь_Строка = str
Путь_Объект = pathlib.Path

Словарь_параметров_файлов = {
    'путь': 'path',
    'старый_путь': 'src',
    'новый_путь': 'dst',
    'режим': 'mode',
    'создать_родительские': 'parents',
    'существование_допустимо': 'exist_ok',
    'игнорировать_ошибки': 'ignore_errors',
    'директория': 'dir_fd',
    'следовать_символическим_ссылкам': 'follow_symlinks'
}

def Объединить_пути(*части_пути): return os.path.join(*части_пути)
def Нормализовать_путь(путь): return os.path.normpath(путь)
def Абсолютный_путь(путь): return os.path.abspath(путь)
def Базовое_название(путь): return os.path.basename(путь)
def Название_каталога(путь): return os.path.dirname(путь)
def Разбить_расширение(путь): return os.path.splitext(путь)
def Существует(путь): return os.path.exists(путь)
def Это_файл(путь): return os.path.isfile(путь)
def Это_каталог(путь): return os.path.isdir(путь)
def Размер_файла(путь): return os.path.getsize(путь)

def Создать_каталог(путь, режим=0o777, создать_родительские=False, существование_допустимо=False):
    os.makedirs(путь, mode=режим, exist_ok=существование_допустимок)

def Удалить_файл(путь): os.remove(путь)
def Удалить_каталог(путь): os.rmdir(путь)
def Переименовать(старый_путь, новый_путь): os.rename(старый_путь, новый_путь)
def Перечислить_содержимое(путь='.'): return os.listdir(путь)
def Текущий_каталог(): return os.getcwd()
def Изменить_текущий_каталог(путь): os.chdir(путь)

def Копировать_файл(путь_источника, путь_назначения):
    shutil.copy2(путь_источника, путь_назначения)

def Копировать_каталог(путь_источника, путь_назначения, игнорировать=None):
    shutil.copytree(путь_источника, путь_назначения, ignore=игнорировать)

def Переместить(путь_источника, путь_назначения):
    shutil.move(путь_источника, путь_назначения)

def Удалить_дерево(путь, игнорировать_ошибки=False):
    shutil.rmtree(путь, ignore_errors=игнорировать_ошибки)

class Путь:
    def __init__(экземпляр, *части_пути):
        экземпляр._путь = pathlib.Path(*части_пути)

    @property
    def название(экземпляр): return экземпляр._путь.name

    @property
    def расширение(экземпляр): return экземпляр._путь.suffix

    @property
    def родитель(экземпляр): return Путь(экземпляр._путь.parent)

    @property
    def существует(экземпляр): return экземпляр._путь.exists()

    @property
    def это_файл(экземпляр): return экземпляр._путь.is_file()

    @property
    def это_каталог(экземпляр): return экземпляр._путь.is_dir()

    def Создать_каталоги(экземпляр, создать_родительские=False, существование_допустимо=False):
        экземпляр._путь.mkdir(parents=создать_родительские, exist_ok=существование_допустимо)

    def Удалить(экземпляр):
        if экземпляр.это_файл: экземпляр._путь.unlink()
        elif экземпляр.это_каталог: экземпляр._путь.rmdir()
        else:
            raise FileNotFoundError(f"Путь не существует или не является файлом/пустым каталогом: {экземпляр._путь}")

    def Удалить_рекурсивно(экземпляр, игнорировать_ошибки=False):
        if экземпляр.это_каталог:
            Удалить_дерево(str(экземпляр._путь), игнорировать_ошибки)
        else:
            raise NotADirectoryError(f"Путь не является каталогом: {экземпляр._путь}")

    def Переименовать_в(экземпляр, новый_путь):
        экземпляр._путь.rename(новый_путь)
        экземпляр._путь = pathlib.Path(новый_путь)

    def Копировать_в(экземпляр, путь_назначения):
        if экземпляр.это_файл:
            Копировать_файл(str(экземпляр._путь), str(путь_назначения))
        elif экземпляр.это_каталог:
            Копировать_каталог(str(экземпляр._путь), str(путь_назначения))
        else:
            raise FileNotFoundError(f"Невозможно скопировать: путь не является файлом или каталогом: {экземпляр._путь}")

    def Переместить_в(экземпляр, путь_назначения):
        Переместить(str(экземпляр._путь), str(путь_назначения))
        экземпляр._путь = pathlib.Path(путь_назначения)

    def Содержимое(экземпляр):
        if not экземпляр.это_каталог:
            raise NotADirectoryError(f"Путь не является каталогом: {экземпляр._путь}")
        return [Путь(p) for p in экземпляр._путь.iterdir()]

    def __truediv__(экземпляр, другая_часть):
        return Путь(экземпляр._путь / другая_часть)

    def __str__(экземпляр):
        return str(экземпляр._путь)

    def __repr__(экземпляр):
        return f"Путь('{экземпляр._путь}')"

    def __eq__(экземпляр, другой):
        if isinstance(другой, Путь):
            return экземпляр._путь == другой._путь
        return NotImplemented
