import tokenize as Разборщик_слов
import runpy as Запуск_кода
import traceback as Разборщик_исключений
import os as ОС
import sys as Система
import re as РегВыр
import shutil as Операции_оболочки
from io import StringIO as Текстовый_ВВ

Служебные_слова = {
    'Да': 'True',
    'Нет': 'False',
    'Пусто': 'None', # Ничего, Неопр
    'и': 'and',
    'или': 'or',
    'не': 'not',
    'это': 'is',
    'Функция': 'def',
    'функция': 'def',
    'Класс': 'class',
    'Общее': 'global', # Глобальное
    'НеМестное': 'nonlocal', # Нелокальное
    'Из': 'from',
    'Подключить': 'import',
    'подключить': 'import',
    'как': 'as',
    'Возврат': 'return',
    'Вернуть': 'return',
    'Пропустить': 'pass',
    'Бросить': 'raise',
    'Продолжить': 'continue',
    'в': 'in',
    'Если': 'if',
    'АЕсли': 'elif',
    'Иначе': 'else',
    'если': 'if',
    'иначе': 'else',
    'Для': 'for',
    'из': 'in',
    'для': 'for',
    'Пока': 'while',
    'Прервать': 'break',
    'Попробовать': 'try', # Попытка
    'Перехватив': 'except',
    'Завершив': 'finally',
    'Проверить': 'assert',
    'фун': 'lambda',
    'Выдать': 'yield',
    'Используя': 'with',
    'Удалить': 'del',
    'Выбрать': 'match',
    'При': 'case',
    'Асинхр': 'async',
    'Ожидать': 'await'
}

Встроенные_функции = {
    'АбсЗнач': ( 'abs', None, False ), # Модуль
    'АсинхрПеребиратель': ( 'aiter', None, False ),
    'АсСледующий': ( 'anext', None, False ),
    'БайтМассив': ( 'bytearray', { 'источник': 'source', 'кодование': 'encoding', 'при_ошибках': 'errors' }, True ),
    'Байты': ( 'bytes', { 'источник': 'source', 'кодование': 'encoding', 'при_ошибках': 'errors' }, True ),
    'В7битовСимв': ( 'ascii', None, False ),
    'Вещ': ( 'float', None, True ),
    'Восьм': ( 'oct', None, False ),
    'Все': ( 'all', None, False ),
    'Вывести': ( 'print', { 'разделитель': 'sep', 'в_конце': 'end', 'файл': 'file', 'немедленно': 'flush' }, False ),
    'Вызываемое': ( 'callable', None, False ),
    'ВыпКод': ( 'exec', { 'замыкание': 'closure' }, False ),
    'ВычВыр': ( 'eval', None, False ),
    'Двоич': ( 'bin', None, False ),
    'ДелОст': ( 'divmod', None, False ),
    'Длина': ( 'len', None, False ), # Размер
    'Код_символа': ( 'ord', None, False ), # Знак_в_код
    'Идент': ( 'id', None, False ),
    'Имеет_поле': ( 'hasattr', None, False ),
    'Символ_по_коду': ( 'chr', None, False ), # Код_в_знак
    'Компл': ( 'complex', { 'действ_часть': 'real', 'мнимая_часть': 'imag' }, True ),
    'Кортеж': ( 'tuple', None, True ),
    'Логич': ( 'bool', None, False ),
    'Любое': ( 'any', None, False ),
    'Макс': ( 'max', { 'ф_сравнения': 'key', 'если_пусто': 'default' }, False ),
    'Местные_сущности': ( 'locals', None, False ),
    'Метод_класса': ( 'classmethod', None, False ),
    'Метод_получения': ( 'getter', None, False ),
    'Метод_установки': ( 'setter', None, False ),
    'Метод_удаления': ( 'deleter', None, False ),
    'Мин': ( 'min', { 'ф_сравнения': 'key', 'если_пусто': 'default' }, False ),
    'Множ': ( 'set', None, True ),
    'Надкласс': ( 'super', None, True ),
    'НеизмМнож': ( 'frozenset', None, True ),
    'Обратить': ( 'reversed', None, False ),
    'Общие_сущности': ( 'globals', None, False ),
    'Объект': ( 'object', None, True ),
    'Округлить': ( 'round', { 'число': 'number', 'разрядов': 'ndigits' }, False ),
    'Останов': ( 'breakpoint', None, False ),
    'Открыть': ( 'open', { 'название': 'name', 'режим': 'mode', 'буферизация': 'buffering', 'кодование': 'encoding', 'при_ошибках': 'errors', 'новая_строка': 'newline', 'закрыть_описатель': 'closefd', 'открыватель': 'opener' }, False ),
    'Отображение': ( 'map', None, False ),
    'Память': ( 'memoryview', { 'объект': 'object' }, True ),
    'Перебиратель': ( 'iter', None, False ),
    'Перечень': ( 'enumerate', { 'перебираемое': 'iterable', 'начало': 'start' }, False ), # Перечислить
    'Подкласс': ( 'issubclass', None, False ),
    'Получить_поле': ( 'getattr', None, False ),
    'Поля': ( 'vars', None, False ),
    'Представление': ( 'repr', None, False ),
    'Принять': ( 'input', None, False ),
    'Ряд': ( 'range', None, True ), # Диапазон, Последов
    'Свойство': ( 'property', { 'ф_получения': 'fget', 'ф_установки': 'fset', 'ф_удаления': 'fdel', 'документация': 'doc' }, True ),
    'Следующий': ( 'next', None, False ),
    'Словарь': ( 'dict', None, True ),
    'Собрать_код': ( 'compile', { 'исходник': 'source', 'название_файла': 'filename', 'режим': 'mode', 'флаги': 'flags', 'не_наследовать': 'dont_inherit', 'optimize': 'оптимизация' }, False ),
    'Содержимое': ( 'dir', None, False ),
    'Список': ( 'list', None, True ),
    'Справка': ( 'help', None, False ),
    'Срез': ( 'slice', None, True ),
    'Статический_метод': ( 'staticmethod', None, False ),
    'Степень': ( 'pow', None, False ),
    'Строка': ( 'str', { 'кодование': 'encoding', 'при_ошибках': 'errors' }, True ), # Текст
    'Сумма': ( 'sum', { 'начало': 'start' }, False ),
    'Тип': ( 'type', None, True ), # Вид
    'Удалить_поле': ( 'delattr', None, False ),
    'Упаковать': ( 'zip', { 'проверить_длины': 'strict' }, False ),
    'Упорядочить': ( 'sorted', { 'ф_сравнения': 'key', 'наоборот': 'reverse' }, False ),
    'Установить_поле': ( 'setattr', None, False ),
    'Фильтр': ( 'filter', None, False ),
    'Формат': ( 'format', None, False ),
    'Хэш': ( 'hash', None, False ),
    'Цел': ( 'int', { 'основание': 'base' }, True ),
    'Шестн': ( 'hex', None, False ),
    'Экземпляр': ( 'isinstance', None, False ),
    '__Подключить__': ( '__import__' , { 'название': 'name', 'общие_сущности': 'globals', 'местные_сущности': 'locals', 'по_списку': 'fromlist', 'уровень': 'level' }, False )
}

Специальные_названия = {
    '__Название__': '__name__',
    '__Пакет__': '__package__',
    '__Модуль__': '__module__',
    '__Файл__': '__file__',
    '__Полное_имя__': '__qualname__',
    '__Документация__': '__doc__',
    '__Примечания__': '__annotations__',
    '__Загрузчик__': '__loader__',
    '__Спецификация__': '__spec__',
    '__Встроенное__': '__builtins__',
    '__Кэш__': '__cached__',
    '__Поля__': '__dict__',
    '__Класс__': '__class__',
    '__Надклассы__': '__bases__',
    '__Подклассы__': '__subclasses__',
    '__Порядок_разрешения_методов__': '__mro__',
    '__Параметры_типа__': '__type_params__',
    '__Значение__': '__value__',
    '__По_умолчанию__': '__defaults__',
    '__Именованные_по_умолчанию': '__kwdefaults__',
    '__Замыкание__': '__closure__',
    '__Код__': '__code__',
    '__Флаги__': '__flags__',
    '__Отладка__': '__debug__',
    '__Создание__': '__new__',
    '__Подготовка__': '__init__',
    '__Уничтожение__': '__del__',
    '__Представление__': '__repr__',
    '__Строка__': '__str__',
    '__Байты__': '__bytes__',
    '__Формат__': '__format__',
    '__МЧ__': '__lt__',
    '__МР__': '__le__',
    '__РВ__': '__eq__',
    '__НР__': '__ne__',
    '__БЧ__': '__gt__',
    '__БР__': '__ge__',
    '__Хэш__': '__hash__',
    '__Несуществующее_поле__': '__getattr__',
    '__Получить_поле__': '__getattribute__',
    '__Установка_поля__': '__setattr__',
    '__Удаление_поля__': '__delattr__',
    '__Содержимое__': '__dir__',
    '__Получение__': '__get__',
    '__Установка__': '__set__',
    '__Удаление__': '__delete__',
    '__Вызов__': '__call__',
    '__Длина__': '__len__',
    '__Подсказка_длины__': '__length_hint__',
    '__Получение_значения__': '__getitem__',
    '__Установка_значения__': '__setitem__',
    '__Удаление_значения__': '__delitem__',
    '__Пропущенное_значение__': '__missing__',
    '__Перебиратель__': '__iter__',
    '__АсПеребиратель__': '__aiter__',
    '__Следующий__': '__next__',
    '__АсСледующий__': '__anext__',
    '__Обращение__': '__reversed__',
    '__Содержит__': '__contains__',
    '__Сцепление__': '__concat__',
    '__Сложение__': '__add__',
    '__Вычитание__': '__sub__',
    '__Умножение__': '__mul__',
    '__МатрУмн__': '__matmul__',
    '__Деление__': '__truediv__',
    '__ЦелДел__': '__floordiv__',
    '__Остаток__': '__mod__',
    '__ЧастОст__': '__divmod__',
    '__Степень__': '__pow__',
    '__ЛСдвиг__': '__lshift__',
    '__ПСдвиг__': '__rshift__',
    '__ПобитИ__': '__and__',
    '__ПобитЛибо__': '__xor__',
    '__ПобитИли__': '__or__',
    '__АрифмОтр__': '__neg__',
    '__ОдПлюс__': '__pos__',
    '__АбсЗнач__': '__abs__',
    '__ПобитИнв__': '__invert__',
    '__Прав_Сложение__': '__radd__',
    '__Прав_Вычитание__': '__rsub__',
    '__Прав_Умножение__': '__rmul__',
    '__Прав_МатрУмн__': '__rmatmul__',
    '__Прав_Деление__': '__rtruediv__',
    '__Прав_ЦелДел__': '__rfloordiv__',
    '__Прав_Остаток__': '__rmod__',
    '__Прав_ЧастОст__': '__rdivmod__',
    '__Прав_Степень__': '__rpow__',
    '__Прав_ЛСдвиг__': '__rlshift__',
    '__Прав_ПСдвиг__': '__rrshift__',
    '__Прав_И__': '__rand__',
    '__Прав_Либо__': '__rxor__',
    '__Прав_Или__': '__ror__',
    '__Присв_Сложение__': '__iadd__',
    '__Присв_Вычитание__': '__isub__',
    '__Присв_Умножение__': '__imul__',
    '__Присв_МатрУмн__': '__imatmul__',
    '__Присв_Деление__': '__itruediv__',
    '__Присв_ЦелДел__': '__ifloordiv__',
    '__Присв_Остаток__': '__imod__',
    '__Присв_Степень__': '__ipow__',
    '__Присв_ЛСдвиг__': '__ilshift__',
    '__Присв_ПСдвиг__': '__irshift__',
    '__Присв_И__': '__iand__',
    '__Присв_Либо__': '__ixor__',
    '__Присв_Или__': '__ior__',
    '__Компл__': '__complex__',
    '__Цел__': '__int__',
    '__Вещ__': '__float__',
    '__Индекс__': '__index__',
    '__Округлить__': '__round__',
    '__ЦелЧасть__': '__trunc__',
    '__МеньшЦел__': '__floor__',
    '__БольшЦел__': '__ceil__',
    '__Вход__': '__enter__',
    '__Выход__': '__exit__',
    '__Сопоставление_аргументов__': '__match_args__',
    '__Буфер__': '__buffer__',
    '__Освобождение_буфера__': '__release_buffer__',
    '__Слоты__': '__slots__',
    '__Подготовка_подкласса__': '__init_subclass__',
    '__Получение_значения_из_класса__': '__class_getitem__',
    '__Основные_классы__': '__mro_entries__',
    '__Проверка_экземпляра__': '__instancecheck__',
    '__Проверка_подкласса__': '__subclasscheck__',
    '__Экспорт__': '__all__'
}

Исключения = {
    'БазовоеИсключение': 'BaseException',
    'СистемнаяОстановка': 'SystemExit',
    'ПрерываниеКлавиатурой': 'KeyboardInterrupt',
    'ОстановкаГенератора': 'GeneratorExit',
    'ОбщееИсключение': 'Exception',
    'ОстановкаИтерации': 'StopIteration',
    'АрифметическаяОшибка': 'ArithmeticError',
    'ОшибкаПлавающейЗапятой': 'FloatingPointError',
    'ОшибкаПереполнение': 'OverflowError',
    'ОшибкаДелениеНаНоль': 'ZeroDivisionError',
    'ОшибкаПроверки': 'AssertionError',
    'ОшибкаАтрибута': 'AttributeError',
    'ОшибкаБуфера': 'BufferError',
    'ОшибкаКонцаФайла': 'EOFError',
    'ОшибкаИмпорта': 'ImportError',
    'ОшибкаПоиска': 'LookupError',
    'ОшибкаИндекса': 'IndexError',
    'ОшибкаКлюча': 'KeyError',
    'ОшибкаНедостаточноПамяти': 'MemoryError',
    'ОшибкаМодульНеНайден': 'ModuleNotFoundError',
    'ОшибкаНазвания': 'NameError',
    'ОшибкаМестнойПеременной': 'UnboundLocalError',
    'ОшибкаСистемы': 'OSError',
    'ОшибкаБлокВводаВывода': 'BlockingIOError',
    'ОшибкаДочернегоПроцесса': 'ChildProcessError',
    'ОшибкаПодключения': 'ConnectionError',
    'ОшибкаНеработающийКанал': 'BrokenPipeError',
    'ОшибкаСоединениеОтменено': 'ConnectionAbortedError',
    'ОшибкаСоединениеОтклонено': 'ConnectionRefusedError',
    'ОшибкаСоединениеСброшено': 'ConnectionResetError',
    'ОшибкаФайлУжеСуществует': 'FileExistsError',
    'ОшибкаФайлНеНайден': 'FileNotFoundError',
    'ОшибкаПрервано': 'InterruptedError',
    'ОшибкаПапкаВместоФайла': 'IsADirectoryError',
    'ОшибкаФайлВместоПапки': 'NotADirectoryError',
    'ОшибкаПравДоступа': 'PermissionError',
    'ОшибкаПроцессНеНайден': 'ProcessLookupError',
    'ОшибкаВремяВышло': 'TimeoutError',
    'ОшибкаОбращения': 'ReferenceError',
    'ОшибкаВыполнения': 'RuntimeError',
    'ОшибкаМетодНеПереопределён': 'NotImplementedError',
    'СинтаксическаяОшибка': 'SyntaxError',
    'ОшибкаОтступов': 'IndentationError',
    'ОшибкаТабуляции': 'TabError',
    'СистемнаяОшибка': 'SystemError',
    'ОшибкаТипа': 'TypeError',
    'ОшибкаЗначения': 'ValueError',
    'ОшибкаКодованияСимволов': 'UnicodeError',
    'ОшибкаЗакодСимволов': 'UnicodeEncodeError',
    'ОшибкаРаскодСимволов': 'UnicodeDecodeError',
    'ОшибкаПереводаКодСимв': 'UnicodeTranslateError',
    'ОшибкаТокена': 'TokenError',
    'ОбщееПредупреждение': 'Warning',
    'ПредупрУстаревание': 'DeprecationWarning',
    'ПредупрОжидаетсяУстаревание': 'PendingDeprecationWarning',
    'ПредупрОРесурсах': 'ResourceWarning',
    'ПредупрОВыполнении': 'RuntimeWarning',
    'ПредупрОСинтаксисе': 'SyntaxWarning',
    'ПредупрОКодованииСимволов': 'UnicodeWarning',
    'ПредупрОБайтах': 'BytesWarning'
}

def Прочитать_слова(чтение_строки, путь_к_файлу):
    try:
        for тип, название, _, _, строка in Разборщик_слов.generate_tokens(чтение_строки):
            if тип == 5: название = название.replace(' ' * 4, '\t')
            отступов = 0; сч = 0
            while (сч < len(строка) and строка[сч] == '\t'): отступов += 1; сч += 1
            yield тип, название, отступов
    except Exception as ошибка:
        Вывести_текст_исключения(ошибка, 'при чтении кода', путь_к_файлу, True, False)

def Выполнить_основные_замены(слова, соответствия):
    for номер, слово in enumerate(слова):
        if (номер == 0 or (слова[номер - 1][1] != '.' or (номер > 1 and слова[номер - 2][1] in ('.', 'from')))) and \
          слово[0] == 1 and слово[1] in соответствия:
            слова[номер] = (1, соответствия[слово[1]], слово[2])

def Заменить_встроенные_функции(слова, соответствия):
    for номер, слово in enumerate(слова):
        if слово[0] == 1 and слово[1] in соответствия:
            соответствие = соответствия[слово[1]]
            спец_метод = (номер > 2 and слова[номер - 1][1] == '.' and слова[номер - 3][1] == '@')
            if ( \
                (номер == 0 or слова[номер - 1][1] != '.') or спец_метод \
              ) and \
              ( \
                (номер + 1 < len(слова) and слова[номер + 1][1] == '(') or \
                ((номер == 0 or слова[номер - 1][1] == '@') or спец_метод) or \
                соответствие[2] \
              ):
                слова[номер] = (1, соответствие[0], слово[2])
                if соответствие[1] and not соответствие[2] and \
                  номер + 1 < len(слова) and слова[номер + 1][1] == '(':
                    сч = номер + 2
                    скобки = [0, 0, 0]
                    while сч < len(слова):
                        if слова[сч][1] in ['(', '[', '{']: скобки[['(', '[', '{'].index(слова[сч][1])] += 1
                        elif слова[сч][1] in [')', ']', '}']: скобки[[')', ']', '}'].index(слова[сч][1])] -= 1
                        elif sum(скобки) == 0:
                            if слова[сч][1] == ')': break
                            if слова[сч][0] == 1 and слова[сч][1] in соответствие[1] and \
                              сч + 1 < len(слова) and слова[сч + 1][1] == '=':
                                слова[сч] = (1, соответствие[1][слова[сч][1]], слова[сч][2])
                        сч += 1

def Обработать_f_строки(слова, путь_к_файлу):
    номер = 0
    while номер < len(слова):
        if слова[номер][0] == 3 and слова[номер][1].startswith(("f'", 'f"')):
            отступов = слова[номер][2]
            исходная_строка = слова[номер][1]
            префикс = 'f' if исходная_строка.startswith('f') else исходная_строка[0]
            кавычка = исходная_строка[1]
            содержимое = исходная_строка[2:-1] if исходная_строка.endswith(кавычка) else исходная_строка[2:]
            новые_токены = []
            поз = 0
            while поз < len(содержимое):
                if поз + 1 < len(содержимое) and содержимое[поз:поз+2] == '{{':
                    новые_токены.append((3, '{{', отступов))
                    поз += 2
                elif поз + 1 < len(содержимое) and содержимое[поз:поз+2] == '}}':
                    новые_токены.append((3, '}}', отступов))
                    поз += 2
                elif содержимое[поз] == '{':
                    уровень_скобок = 1
                    нач_поз = поз + 1
                    поз += 1
                    while поз < len(содержимое) and уровень_скобок > 0:
                        if содержимое[поз] == '{':
                            уровень_скобок += 1
                        elif содержимое[поз] == '}':
                            уровень_скобок -= 1
                        поз += 1
                    if уровень_скобок != 0:
                        искл = SyntaxError('Незакрытое выражение в f-строке')
                        Вывести_текст_исключения(искл, 'при разборе f-строки', путь_к_файлу, True, False)
                    выражение = содержимое[нач_поз:поз-1]
                    try:
                        токены_выражения = list(Разборщик_слов.generate_tokens(Текстовый_ВВ(выражение).readline))
                        токены_выражения = [(ток.type, ток.string, отступов) for ток in токены_выражения if ток.type != Разборщик_слов.ENDMARKER]
                        Выполнить_основные_замены(токены_выражения, Служебные_слова)
                        Выполнить_основные_замены(токены_выражения, Специальные_названия)
                        Выполнить_основные_замены(токены_выражения, Исключения)
                        Заменить_встроенные_функции(токены_выражения, Встроенные_функции)
                        выражение_текст = Разборщик_слов.untokenize((ток[0], ток[1]) for ток in токены_выражения if ток[0] not in (4, 5, 6)).strip()
                        новые_токены.append((3, '{' + выражение_текст + '}', отступов))
                    except Exception as ошибка:
                        Вывести_текст_исключения(ошибка, 'при разборе выражения в f-строке', путь_к_файлу, True, False)
                else:
                    нач_поз = поз
                    while поз < len(содержимое) and содержимое[поз] not in ['{', '}']:
                        поз += 1
                    if нач_поз != поз:
                        новые_токены.append((3, содержимое[нач_поз:поз], отступов))
            новая_строка = f"f{кавычка}{''.join(ток[1] for ток in новые_токены)}{кавычка}"
            слова[номер] = (3, новая_строка, отступов)
        номер += 1

def Посчитать_номер_строки(слова, позиция):
    переводов = 0
    for сч in range(позиция):
        if слова[сч][1] == '\n': переводов += 1
    return переводов + 1

def Найти_знак_с_учётом_скобок(знак, начало, слова):
    сч = начало
    скобки = [0, 0, 0]
    while сч < len(слова):
        if слова[сч][1] in ['(', '[', '{']: скобки[['(', '[', '{'].index(слова[сч][1])] += 1
        elif слова[сч][1] in [')', ']', '}']: скобки[[')', ']', '}'].index(слова[сч][1])] -= 1
        elif слова[сч][1] == знак and sum(скобки) == 0: break
        сч += 1
    return сч

def Найти_нач_след_блока(поз, слова):
    нач_поз = слова[поз][2]
    while поз < len(слова) and слова[поз][1] != '\n':
        поз += 1
    поз += 1
    while поз < len(слова):
        if слова[поз][1] != '\n' and слова[поз][2] <= нач_поз:
            break
        поз += 1
    while True:
        if (слова[поз][0] == 6 or слова[поз][1] == '\n') and поз > 0 and слова[поз - 1][1] == '\n':
            поз -= 1
        else:
            break
    return поз

def Извлечь_строку_по_номеру_слова(слова, позиция_слова):
    строка = []
    поз = позиция_слова
    while поз > 0 and слова[поз][1] != '\n': поз -= 1
    if слова[поз][1] == '\n': поз += 1
    while поз < len(слова) and слова[поз][1] != '\n':
        строка.append(слова[поз][1])
        поз += 1
    return строка

Временные_файлы = []

def Обработать_импорт(импорт, путь_к_текущему_файлу):
    for название in импорт['перечень']:
        if импорт['источник'] or название not in Система.modules:
            источник = импорт['источник'] if импорт['источник'] else ''
            подъёмов = 0
            if len(источник) > 0:
                while подъёмов < len(источник) and источник[подъёмов] == '.': подъёмов += 1
                источник = источник[подъёмов:]
                if подъёмов == 1: подъёмов = 0
            разделитель = '\\' if Система.platform.startswith('win32') else '/'
            путь = путь_к_текущему_файлу.split(разделитель)
            путь = путь[:len(путь) - подъёмов - 1]
            путь = разделитель.join(путь) + \
                (разделитель + источник.replace('.', разделитель) if len(источник) > 0 else '') + \
                разделитель + название

            def Преобразовать_скрипт(путь, доп_путь = None):
                if путь not in Временные_файлы:
                    код = Преобразовать_код(путь + '.крп')
                    файл = open((путь if not доп_путь else доп_путь) + '.py', mode='w', encoding='utf-8')
                    if not файл:
                        искл = FileNotFoundError('Невозможно открыть файл "' + файл + '".')
                        Вывести_текст_исключения(искл, 'при чтении кода', путь_к_файлу, True, False)
                    файл.write(код)
                    файл.close()
                    Временные_файлы.append(путь if not доп_путь else доп_путь)

            if ОС.path.isfile(путь + '.крп') and not ОС.path.isfile(путь + '.py'):
                Преобразовать_скрипт(путь)
            elif ОС.path.exists(путь):
                for скрипт_пакета in [('__Основа__', '__init__'), ('__Запуск__', '__main__')]:
                    if ОС.path.isfile(путь + разделитель + скрипт_пакета[0] + '.крп'):
                        Преобразовать_скрипт(
                            путь + разделитель + скрипт_пакета[0],
                            путь + разделитель + скрипт_пакета[1]
                        )

def Проверить_соответствие_слов(слова, путь_к_файлу):
    def Вывести_исключение(инструкция):
        искл = SyntaxError('Ошибка употребления инструкции "' + инструкция + '".')
        Вывести_текст_исключения(искл, 'при разборе кода', путь_к_файлу, True, False)

    for сл in ('Подключить', 'Если', 'Иначе'):
        for поз in [i for i, x in enumerate(слова) if x[1] == сл]:
            if поз > 0 and слова[поз - 1][0] not in (4, 5, 6, 61, 65):
                Вывести_исключение(сл); return False
        сл_ = сл.lower()
        for поз in [i for i, x in enumerate(слова) if x[1] == сл_]:
            if поз == 0 or слова[поз - 1][0] in (4, 5, 6, 61, 65):
                Вывести_исключение(сл_); return False

    for поз in [i for i, x in enumerate(слова) if x[1] == 'Вернуть']:
        if поз == len(слова) - 1 or слова[поз + 1][0] in (4, 61, 65):
            Вывести_исключение('Вернуть'); return False

    for поз in [i for i, x in enumerate(слова) if x[1] == 'Возврат']:
        if поз != len(слова) - 1 and слова[поз + 1][0] not in (4, 61, 65):
            Вывести_исключение('Возврат'); return False

    for поз in [i for i, x in enumerate(слова) if x[1] == 'функция']:
        if поз == 0 or слова[поз - 1][1] != 'Асинхр':
            Вывести_исключение('функция'); return False

    return True

Циклы_со_счётчиком = []

def Преобразовать_код(путь_к_файлу):
    try:
        файл = open(путь_к_файлу, 'r', encoding='utf-8')
    except:
        искл = FileNotFoundError('Невозможно открыть файл "' + путь_к_файлу + '".')
        Вывести_текст_исключения(искл, 'при чтении кода', путь_к_файлу, False, False)

    слова = list(Прочитать_слова(файл.readline, путь_к_файлу))
    if not Проверить_соответствие_слов(слова, путь_к_файлу): return

    # Обрабатываем импорты
    импорты = []
    строки_импорта = []
    for поз in [i for i, x in enumerate(слова) if x[1] == 'Подключить' or x[1] == 'подключить']:
        строки_импорта.append(Извлечь_строку_по_номеру_слова(слова, поз))
    for строка in строки_импорта:
        импорт = { 'источник': None, 'перечень': None }
        сч = 0
        if строка[0] == 'Из':
            импорт['источник'] = ''
            сч = 1
            while сч < len(строка) and строка[сч] != 'подключить':
                импорт['источник'] += строка[сч]; сч += 1
        if сч < len(строка):
            сч += 1
            импорт['перечень'] = []; название = ''
            while сч < len(строка):
                if строка[сч] == ',':
                    if название != '': импорт['перечень'].append(название); название = ''
                elif строка[сч] == 'как': сч += 1
                else: название += строка[сч]
                сч += 1
            if название != '': импорт['перечень'].append(название)
        импорты.append(импорт)
    for импорт in импорты: Обработать_импорт(импорт, путь_к_файлу)

    # Выполняем замены
    Выполнить_основные_замены(слова, Служебные_слова)
    Выполнить_основные_замены(слова, Специальные_названия)
    Выполнить_основные_замены(слова, Исключения)
    Заменить_встроенные_функции(слова, Встроенные_функции)
    Обработать_f_строки(слова, путь_к_файлу)

    # Обрабатываем цикл со счётчиком
    сдвиг = 0
    for поз in [i for i, x in enumerate(слова) if x[1] == 'Цикл']:
        поз += len(Циклы_со_счётчиком) * 4
        отступов = слова[поз][2]
        нач_след_блока = Найти_нач_след_блока(поз, слова)
        Циклы_со_счётчиком.append((Посчитать_номер_строки(слова, поз), Посчитать_номер_строки(слова, нач_след_блока)))
        двт_1 = Найти_знак_с_учётом_скобок(':', поз + 1, слова)
        двт_2 = Найти_знак_с_учётом_скобок(':', двт_1 + 1, слова)
        двт_3 = Найти_знак_с_учётом_скобок(':', двт_2 + 1, слова)
        код_объявл_сч = слова[поз + 1 : двт_1]
        код_усл_ост = слова[двт_1 + 1 : двт_2]
        код_изм_сч = слова[двт_2 + 1 : двт_3]
        код_итерации = слова[двт_3 + 1 : нач_след_блока]
        однострочно = len(слова) > двт_3 + 1 and слова[двт_3 + 1][1] != '\n'
        слова = слова[:поз] + код_объявл_сч + \
            [(4, '\n', отступов), (1, 'while', отступов), (54, '(', отступов)] + \
            код_усл_ост + \
            [(54, ')', отступов), (54, ':', отступов)] + \
            ([(4, '\n', отступов)] if однострочно else []) + \
            [(5, '\t' * (отступов + 1), отступов + 1)] + \
            код_итерации + \
            ([(4, '\n', отступов + 1)] if not однострочно else []) + \
            код_изм_сч + \
            ([(4, '\n', отступов + 1)] if однострочно else []) + \
            [(6, '', отступов + 1)] + \
            слова[нач_след_блока:]

    # Обрабатываем цикл с послеусловием
    сдвиг = 0
    for поз in [i for i, x in enumerate(слова) if x[1] == 'Повторять']:
        отступов = слова[поз + сдвиг][2]
        слова[поз + сдвиг] = (1, 'while', отступов)
        слова.insert(поз + сдвиг + 1, (54, '(', отступов))
        слова.insert(поз + сдвиг + 2, (1, 'True', отступов))
        слова.insert(поз + сдвиг + 3, (54, ')', отступов))
        сдвиг += 3
        if поз + сдвиг + 2 < len(слова) and слова[поз + сдвиг + 2][1] != '\n':
            слова.insert(поз + сдвиг + 2, (4, '\n', отступов))
            слова.insert(поз + сдвиг + 3, (5, '\t' * (отступов + 1), отступов + 1))
            сдвиг += 2
            сч = поз + сдвиг + 2

    сдвиг = 0
    for поз in [i for i, x in enumerate(слова) if x[1] == 'До']:
        отступов = слова[поз + сдвиг][2] + 1
        if (поз > 0 and слова[поз + сдвиг - 1][0] == 6):
            del слова[поз + сдвиг - 1]
            сдвиг -= 1
        if (поз > 0 and слова[поз + сдвиг - 1][0] == 5):
            слова[поз + сдвиг - 1] = (5, слова[поз + сдвиг - 1][1] + '\t', отступов)
        слова[поз + сдвиг] = (1, 'if', отступов)
        сч = Найти_знак_с_учётом_скобок('\n', поз + сдвиг + 1, слова)
        слова.insert(сч, (54, ':', отступов))
        слова.insert(сч + 1, (1, 'break', отступов))
        слова.insert(сч + 2, (6, '', отступов - 1))
        сдвиг += 3

    # Обрабатываем проверки существования
    сдвиг = 0
    for поз in [i for i, x in enumerate(слова) if x[1] == '$']:
        отступов = слова[поз + сдвиг][2] + 1
        нач = поз + сдвиг
        кон = нач + 1
        откр_ск = [0, 0, 0]
        while кон < len(слова):
            if слова[кон][1] == '?' and sum(откр_ск) == 0:
                break
            elif (слова[кон][1] == '('): откр_ск[0] += 1
            elif (слова[кон][1] == '['): откр_ск[1] += 1
            elif (слова[кон][1] == '{'): откр_ск[2] += 1
            elif (слова[кон][1] == ')'): откр_ск[0] -= 1
            elif (слова[кон][1] == ']'): откр_ск[1] -= 1
            elif (слова[кон][1] == '}'): откр_ск[2] -= 1
            кон += 1
        if кон < len(слова):
            слова[нач] = (1, '__Проверить_существование__', отступов)
            слова.insert(нач + 1, (54, '(', отступов))
            слова.insert(нач + 2, (54, "'", отступов))
            сдвиг += 2
            тек_сдв = 0
            for сч in range(нач + 3, кон + 2):
                if сч < len(слова):
                    if слова[сч + тек_сдв][1] in ('\\', "'"):
                        слова.insert(сч + тек_сдв, (54, '\\', отступов))
                        тек_сдв += 1
                    elif слова[сч + тек_сдв][0] == 3:
                        заэкр_сл = слова[сч + тек_сдв][1].replace('\\', '\\\\').replace("'", "\\'")
                        слова[сч + тек_сдв] = (3, заэкр_сл, отступов)
            сдвиг += тек_сдв
            if кон + 2 + тек_сдв < len(слова):
                слова[кон + 2 + тек_сдв] = (54, "'", отступов)
                for сч, сл in enumerate([',', 'globals', '(', ')', ',', 'locals', '(', ')']):
                    слова.insert(кон + 2 + тек_сдв + 1 + сч, (54 if len(сл) == 0 else 1, сл, отступов))
                слова.insert(кон + 2 + тек_сдв + 9, (54, ')', отступов))
                сдвиг += 10
        else: break

    # Запускаем разборщик
    исходник = None
    try:
        исходник = Разборщик_слов.untokenize(map(lambda с: (с[0], с[1]), слова))
    except Exception as ошибка:
        Вывести_текст_исключения(ошибка, 'при чтении кода', путь_к_файлу, True, False)

    if исходник:
        исходник = 'import ' + __name__.split('.')[0] + '.__Заголовочный_код__\n\n' + исходник

    return исходник

def Посчитать_физические_строки(путь_к_файлу, логическая_строка):
    try:
        физические_строки = 0
        текущая_логическая = 0
        with open(путь_к_файлу, 'r', encoding='utf-8') as файл:
            продолжение = False
            for строка in файл:
                физические_строки += 1
                строка = строка.rstrip('\n')
                if not продолжение: текущая_логическая += 1
                продолжение = строка.endswith('\\')
                if текущая_логическая >= логическая_строка:
                    return физические_строки
        return физические_строки
    except:
        return логическая_строка

Переводы_ошибок = {
    r".*EOF in multi-line statement.*": r'Неожиданный конец файла при обработке многострочной инструкции.',
    r"name '(\w+)' is not defined": r'Название "\1" не определено.',
    r"unsupported operand type\(s\) for .+: '(\w+)' and '(\w+)'": r'Неподдерживаемая операция между типами "\1" и "\2".',
    r"invalid literal for int\(\) with base \d+: '(.+)'": r'Недопустимое значение "\1" для преобразования в целое число.',
    r"division by zero": r'Деление на ноль.',
    r"list index out of range": r'Индекс за пределами списка.',
    r"'(\w+)' object has no attribute '(\w+)'": r'Объект типа "\1" не имеет атрибута "\2".',
    r"module '(\w+)' has no attribute '(\w+)'": r'Модуль "\1" не имеет атрибута "\2".',
    r"cannot import name '(\w+)' from '(\w+)'": r'Не удалось импортовать "\1" из модуля "\2".',
    r"no such file or directory: '(.+)'": r'Файл или директория "\1" не найдены.',
    r"index (\d+) is out of range": r'Индекс \1 вне допустимого диапазона.',
    r"key '(.+)' not found": r'Ключ "\1" не найден в словаре.',
    r"KeyError: '(.+)'": r'Ключ "\1" отсутствует в словаре.',
    r"invalid syntax\. Perhaps you forgot a comma\?": r'Ошибочный синтаксис. Может быть, вы забыли запятую?',
    r"invalid syntax": r'Синтаксическая ошибка в коде.',
    r"unrecognized token: \"(.+?)\"": r'Неизвестный токен: "\1".',
    r"expected .+, got .+": r'Ожидался один тип данных, получен другой.',
    r"int\(\) argument must be a string, a bytes-like object or a number, not '(\w+)'": r'Аргумент функции "Цел()" должен быть строкой, байтовым объектом или числом, а не "\1".',
    r"IndentationError: expected an indented block": r'Ожидался блок с отступом.',
    r"IndentationError: unindent does not match any outer indentation level": r'Уровень отступа не соответствует внешнему блоку.',
    r"TypeError: (\w+)\(\) takes \d+ positional arguments? but \d+ were given": r'Функция "\1" принимает меньше аргументов, чем было передано.',
    r"'(.+)' is an invalid keyword argument for (.+)": r'"\1" не является верным названием аргумента для "\2".',
    r"(.+) takes exactly one argument \((\d+) given\)": r'"\1" принимает ровно один аргумент (получено \2).',
    r"(.+) takes exactly (\d+) arguments \((\d+) given\)": r'"\1" принимает аргументы в количестве ровно \2 (получено \3).',
    r"(.+) takes at most (\d+) arguments \((\d+) given\)": r'"\1" принимает аргументы в количестве не более \2 (получено \3).',
    r"(.+) takes at least (\d+) arguments \((\d+) given\)": r'"\1" принимает аргументы в количестве не менее \2 (получено \3).',
    r"(.+) takes (\d+) positional argument but (\d+) were given": r'Функция "\1" имеет позиционных аргументов: \2, однако получила: \3.',
    r"ValueError: (.+)": r'Ошибка значения: \1.',
    r"AttributeError: '(\w+)' object is not callable": r'Объект типа "\1" не является вызываемым.',
    r"ImportError: No module named '(\w+)'": r'Ошибка импорта: модуль "\1" не найден.',
    r"FileNotFoundError: \[Errno 2\] No such file or directory: '(.+)'": r'Файл "\1" не найден.',
    r"IndexError: tuple index out of range": r'Индекс за пределами кортежа.',
    r"SyntaxError: unexpected EOF while parsing": r'Неожиданный конец файла при разборе кода.',
    r"ZeroDivisionError: float division by zero": r'Деление числа с плавающей запятой на ноль.',
    r"TypeError: cannot unpack non-iterable (\w+) object": r'Невозможно распаковать неитерируемый объект типа "\1".',
    r"MemoryError": r'Недостаточно памяти для выполнения операции.',
    r"OverflowError: (.+)": r'Переполнение: \1.',
    r"no binding for nonlocal '(.+)' found": r'Не найдена привязка для нелокальной сущности "\1".',
    r"AssertionError": r'Ошибка проверки: условие не выполнено.',
    r"attempted relative import with no known parent package": r'Попытка относительного импорта без известного родительского пакета.',
    r"pop from empty list": r'Извлечение из пустого списка.',
    r"No module named '(.+)'": r'Модуль под названием "\1" не найден.',
    r"unindent does not match any outer indentation level": r'Отступ не соответствует никакому окружающему уровню.',
    r"int too big to convert": r'Число слишком большое для преобразования.',
    r"unexpected indent": r'Неожиданный отступ.',
    r"cannot import name '(.+)' from '(.+)' (unknown location)": r'Невозможно импортовать название "\1" из "\2" (неизвестное расположение).',
    r"(.+) missing (.+) required positional arguments: (.+), and (.+)": r'Для функции "\1" требуется позиционных аргументов: \2 (\3 и \4).',
    r"module '(.+)' has no attribute '(.+)'": r'Модуль "\1" не имеет атрибута "\1".',
    r"string argument without an encoding": r'Строковый аргумент без кодования.'
}

def Очистить_файлы():
    for файл in Временные_файлы:
        ОС.remove(файл + '.py')
        кэш = ОС.path.join(ОС.path.dirname(файл), '__pycache__')
        if ОС.path.exists(кэш): Операции_оболочки.rmtree(кэш)

def Вывести_текст_исключения(исключение, заголовок, путь_к_файлу, с_заголовком = True, добавлен_импорт = False):
    назв_исп_ф = путь_к_файлу.split('\\' if Система.platform.startswith('win32') else '/')[-1]
    сч = 1
    while True:
        try:
            искл = Разборщик_исключений.TracebackException(
                exc_type=type(исключение),
                exc_traceback=исключение.__traceback__,
                exc_value=исключение
              ).stack[-сч]
        except: сч = -1; break
        if искл.filename == назв_исп_ф: break
        сч += 1
    if сч != -1 and искл.filename == назв_исп_ф:
        номер_строки = искл.lineno - (2 if добавлен_импорт else 0)
    else:
        try: номер_строки = исключение.lineno - (2 if добавлен_импорт else 0)
        except: номер_строки = 0

    if номер_строки > 0:
        номер_строки = Посчитать_физические_строки(путь_к_файлу, номер_строки)

    название_исключения = type(исключение).__name__
    if название_исключения in Исключения.values():
        название_исключения = next(к for к, з in Исключения.items() if з == название_исключения)
    if с_заголовком:
        print('\n(!) Исключение "' + название_исключения + '" ' + заголовок)
        print('    в файле "' + путь_к_файлу + '"' + ('.\n' if номер_строки == 0 else ''))
        if номер_строки > 0:
            print('    на строке № ' + str(номер_строки) + '.\n');
    try: текст_исключения = исключение.msg
    except AttributeError: текст_исключения = str(исключение)

    for шаблон, перевод in Переводы_ошибок.items():
        if РегВыр.match(шаблон, текст_исключения):
            текст_исключения = РегВыр.sub(шаблон, перевод, текст_исключения)
            break
    print(('    ' if с_заголовком else '') + str(текст_исключения))

    Очистить_файлы()
    input()
    Система.exit()

def Запустить_код(название, исходник, путь_к_файлу):
    код = None
    try: код = compile(исходник, название, 'exec')
    except Exception as исключение:
        Вывести_текст_исключения(исключение, 'при разборе кода', путь_к_файлу, True, True)
    if код:
        try: Запуск_кода._run_module_code(код, mod_name="__Главный__", script_name=путь_к_файлу)
        except Exception as исключение:
            Вывести_текст_исключения(исключение, 'при выполнении кода', путь_к_файлу, True, True)
    Очистить_файлы()
