import typing as t
from pathlib import Path

NEW_TEMPLATES = ["book", "article", "course", "demo", "hello", "slideshow"]

FORMATS = [
    "html",
    "pdf",
    "latex",
    "epub",
    "kindle",
    "braille",
    "revealjs",
    "webwork",
    "custom",
]

# Give list of assets that each build format requires.  Note that myopenmath must be present for html to generate some other "static" assets, even in html.
ASSETS_BY_FORMAT = {
    "html": [
        "webwork",
        "latex-image",
        "sageplot",
        "asymptote",
        "prefigure",
        "codelens",
        "datafile",
        "myopenmath",
        "dynamic-subs",
    ],
    "pdf": [
        "webwork",
        "sageplot",
        "asymptote",
        "prefigure",
        "youtube",
        "codelens",
        "datafile",
        "interactive",
        "qrcode",
        "mermaid",
        "myopenmath",
        "dynamic-subs",
    ],
    "latex": [
        "webwork",
        "sageplot",
        "asymptote",
        "prefigure",
        "youtube",
        "codelens",
        "datafile",
        "interactive",
        "qrcode",
        "mermaid",
        "myopenmath",
        "dynamic-subs",
    ],
    "epub": [
        "webwork",
        "latex-image",
        "sageplot",
        "asymptote",
        "youtube",
        "codelens",
        "datafile",
        "interactive",
        "qrcode",
        "mermaid",
        "myopenmath",
        "dynamic-subs",
    ],
    "kindle": [
        "webwork",
        "latex-image",
        "sageplot",
        "asymptote",
        "youtube",
        "codelens",
        "datafile",
        "interactive",
        "qrcode",
        "mermaid",
        "myopenmath",
        "dynamic-subs",
    ],
    "braille": [
        "webwork",
        "latex-image",
        "sageplot",
        "asymptote",
        "youtube",
        "codelens",
        "datafile",
        "interactive",
        "mermaid",
        "myopenmath",
        "dynamic-subs",
    ],
    "revealjs": [
        "webwork",
        "latex-image",
        "sageplot",
        "asymptote",
        "prefigure",
        "codelens",
        "datafile",
        "myopenmath",
    ],
    "webwork": [
        "webwork",
    ],
    "custom": [
        "webwork",
        "latex-image",
        "sageplot",
        "asymptote",
        "prefigure",
        "youtube",
        "codelens",
        "datafile",
        "interactive",
        "qrcode",
        "mermaid",
        "myopenmath",
        "dynamic-subs",
    ],
}

ASSET_TO_XPATH = {
    "webwork": ".//webwork[*|@*]",
    "latex-image": ".//latex-image",
    "sageplot": ".//sageplot",
    "asymptote": ".//asymptote",
    "prefigure": ".//pf:prefigure",
    "youtube": ".//video[@youtube]",
    "codelens": ".//program[@interactive = 'codelens']",
    "datafile": ".//datafile",
    "interactive": ".//interactive",
    "qrcode": ".//audio[@source|@href]|.//video[@source|@href|@youtube|@youtubeplaylist|@vimeo]|.//interactive",
    "mermaid": ".//mermaid",
    "myopenmath": ".//myopenmath",
    "dynamic-subs": ".//statement[.//fillin and ancestor::exercise/evaluation]",
}
ASSETS = ["ALL"] + list(ASSET_TO_XPATH.keys())

ASSET_TO_DIR = {
    "webwork": ["webwork"],
    "latex-image": ["latex-image"],
    "sageplot": ["sageplot"],
    "asymptote": ["asymptote"],
    "prefigure": ["prefigure"],
    "youtube": ["youtube", "play-button"],
    "interactive": ["preview"],
    "qrcode": ["qrcode"],
    "codelens": ["trace"],
    "datafile": ["datafile"],
    "mermaid": ["mermaid"],
    "myopenmath": ["problems"],
    "dynamic-subs": ["dynamic_subs"],
}

ASSET_FORMATS: t.Dict[str, t.Dict[str, t.List[str]]] = {
    "pdf": {
        "asymptote": ["pdf"],
        "latex-image": [],
        "sageplot": ["pdf", "png"],
        "prefigure": ["pdf"],
    },
    "latex": {
        "asymptote": ["pdf"],
        "latex-image": [],
        "sageplot": ["pdf", "png"],
        "prefigure": ["pdf"],
    },
    "html": {
        "asymptote": ["html"],
        "latex-image": ["svg"],
        "sageplot": ["html", "svg"],
        "prefigure": ["svg"],
    },
    "runestone": {
        "asymptote": ["html"],
        "latex-image": ["svg"],
        "sageplot": ["html", "svg"],
        "prefigure": ["svg"],
    },
    "epub": {
        "asymptote": ["svg"],
        "latex-image": ["svg"],
        "sageplot": ["svg"],
        "prefigure": ["svg"],
    },
    "kindle": {
        "asymptote": ["png"],
        "latex-image": ["png"],
        "sageplot": ["png"],
        "prefigure": ["png"],
    },
    "braille": {
        "asymptote": ["all"],
        "latex-image": ["all"],
        "sageplot": ["all"],
    },
    "revealjs": {
        "asymptote": ["html"],
        "latex-image": ["svg"],
        "sageplot": ["html", "svg"],
        "prefigure": ["svg"],
    },
    "webwork": {
        "asymptote": [],
        "latex-image": [],
        "sageplot": [],
    },
    "custom": {
        "asymptote": ["all"],
        "latex-image": ["all"],
        "sageplot": ["all"],
        "prefigure": ["all"],
    },
}

PROJECT_RESOURCES = {
    "project.ptx": Path("project.ptx"),
    "codechat_config.yaml": Path("codechat_config.yaml"),
    ".gitignore": Path(".gitignore"),
    "devcontainer.json": Path(".devcontainer/devcontainer.json"),
    "requirements.txt": Path("requirements.txt"),
    "pretext-cli.yml": Path(".github", "workflows", "pretext-cli.yml"),
    "pretext-deploy.yml": Path(".github", "workflows", "pretext-deploy.yml"),
    "installPandoc.sh": Path(".devcontainer", "installPandoc.sh"),
    "installSage.sh": Path(".devcontainer", "installSage.sh"),
}

DEPRECATED_PROJECT_RESOURCES = {
    "deploy.yml": Path(".github", "workflows", "deploy.yml"),
    "test-build.yml": Path(".github", "workflows", "test-build.yml"),
    ".devcontainer.json": Path(".devcontainer.json"),
    "installPretext": Path(".devcontainer", "installPretext"),
    "installLatex": Path(".devcontainer", "installLatex"),
}

GIT_RESOURCES = [
    ".gitignore",
    "pretext-cli.yml",
    "pretext-deploy.yml",
    "devcontainer.json",
    "installPandoc.sh",
    "installSage.sh",
]
