# -*- coding: utf-8 -*-
"""Benchmark functionality."""
from .benchmark import benchmark

from .bench_grouping import bench_groupbyhash, bench_groupbylex, bench_groupbypack
from .bench_merge import (
    bench_merge,
    bench_merge2,
    bench_merge2_with_settings,
    bench_merge_pandas,
    compare_merge,
)
from .bench_numpy import (
    benchmark_binary,
    benchmark_reduce,
    benchmark_unary,
    bench_rt_all,
    bench_rt_all_with_nan,
    bench_rt_any,
    bench_rt_any_with_nan,
    bench_rt_arange,
    bench_rt_argmax,
    bench_rt_argmin,
    bench_rt_argsort,
    bench_rt_lexsort_ordered,
    bench_rt_lexsort_reversed,
    bench_rt_sum,
    bench_rt_max,
    bench_rt_min,
    bench_rt_std,
    bench_rt_add,
    bench_rt_minimum,
    bench_rt_nanmax,
    bench_rt_nanmin,
    bench_rt_nansum,
    bench_rt_true_divide,
    bench_rt_isnan,
    bench_rt_trunc,
    bench_rt_sqrt,
    bench_rt_mean,
    bench_rt_nanmean,
    bench_rt_median,
    bench_rt_nanmedian,
    bench_rt_percentile,
    bench_rt_nanpercentile,
    bench_rt_var,
    bench_rt_nanvar,
    bench_rt_nanstd,
    compare_all,
    compare_all_with_nan,
    compare_any,
    compare_any_with_nan,
    compare_argmax,
    compare_argmin,
    compare_lexsort,
    compare_sum,
    compare_max,
    compare_min,
    compare_std,
    compare_add,
    compare_mean,
    compare_median,
    compare_minimum,
    compare_percentile,
    compare_true_divide,
    compare_isnan,
    compare_trunc,
    compare_sqrt,
    compare_var,
    compare_numpy_reduce,
    compare_numpy_binary,
    compare_numpy_unary,
)
from .bench_primops import (
    bench_mbget,
    bench_mbget_numba,
    bench_astype,
    bench_astype_numba,
    bench_compare_ops,
    compare_mbget,
    compare_astype,
    compare_compare_ops,
    bench_compare_ops_numpy,
    bench_bool_index,
)
from .bench_categorical import bench_singlekey_cat_isin, bench_multikey_cat_isin


__all__ = [
    "benchmark",
    "benchmark_binary",
    "benchmark_reduce",
    "benchmark_unary",
    "bench_groupbyhash",
    "bench_groupbylex",
    "bench_groupbypack",
    "bench_mbget",
    "bench_mbget_numba",
    "bench_astype",
    "bench_astype_numba",
    "bench_compare_ops",
    "bench_compare_ops_numpy",
    "compare_mbget",
    "compare_astype",
    "compare_compare_ops",
    "bench_bool_index",
    "bench_merge",
    "bench_merge2",
    "bench_merge2_with_settings",
    "bench_merge_pandas",
    "bench_singlekey_cat_isin",
    "bench_multikey_cat_isin",
    "bench_rt_all",
    "bench_rt_all_with_nan",
    "bench_rt_any",
    "bench_rt_any_with_nan",
    "bench_rt_arange",
    "bench_rt_argmax",
    "bench_rt_argmin",
    "bench_rt_argsort",
    "bench_rt_lexsort_ordered",
    "bench_rt_lexsort_reversed",
    "bench_rt_sum",
    "bench_rt_max",
    "bench_rt_min",
    "bench_rt_std",
    "bench_rt_add",
    "bench_rt_minimum",
    "bench_rt_nanmax",
    "bench_rt_nanmin",
    "bench_rt_nansum",
    "bench_rt_true_divide",
    "bench_rt_isnan",
    "bench_rt_trunc",
    "bench_rt_sqrt",
    "bench_rt_mean",
    "bench_rt_nanmean",
    "bench_rt_median",
    "bench_rt_nanmedian",
    "bench_rt_percentile",
    "bench_rt_nanpercentile",
    "bench_rt_var",
    "bench_rt_nanvar",
    "bench_rt_nanstd",
    "compare_all",
    "compare_all_with_nan",
    "compare_any",
    "compare_any_with_nan",
    "compare_argmax",
    "compare_argmin",
    "compare_lexsort",
    "compare_merge",
    "compare_sum",
    "compare_max",
    "compare_min",
    "compare_std",
    "compare_add",
    "compare_mean",
    "compare_median",
    "compare_minimum",
    "compare_true_divide",
    "compare_isnan",
    "compare_trunc",
    "compare_sqrt",
    "compare_var",
    "compare_numpy_reduce",
    "compare_numpy_binary",
    "compare_numpy_unary",
]
