# Generated by Django 2.1.4 on 2018-12-14 13:23

import django.contrib.gis.db.models.fields
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import mds.models
import rest_framework.utils.encoders
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Area",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, primary_key=True, serialize=False
                    ),
                ),
                ("provider", models.UUIDField()),
                ("begin_date", models.DateTimeField()),
                ("end_date", models.DateTimeField(null=True)),
                (
                    "polygon",
                    django.contrib.gis.db.models.fields.PolygonField(srid=4326),
                ),
                (
                    "properties",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        default=dict, encoder=rest_framework.utils.encoders.JSONEncoder
                    ),
                ),
            ],
            options={"abstract": False},
        ),
        migrations.CreateModel(
            name="Device",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, primary_key=True, serialize=False
                    ),
                ),
                ("identification_number", mds.models.UnboundedCharField()),
                ("model", mds.models.UnboundedCharField(default=str)),
                (
                    "category",
                    mds.models.UnboundedCharField(
                        choices=[
                            ("bike", "Bike"),
                            ("scooter", "Scooter"),
                            ("car", "Car"),
                        ]
                    ),
                ),
                (
                    "propulsion",
                    mds.models.UnboundedCharField(
                        choices=[("electric", "Electric"), ("combustion", "Combustion")]
                    ),
                ),
                (
                    "registration_date",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                (
                    "properties",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        default=dict, encoder=rest_framework.utils.encoders.JSONEncoder
                    ),
                ),
            ],
        ),
        migrations.CreateModel(
            name="Provider",
            fields=[
                (
                    "id",
                    models.UUIDField(
                        default=uuid.uuid4, primary_key=True, serialize=False
                    ),
                ),
                ("name", mds.models.UnboundedCharField(default=str)),
            ],
        ),
        migrations.CreateModel(
            name="Telemetry",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("provider", models.UUIDField()),
                ("timestamp", models.DateTimeField(db_index=True)),
                (
                    "status",
                    mds.models.UnboundedCharField(
                        choices=[
                            ("available", "Available"),
                            ("reserved", "Reserved"),
                            ("unavailable", "Unavailable"),
                            ("removed", "Removed"),
                        ]
                    ),
                ),
                (
                    "point",
                    django.contrib.gis.db.models.fields.PointField(
                        null=True, srid=4326
                    ),
                ),
                (
                    "properties",
                    django.contrib.postgres.fields.jsonb.JSONField(
                        default=dict, encoder=rest_framework.utils.encoders.JSONEncoder
                    ),
                ),
                (
                    "device",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="telemetries",
                        to="mds.Device",
                    ),
                ),
            ],
            options={"verbose_name_plural": "telemetries"},
        ),
        migrations.AddField(
            model_name="device",
            name="provider",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="devices",
                to="mds.Provider",
            ),
        ),
    ]
