# Generated by Django 2.1.4 on 2018-12-11 16:31

import django.contrib.gis.db.models.fields
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.utils.timezone
import mds.models
import rest_framework.utils.encoders
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('mds', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Polygon',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('creation_date', models.DateTimeField(default=django.utils.timezone.now)),
                ('deletion_date', models.DateTimeField(null=True)),
                ('label', mds.models.UnboundedCharField(null=True)),
                ('geom', django.contrib.gis.db.models.fields.PolygonField(srid=4326)),
                ('properties', django.contrib.postgres.fields.jsonb.JSONField(default=dict, encoder=rest_framework.utils.encoders.JSONEncoder)),
            ],
        ),
        migrations.AlterModelOptions(
            name='telemetry',
            options={'verbose_name_plural': 'telemetries'},
        ),
        migrations.RenameField(
            model_name='area',
            old_name='end_date',
            new_name='deletion_date',
        ),
        migrations.RemoveField(
            model_name='area',
            name='begin_date',
        ),
        migrations.RemoveField(
            model_name='area',
            name='polygon',
        ),
        migrations.RemoveField(
            model_name='area',
            name='properties',
        ),
        migrations.RemoveField(
            model_name='area',
            name='provider',
        ),
        migrations.AddField(
            model_name='area',
            name='creation_date',
            field=models.DateTimeField(default=django.utils.timezone.now),
        ),
        migrations.AddField(
            model_name='area',
            name='label',
            field=mds.models.UnboundedCharField(null=True),
        ),
        migrations.AddField(
            model_name='area',
            name='polygons',
            field=models.ManyToManyField(blank=True, related_name='areas', to='mds.Polygon'),
        ),
    ]
