// Import the LabIcon class from JupyterLab UI components
import { LabIcon } from '@jupyterlab/ui-components';

// Define the SVG string for the Voitta icon
const voittaSvgStr = `
<svg viewBox="0 0 400 400" xmlns="http://www.w3.org/2000/svg">
  <!-- Background circle with gradient -->
  <defs>
    <linearGradient id="bg-grad" x1="0%" y1="0%" x2="100%" y2="100%">
      <stop offset="0%" stop-color="#2563EB" />
      <stop offset="100%" stop-color="#1E40AF" />
    </linearGradient>
  </defs>
  <circle cx="200" cy="200" r="200" fill="url(#bg-grad)" />
  
  <!-- Inner circle -->
  <circle cx="200" cy="200" r="180" fill="#1E3A8A" />
  
  <!-- Connected hexagons representing different systems -->
  <g transform="translate(200, 200)">
    <!-- Center hexagon -->
    <polygon points="0,-40 34.6,-20 34.6,20 0,40 -34.6,20 -34.6,-20" 
             fill="#3B82F6" stroke="#BFDBFE" stroke-width="2" />
    
    <!-- Outer hexagons -->
    <polygon points="0,-100 34.6,-80 34.6,-40 0,-20 -34.6,-40 -34.6,-80" 
             fill="#2563EB" stroke="#BFDBFE" stroke-width="1.5" />
    
    <polygon points="69.2,-40 103.8,-20 103.8,20 69.2,40 34.6,20 34.6,-20" 
             fill="#2563EB" stroke="#BFDBFE" stroke-width="1.5" />
    
    <polygon points="69.2,40 103.8,60 103.8,100 69.2,120 34.6,100 34.6,60" 
             fill="#2563EB" stroke="#BFDBFE" stroke-width="1.5" />
    
    <polygon points="0,40 34.6,60 34.6,100 0,120 -34.6,100 -34.6,60" 
             fill="#2563EB" stroke="#BFDBFE" stroke-width="1.5" />
    
    <polygon points="-69.2,40 -34.6,60 -34.6,100 -69.2,120 -103.8,100 -103.8,60" 
             fill="#2563EB" stroke="#BFDBFE" stroke-width="1.5" />
    
    <polygon points="-69.2,-40 -34.6,-20 -34.6,20 -69.2,40 -103.8,20 -103.8,-20" 
             fill="#2563EB" stroke="#BFDBFE" stroke-width="1.5" />
    
    <!-- Connection lines -->
    <line x1="0" y1="-40" x2="0" y2="-20" stroke="#93C5FD" stroke-width="3" />
    <line x1="34.6" y1="20" x2="34.6" y2="60" stroke="#93C5FD" stroke-width="3" />
    <line x1="34.6" y1="-20" x2="69.2" y2="-40" stroke="#93C5FD" stroke-width="3" />
    <line x1="0" y1="40" x2="0" y2="60" stroke="#93C5FD" stroke-width="3" />
    <line x1="-34.6" y1="20" x2="-34.6" y2="60" stroke="#93C5FD" stroke-width="3" />
    <line x1="-34.6" y1="-20" x2="-69.2" y2="-40" stroke="#93C5FD" stroke-width="3" />
    
    <!-- Data flow indicators -->
    <circle cx="0" cy="-30" r="3" fill="#DBEAFE" />
    <circle cx="34.6" cy="40" r="3" fill="#DBEAFE" />
    <circle cx="51.9" cy="-30" r="3" fill="#DBEAFE" />
    <circle cx="0" cy="50" r="3" fill="#DBEAFE" />
    <circle cx="-34.6" cy="40" r="3" fill="#DBEAFE" />
    <circle cx="-51.9" cy="-30" r="3" fill="#DBEAFE" />
  </g>
  
  <!-- Subtle outer ring -->
  <circle cx="200" cy="200" r="170" fill="none" stroke="#60A5FA" stroke-width="1" stroke-dasharray="3,6" />
  
  <!-- Central AI core indicator -->
  <circle cx="200" cy="200" r="15" fill="#DBEAFE" />
  <circle cx="200" cy="200" r="8" fill="#3B82F6" />
</svg>
`;

// Create a smaller version for the launcher icon
const voittaLauncherSvgStr = `
<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16">
  <circle cx="8" cy="8" r="8" fill="#2563EB" />
  <circle cx="8" cy="8" r="7" fill="#1E3A8A" />
  <polygon points="8,4 10.4,6 10.4,10 8,12 5.6,10 5.6,6" fill="#3B82F6" stroke="#BFDBFE" stroke-width="0.2" />
  <circle cx="8" cy="8" r="1" fill="#DBEAFE" />
</svg>
`;

// Export the Voitta icon with sidebar styling
export const voittaIcon = new LabIcon({
  name: 'escobar:voitta-icon',
  svgstr: voittaSvgStr
}).bindprops({
  stylesheet: 'sideBar'
});

// Export the Voitta launcher icon with menu item styling
export const voittaLauncherIcon = new LabIcon({
  name: 'escobar:voitta-launcher-icon',
  svgstr: voittaLauncherSvgStr
}).bindprops({
  stylesheet: 'menuItem'
});
