from collections.abc import Iterator
from typing import Generic
from typing_extensions import TypeVar

import optype as op

_T = TypeVar("_T", bound=op.CanHash, default=object)

class DisjointSet(Generic[_T]):
    n_subsets: int

    def __init__(self, /, elements: _T | None = None) -> None: ...
    def __iter__(self, /) -> Iterator[_T]: ...
    def __len__(self, /) -> int: ...
    def __contains__(self, x: object, /) -> bool: ...
    def __getitem__(self, x: _T, /) -> int: ...
    def add(self, /, x: _T) -> None: ...
    def merge(self, /, x: _T, y: _T) -> bool: ...
    def connected(self, /, x: _T, y: _T) -> bool: ...
    def subset(self, /, x: _T) -> set[_T]: ...
    def subset_size(self, /, x: _T) -> int: ...
    def subsets(self, /) -> list[set[_T]]: ...
