from typing import Final, Literal, NamedTuple, type_check_only

__all__ = ["VERSION_PATTERN", "InvalidVersion", "LegacyVersion", "Version", "parse"]

@type_check_only
class _InfinityType:
    def __lt__(self, other: object, /) -> Literal[False]: ...
    def __le__(self, other: object, /) -> Literal[False]: ...
    def __gt__(self, other: object, /) -> Literal[True]: ...
    def __ge__(self, other: object, /) -> Literal[True]: ...
    def __neg__(self, /) -> _NegativeInfinityType: ...

@type_check_only
class _NegativeInfinityType:
    def __lt__(self, other: object, /) -> Literal[True]: ...
    def __le__(self, other: object, /) -> Literal[True]: ...
    def __gt__(self, other: object, /) -> Literal[False]: ...
    def __ge__(self, other: object, /) -> Literal[False]: ...
    def __neg__(self, /) -> _InfinityType: ...

@type_check_only
class _VersionMixin:
    def __init__(self, /, version: str) -> None: ...
    @property
    def public(self, /) -> str: ...
    @property
    def base_version(self, /) -> str: ...
    @property
    def local(self, /) -> str: ...
    @property
    def is_prerelease(self, /) -> bool: ...
    @property
    def is_postrelease(self, /) -> bool: ...

###

VERSION_PATTERN: Final[str] = ...

Infinity: Final[_InfinityType] = ...
NegativeInfinity: Final[_NegativeInfinityType] = ...

class InvalidVersion(ValueError): ...

class _Version(NamedTuple):
    epoch: int
    release: tuple[int, ...]
    dev: tuple[str, int]
    pre: tuple[str, int]
    post: tuple[str, int]
    local: tuple[str | int, ...]

class _BaseVersion:
    def __lt__(self, other: _BaseVersion, /) -> bool: ...
    def __le__(self, other: _BaseVersion, /) -> bool: ...
    def __ge__(self, other: _BaseVersion, /) -> bool: ...
    def __gt__(self, other: _BaseVersion, /) -> bool: ...

class LegacyVersion(_VersionMixin, _BaseVersion): ...
class Version(_VersionMixin, _BaseVersion): ...

def parse(version: str) -> Version | LegacyVersion: ...
