import io
from collections.abc import Iterable, Mapping
from typing import IO, Final, Literal, TypeAlias, TypedDict, final, type_check_only

import numpy as np
import optype.numpy as onp
import optype.numpy.compat as npc

from ._miobase import MatFileReader
from scipy._typing import AnyShape
from scipy.io._typing import ByteOrder
from scipy.sparse import sparray, spmatrix

_OnedAs: TypeAlias = Literal["row", "column"]

@type_check_only
class _MatFile5Header(TypedDict):
    __header__: str
    __version__: str

###

NDT_FILE_HDR: Final[np.dtype[np.void]] = ...
NDT_TAG_FULL: Final[np.dtype[np.void]] = ...
NDT_TAG_SMALL: Final[np.dtype[np.void]] = ...
NDT_ARRAY_FLAGS: Final[np.dtype[np.void]] = ...

@final
class EmptyStructMarker: ...

class MatFile5Reader(MatFileReader):
    uint16_codec: Final[str]

    def __init__(
        self,
        /,
        mat_stream: IO[bytes],
        byte_order: ByteOrder | None = None,
        mat_dtype: bool = False,
        squeeze_me: bool = False,
        chars_as_strings: bool = True,
        matlab_compatible: bool = False,
        struct_as_record: bool = True,
        verify_compressed_data_integrity: bool = True,
        uint16_codec: str | None = None,
        simplify_cells: bool = False,
    ) -> None: ...
    def read_file_header(self, /) -> _MatFile5Header: ...
    def initialize_read(self, /) -> None: ...
    def read_var_header(self, /) -> tuple[object, int]: ...
    def read_var_array(self, /, header: Mapping[str, object], process: bool = True) -> onp.Array: ...
    def get_variables(self, /, variable_names: Iterable[str] | None = None) -> dict[str, str | list[str] | onp.Array]: ...
    def list_variables(self, /) -> list[tuple[str, tuple[int, ...], str]]: ...

class VarWriter5:
    mat_tag: onp.Array
    file_stream: IO[bytes]
    unicode_strings: bool
    long_field_names: bool
    oned_as: _OnedAs

    def __init__(self, /, file_writer: MatFile5Writer) -> None: ...
    def write_bytes(self, /, arr: onp.Array) -> None: ...
    def write_string(self, /, s: str) -> None: ...
    def write_element(self, /, arr: onp.Array, mdtype: int | None = None) -> None: ...
    def write_smalldata_element(self, /, arr: onp.Array, mdtype: int, byte_count: int) -> None: ...
    def write_regular_element(self, /, arr: onp.Array, mdtype: int, byte_count: int) -> None: ...
    def write_header(
        self, /, shape: AnyShape, mclass: int, is_complex: bool = False, is_logical: bool = False, nzmax: int = 0
    ) -> None: ...
    def update_matrix_tag(self, /, start_pos: int) -> None: ...
    def write_top(self, /, arr: onp.ToArrayND, name: str, is_global: bool) -> None: ...
    def write(self, /, arr: onp.ToArrayND) -> None: ...
    def write_numeric(self, /, arr: onp.ArrayND[np.bool_ | npc.number]) -> None: ...
    def write_char(self, /, arr: onp.ArrayND[np.str_], codec: str = "ascii") -> None: ...
    def write_sparse(self, /, arr: spmatrix | sparray) -> None: ...
    def write_cells(self, /, arr: onp.Array) -> None: ...
    def write_empty_struct(self, /) -> None: ...
    def write_struct(self, /, arr: onp.ArrayND[np.void]) -> None: ...
    def write_object(self, /, arr: onp.ArrayND[np.object_]) -> None: ...

class MatFile5Writer:
    file_stream: IO[bytes]
    do_compression: bool
    unicode_strings: bool
    global_vars: list[str] | tuple[str, ...]
    long_field_names: bool
    oned_as: _OnedAs

    def __init__(
        self,
        /,
        file_stream: IO[bytes],
        do_compression: bool = False,
        unicode_strings: bool = False,
        global_vars: list[str] | tuple[str, ...] | None = None,
        long_field_names: bool = False,
        oned_as: _OnedAs = "row",
    ) -> None: ...
    def write_file_header(self, /) -> None: ...
    def put_variables(self, /, mdict: Mapping[str, onp.Array], write_header: bool | None = None) -> None: ...

def varmats_from_mat(file_obj: IO[bytes]) -> list[tuple[str, io.BytesIO]]: ...
def to_writeable(source: object) -> onp.Array | type[EmptyStructMarker] | None: ...
