from typing import Any, ClassVar, Final, Literal, Protocol, type_check_only
from typing_extensions import CapsuleType

@type_check_only
class _FileLike(Protocol):
    def read(self, size: int, /) -> bytes: ...
    def tell(self, /) -> int: ...
    def seek(self, offset: int, whence: int = 0, /) -> int | None: ...

###

BLOCK_SIZE: Final = 131072  # undocumented

__pyx_capi__: Final[dict[str, CapsuleType]] = ...  # undocumented

class GenericStream:  # undocumented
    __pyx_vtable__: ClassVar[CapsuleType] = ...

    fobs: Final[_FileLike]

    def __init__(self, /, fobj: _FileLike) -> None: ...
    def seek(self, /, offset: int, whence: int = 0) -> Literal[0, -1]: ...
    def tell(self, /) -> int: ...
    def read(self, /, n_bytes: int) -> bytes: ...
    def all_data_read(self, /) -> Literal[1]: ...
    def __reduce_cython__(self) -> tuple[Any, ...]: ...
    def __setstate_cython__(self, /, state: tuple[object, ...]) -> None: ...

class ZlibInputStream(GenericStream):  # undocumented
    def __init__(self, /, fobj: _FileLike, max_length: int) -> None: ...

def _read_into(st: GenericStream, n: int) -> bytes: ...  # undocumented
def _read_string(st: GenericStream, n: int) -> bytes: ...  # undocumented
def make_stream(fobj: GenericStream | _FileLike) -> GenericStream: ...  # undocumented
