from collections.abc import Callable
from typing import Any, Final, Literal, TypeAlias, TypeVar, overload
from typing_extensions import deprecated

import numpy as np
import optype.numpy as onp
import optype.numpy.compat as npc

from ._expm_frechet import expm_cond, expm_frechet

__all__ = [
    "coshm",
    "cosm",
    "expm",
    "expm_cond",
    "expm_frechet",
    "fractional_matrix_power",
    "funm",
    "khatri_rao",
    "logm",
    "signm",
    "sinhm",
    "sinm",
    "sqrtm",
    "tanhm",
    "tanm",
]

_InexactT = TypeVar("_InexactT", bound=npc.inexact)
_ComplexT = TypeVar("_ComplexT", bound=npc.complexfloating)
_ShapeT = TypeVar("_ShapeT", bound=tuple[int, ...])

_FuncND: TypeAlias = Callable[[onp.Array[Any, _InexactT]], onp.ToComplexND]  # return type is unsafely cast to the input type

_ToPosInt: TypeAlias = npc.unsignedinteger | Literal[0, 1, 2, 4, 5, 6, 7, 8]

_IntND: TypeAlias = onp.ArrayND[npc.integer]
_Float64ND: TypeAlias = onp.ArrayND[np.float64]
_FloatND: TypeAlias = onp.ArrayND[npc.floating]
_Complex128ND: TypeAlias = onp.ArrayND[np.complex128]
_ComplexND: TypeAlias = onp.ArrayND[npc.complexfloating]
_InexactND: TypeAlias = onp.ArrayND[npc.inexact]

_AsFloat64ND: TypeAlias = onp.ToArrayND[float, np.float64 | npc.integer | np.bool_]

###

eps: Final[np.float64] = ...  # undocumented
feps: Final[np.float32] = ...  # undocumented
_array_precision: Final[dict[Literal["i", "l", "f", "d", "F", "D"], Literal[0, 1]]] = ...  # undocumented

def _asarray_square(A: onp.ToArray2D[_InexactT]) -> onp.Array2D[_InexactT]: ...  # undocumented

#
@overload
def _maybe_real(
    A: onp.ArrayND[npc.inexact], B: onp.ArrayND[npc.inexact64, _ShapeT], tol: float | None = None
) -> onp.ArrayND[np.float64, _ShapeT]: ...  # undocumented
@overload
def _maybe_real(
    A: onp.ArrayND[npc.inexact], B: onp.ArrayND[npc.inexact32, _ShapeT], tol: float | None = None
) -> onp.ArrayND[np.float32, _ShapeT]: ...  # undocumented

#
@overload  # +integer, +unsignedinteger
def fractional_matrix_power(A: onp.ToIntND, t: _ToPosInt) -> _IntND: ...
@overload  # ~float64, +integer
def fractional_matrix_power(A: onp.ToJustFloat64_ND, t: onp.ToInt) -> _Float64ND: ...
@overload  # ~floating, +integer
def fractional_matrix_power(A: onp.ToJustFloatND, t: onp.ToInt) -> _FloatND: ...
@overload  # ~complex128, +float64
def fractional_matrix_power(A: onp.ToJustComplex128_ND, t: onp.ToFloat64) -> _Complex128ND: ...
@overload  # +complex128, ~float64
def fractional_matrix_power(A: onp.ToComplex128_ND, t: onp.ToJustFloat64) -> _Complex128ND: ...
@overload  # +complexfloating, ~float
def fractional_matrix_power(A: onp.ToComplexND, t: onp.ToJustFloat) -> _ComplexND: ...
@overload  # +complex, +floating
def fractional_matrix_power(A: onp.ToComplexND, t: onp.ToFloat) -> onp.ArrayND[Any]: ...

#
@overload
def sqrtm(A: _AsFloat64ND) -> _Float64ND: ...
@overload
def sqrtm(A: onp.ToFloatND) -> _FloatND: ...
@overload
def sqrtm(A: onp.ToJustComplex128_ND) -> _Complex128ND: ...
@overload
def sqrtm(A: onp.ToJustComplexND) -> _ComplexND: ...
@overload
def sqrtm(A: onp.ToComplexND) -> _InexactND: ...
@overload
@deprecated("The `disp` argument is deprecated and will be removed in SciPy 1.18.0.")
def sqrtm(A: onp.ToComplexND, disp: onp.ToTrue) -> _InexactND: ...
@overload
@deprecated("The `disp` argument is deprecated and will be removed in SciPy 1.18.0.")
def sqrtm(A: onp.ToComplexND, disp: onp.ToFalse) -> tuple[_InexactND, np.float64]: ...
@overload
@deprecated("The `blocksize` argument is deprecated and will be removed in SciPy 1.18.0.")
def sqrtm(A: onp.ToComplexND, *, blocksize: int) -> _InexactND: ...
@overload
@deprecated("The `blocksize` argument is deprecated and will be removed in SciPy 1.18.0.")
@deprecated("The `disp` argument is deprecated and will be removed in SciPy 1.18.0.")
def sqrtm(A: onp.ToComplexND, disp: onp.ToTrue, blocksize: int) -> _InexactND: ...
@overload
@deprecated("The `blocksize` argument is deprecated and will be removed in SciPy 1.18.0.")
@deprecated("The `disp` argument is deprecated and will be removed in SciPy 1.18.0.")
def sqrtm(A: onp.ToComplexND, disp: onp.ToFalse, blocksize: int) -> tuple[_InexactND, np.float64]: ...

# NOTE: return dtype depends on the sign of the values
@overload  # +integer | ~float64
def logm(A: _AsFloat64ND) -> _Float64ND | _Complex128ND: ...
@overload  # +floating
def logm(A: onp.ToFloatND) -> _InexactND: ...
@overload  # ~complex128
def logm(A: onp.ToJustComplex128_ND) -> _Complex128ND: ...
@overload  # ~complexfloating
def logm(A: onp.ToJustComplexND) -> _ComplexND: ...
@overload  # +complexfloating
def logm(A: onp.ToComplexND) -> _InexactND: ...
@overload  # +complexfloating, disp=True  (deprecated)
@deprecated("The `disp` argument is deprecated and will be removed in SciPy 1.18.0.")
def logm(A: onp.ToComplexND, disp: onp.ToTrue) -> _InexactND: ...
@overload  # +complexfloating, disp=False  (deprecated)
@deprecated(
    "The `disp` argument is deprecated and will be removed in SciPy 1.18.0. "
    "The previously returned error estimate can be computed as `norm(expm(logm(A)) - A, 1) / norm(A, 1)`."
)
def logm(A: onp.ToComplexND, disp: onp.ToFalse) -> tuple[_InexactND, float]: ...

#
@overload  # +integer | ~float64
def expm(A: _AsFloat64ND) -> _Float64ND: ...
@overload  # +floating
def expm(A: onp.ToFloatND) -> _FloatND: ...
@overload  # ~complex128
def expm(A: onp.ToJustComplex128_ND) -> _Complex128ND: ...
@overload  # ~complexfloating
def expm(A: onp.ToJustComplexND) -> _ComplexND: ...
@overload  # +complexfloating
def expm(A: onp.ToComplexND) -> _InexactND: ...

#
def _exp_sinch(x: onp.ArrayND[_ComplexT, _ShapeT]) -> onp.ArrayND[_ComplexT, _ShapeT]: ...  # undocumented

#
@overload  # +integer | ~float64
def cosm(A: _AsFloat64ND) -> _Float64ND: ...
@overload  # +floating
def cosm(A: onp.ToFloatND) -> _FloatND: ...
@overload  # ~complex128
def cosm(A: onp.ToJustComplex128_ND) -> _Complex128ND: ...
@overload  # ~complexfloating
def cosm(A: onp.ToJustComplexND) -> _ComplexND: ...
@overload  # +complexfloating
def cosm(A: onp.ToComplexND) -> _InexactND: ...

#
@overload  # +integer | ~float64
def sinm(A: _AsFloat64ND) -> _Float64ND: ...
@overload  # +floating
def sinm(A: onp.ToFloatND) -> _FloatND: ...
@overload  # ~complex128
def sinm(A: onp.ToJustComplex128_ND) -> _Complex128ND: ...
@overload  # ~complexfloating
def sinm(A: onp.ToJustComplexND) -> _ComplexND: ...
@overload  # +complexfloating
def sinm(A: onp.ToComplexND) -> _InexactND: ...

#
@overload  # +integer | ~float64
def tanm(A: _AsFloat64ND) -> _Float64ND: ...
@overload  # +floating
def tanm(A: onp.ToFloatND) -> _FloatND: ...
@overload  # ~complex128
def tanm(A: onp.ToJustComplex128_ND) -> _Complex128ND: ...
@overload  # ~complexfloating
def tanm(A: onp.ToJustComplexND) -> _ComplexND: ...
@overload  # +complexfloating
def tanm(A: onp.ToComplexND) -> _InexactND: ...

#
@overload  # +integer | ~float64
def coshm(A: _AsFloat64ND) -> _Float64ND: ...
@overload  # +floating
def coshm(A: onp.ToFloatND) -> _FloatND: ...
@overload  # ~complex128
def coshm(A: onp.ToJustComplex128_ND) -> _Complex128ND: ...
@overload  # ~complexfloating
def coshm(A: onp.ToJustComplexND) -> _ComplexND: ...
@overload  # +complexfloating
def coshm(A: onp.ToComplexND) -> _InexactND: ...

#
@overload  # +integer | ~float64
def sinhm(A: _AsFloat64ND) -> _Float64ND: ...
@overload  # +floating
def sinhm(A: onp.ToFloatND) -> _FloatND: ...
@overload  # ~complex128
def sinhm(A: onp.ToJustComplex128_ND) -> _Complex128ND: ...
@overload  # ~complexfloating
def sinhm(A: onp.ToJustComplexND) -> _ComplexND: ...
@overload  # +complexfloating
def sinhm(A: onp.ToComplexND) -> _InexactND: ...

#
@overload  # +integer | ~float64
def tanhm(A: _AsFloat64ND) -> _Float64ND: ...
@overload  # +floating
def tanhm(A: onp.ToFloatND) -> _FloatND: ...
@overload  # ~complex128
def tanhm(A: onp.ToJustComplex128_ND) -> _Complex128ND: ...
@overload  # ~complexfloating
def tanhm(A: onp.ToJustComplexND) -> _ComplexND: ...
@overload  # +complexfloating
def tanhm(A: onp.ToComplexND) -> _InexactND: ...

#
@overload  # +float64, disp: True = ...
def funm(A: onp.ToFloat64_ND, func: _FuncND[np.float64], disp: onp.ToTrue = True) -> _Float64ND: ...
@overload  # +floating, disp: False
def funm(A: onp.ToFloat64_ND, func: _FuncND[np.float64], disp: onp.ToFalse) -> tuple[_Float64ND, float]: ...
@overload  # +complexfloating, disp: True = ...
def funm(A: onp.ToJustComplex128_ND, func: _FuncND[np.complex128], disp: onp.ToTrue = True) -> _Complex128ND: ...
@overload  # +complexfloating, disp: False
def funm(A: onp.ToJustComplex128_ND, func: _FuncND[np.complex128], disp: onp.ToFalse) -> tuple[_Complex128ND, float]: ...
@overload  # T: inexact, disp: True = ...
def funm(A: onp.CanArrayND[_InexactT], func: _FuncND[_InexactT], disp: onp.ToTrue = True) -> onp.ArrayND[_InexactT]: ...
@overload  # T: inexact, disp: False
def funm(A: onp.CanArrayND[_InexactT], func: _FuncND[_InexactT], disp: onp.ToFalse) -> tuple[onp.ArrayND[_InexactT], float]: ...

#
@overload  # +float64
def signm(A: _AsFloat64ND) -> _Float64ND: ...
@overload  # +floating
def signm(A: onp.ToFloatND) -> _FloatND: ...
@overload  # +complexfloating
def signm(A: onp.ToJustComplex128_ND) -> _Complex128ND: ...
@overload  # +complexfloating
def signm(A: onp.ToJustComplexND) -> _ComplexND: ...
@overload  # +complexfloating
def signm(A: onp.ToComplexND) -> _InexactND: ...
@overload  # +complexfloating, disp: True  (deprecated)
@deprecated("The `disp` argument is deprecated and will be removed in SciPy 1.18.0.")
def signm(A: onp.ToComplexND, disp: onp.ToTrue) -> _InexactND: ...
@overload  # +complexfloating, disp: False  (deprecated)
@deprecated(
    "The `disp` argument is deprecated and will be removed in SciPy 1.18.0. "
    "The previously returned error estimate can be computed as `norm(signm @ signm - signm, 1)`."
)
def signm(A: onp.ToComplexND, disp: onp.ToFalse) -> tuple[_InexactND, np.float64]: ...

#
@overload  # +integer | ~float64
def khatri_rao(a: onp.ToIntND, b: onp.ToIntND) -> _IntND: ...
@overload  # +float64, ~float64
def khatri_rao(a: onp.ToFloat64_ND, b: onp.ToJustFloat64_ND) -> _Float64ND: ...
@overload  # ~float64, +float64
def khatri_rao(a: onp.ToJustFloat64_ND, b: onp.ToFloat64_ND) -> _Float64ND: ...
@overload  # +floating, ~floating
def khatri_rao(a: onp.ToFloatND, b: onp.ToJustFloatND) -> _FloatND: ...
@overload  # ~floating, +floating
def khatri_rao(a: onp.ToJustFloatND, b: onp.ToFloatND) -> _FloatND: ...
@overload  # +complex128, ~complex128
def khatri_rao(a: onp.ToComplex128_ND, b: onp.ToJustComplex128_ND) -> _Complex128ND: ...
@overload  # ~complex128, +complex128
def khatri_rao(a: onp.ToJustComplex128_ND, b: onp.ToComplex128_ND) -> _Complex128ND: ...
@overload  # +complexfloating, ~complexfloating
def khatri_rao(a: onp.ToComplexND, b: onp.ToJustComplexND) -> _ComplexND: ...
@overload  # ~complexfloating, +complexfloating
def khatri_rao(a: onp.ToJustComplexND, b: onp.ToComplexND) -> _ComplexND: ...
@overload  # fallback
def khatri_rao(a: onp.ToComplexND, b: onp.ToComplexND) -> onp.ArrayND[Any]: ...
